/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.Tracer;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class VDNNumber {
    private static final int zeroExponentValue_C = 128;
    private static final int tensComplement_C = 9;
    private static final int numberBytes_C = 20;
    private static final int numberDigits_C = 38;
    private static final String zerostring = "0000000000000000000000000000000000000000000000000000000000000000";
    private static final int zeor10powindex = 64;
    private static final double[] double10pow = new double[]{1.0E-64, 1.0E-63, 1.0E-62, 1.0E-61, 1.0E-60, 1.0E-59, 1.0E-58, 1.0E-57, 1.0E-56, 1.0E-55, 1.0E-54, 1.0E-53, 1.0E-52, 1.0E-51, 1.0E-50, 1.0E-49, 1.0E-48, 1.0E-47, 1.0E-46, 1.0E-45, 1.0E-44, 1.0E-43, 1.0E-42, 1.0E-41, 1.0E-40, 1.0E-39, 1.0E-38, 1.0E-37, 1.0E-36, 1.0E-35, 1.0E-34, 1.0E-33, 1.0E-32, 1.0E-31, 1.0E-30, 1.0E-29, 1.0E-28, 1.0E-27, 1.0E-26, 1.0E-25, 1.0E-24, 1.0E-23, 1.0E-22, 1.0E-21, 1.0E-20, 1.0E-19, 1.0E-18, 1.0E-17, 1.0E-16, 1.0E-15, 1.0E-14, 1.0E-13, 1.0E-12, 1.0E-11, 1.0E-10, 1.0E-9, 1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23, 1.0E24, 1.0E25, 1.0E26, 1.0E27, 1.0E28, 1.0E29, 1.0E30, 1.0E31, 1.0E32, 1.0E33, 1.0E34, 1.0E35, 1.0E36, 1.0E37, 1.0E38, 1.0E39, 1.0E40, 1.0E41, 1.0E42, 1.0E43, 1.0E44, 1.0E45, 1.0E46, 1.0E47, 1.0E48, 1.0E49, 1.0E50, 1.0E51, 1.0E52, 1.0E53, 1.0E54, 1.0E55, 1.0E56, 1.0E57, 1.0E58, 1.0E59, 1.0E60, 1.0E61, 1.0E62, 1.0E63, 1.0E64};

    public static byte[] bigDecimal2number(BigDecimal bigDecimal) {
        return VDNNumber.bigDecimal2number(bigDecimal, 38);
    }

    public static String bigDecimal2PlainString(BigDecimal bigDecimal) {
        String string;
        int n = bigDecimal.scale();
        if (n < 0) {
            bigDecimal = bigDecimal.setScale(0);
            n = 0;
        }
        if (n == 0) {
            string = bigDecimal.toBigInteger().toString();
        } else {
            String string2 = bigDecimal.unscaledValue().abs().toString();
            String string3 = bigDecimal.signum() < 0 ? "-0." : "0.";
            int n2 = string2.length() - n;
            if (n2 == 0) {
                string = string3 + string2;
            } else if (n2 > 0) {
                StringBuffer stringBuffer = new StringBuffer(string2);
                stringBuffer.insert(n2, '.');
                if (bigDecimal.signum() < 0) {
                    stringBuffer.insert(0, '-');
                }
                string = stringBuffer.toString();
            } else {
                StringBuffer stringBuffer = new StringBuffer(3 - n2 + string2.length());
                stringBuffer.append(string3);
                for (int i = 0; i < -n2; ++i) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string2);
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    public static byte[] bigDecimal2number(BigDecimal bigDecimal, int n) {
        int n2;
        boolean bl;
        String string = VDNNumber.bigDecimal2PlainString(bigDecimal);
        int n3 = bigDecimal.scale() < 0 ? 0 : bigDecimal.scale();
        char[] cArray = string.toCharArray();
        int n4 = cArray.length;
        if (cArray[0] == '-') {
            bl = true;
            n2 = 1;
        } else {
            bl = false;
            n2 = 0;
        }
        while ((cArray[n2] == '0' || cArray[n2] == '.') && n2 < n4 - 1) {
            ++n2;
        }
        int n5 = cArray.length - n2 - n3;
        n4 = cArray.length - n2;
        if (n4 == 1 && cArray[n2] == '0') {
            return new byte[]{-128};
        }
        if (n5 > 0 && n3 > 0) {
            --n5;
            --n4;
            System.arraycopy(cArray, cArray.length - n3, cArray, cArray.length - n3 - 1, n3);
        }
        if (n4 > n) {
            if (cArray[n2 + n] >= '5') {
                int n6 = n2 + n;
                cArray[n6] = (char)(cArray[n6] + '\u0001');
            }
            n4 = n;
        }
        int n7 = n2;
        while (n7 < n4 + n2) {
            int n8 = n7++;
            cArray[n8] = (char)(cArray[n8] - 48);
        }
        byte[] byArray = new byte[n4 + 1];
        VDNNumber.packDigits(cArray, n2, n4, bl, byArray);
        n5 = bl ? 64 - n5 : (n5 += 192);
        byArray[0] = (byte)n5;
        return byArray;
    }

    public static byte[] long2number(long l) {
        boolean bl = false;
        int n = 1;
        char[] cArray = new char[39];
        int n2 = 37;
        if (l == 0L) {
            return new byte[]{-128};
        }
        if (l < 0L) {
            n = -1;
            bl = true;
        }
        while (l != 0L) {
            char c;
            cArray[n2] = c = (char)((long)n * (l % 10L));
            l /= 10L;
            --n2;
        }
        int n3 = 38 - n2 - 1;
        byte[] byArray = new byte[38 - ++n2 + 1];
        VDNNumber.packDigits(cArray, n2, 38 - n2, bl, byArray);
        n3 = bl ? 64 - n3 : (n3 += 192);
        byArray[0] = (byte)n3;
        return byArray;
    }

    public static BigDecimal number2BigDecimal(byte[] byArray) throws SQLException {
        BigDecimal bigDecimal = null;
        int n = (byArray.length - 1) * 2;
        int n2 = 2;
        try {
            int n3;
            int n4 = byArray[0] & 0xFF;
            if (n4 == 128) {
                return new BigDecimal(0.0);
            }
            byte[] byArray2 = new byte[n + 2];
            if (n4 < 128) {
                n3 = -(n4 - 64);
                byArray2[0] = 45;
                byArray2[1] = 46;
                for (int i = 1; i < byArray.length; ++i) {
                    int n5 = ((char)byArray[i] & 0xFF) >> 4;
                    if (n5 != 0) {
                        n2 = i * 2;
                    }
                    byArray2[i * 2] = (byte)(9 - n5 + 48);
                    n5 = (char)byArray[i] & 0xF;
                    if (n5 != 0) {
                        n2 = i * 2 + 1;
                    }
                    byArray2[i * 2 + 1] = (byte)(9 - n5 + 48);
                }
                int n6 = n2;
                byArray2[n6] = (byte)(byArray2[n6] + 1);
            } else {
                n3 = n4 - 192;
                byArray2[0] = 48;
                byArray2[1] = 46;
                for (int i = 1; i < byArray.length; ++i) {
                    int n7 = ((char)byArray[i] & 0xFF) >> 4;
                    if (n7 != 0) {
                        n2 = i * 2;
                    }
                    byArray2[i * 2] = (byte)(n7 + 48);
                    n7 = (char)byArray[i] & 0xF;
                    if (n7 != 0) {
                        n2 = i * 2 + 1;
                    }
                    byArray2[i * 2 + 1] = (byte)(n7 + 48);
                }
            }
            String string = new String(byArray2, 0, n2 + 1);
            bigDecimal = new BigDecimal(string);
            bigDecimal = bigDecimal.movePointRight(n3);
            return bigDecimal;
        }
        catch (Exception exception) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.conversion.VDNnumber", Tracer.Hex2String(byArray)));
        }
    }

    public static double shortnumber2Double(byte[] byArray) throws SQLException {
        try {
            int n;
            boolean bl;
            int n2;
            long l = 0L;
            int n3 = byArray[0] & 0xFF;
            if (n3 == 128) {
                return 0.0;
            }
            if (n3 < 128) {
                n2 = -(n3 - 64);
                bl = true;
                int n4 = 1;
                for (int i = 1; i < byArray.length; ++i) {
                    n = (byArray[i] & 0xFF) >> 4;
                    if (n == 9) {
                        ++n4;
                    } else {
                        l = (long)((double)l * double10pow[n4 + 64]);
                        n2 -= n4;
                        n4 = 1;
                        l += (long)(9 - n);
                    }
                    n = byArray[i] & 0xF;
                    if (n == 9) {
                        ++n4;
                        continue;
                    }
                    l = (long)((double)l * double10pow[n4 + 64]);
                    n2 -= n4;
                    n4 = 1;
                    l += (long)(9 - n);
                }
                ++l;
            } else {
                n2 = n3 - 192;
                bl = false;
                int n5 = 1;
                for (int i = 1; i < byArray.length; ++i) {
                    n = (byArray[i] & 0xF0) >>> 4;
                    if (n == 0) {
                        ++n5;
                    } else {
                        l = (long)((double)l * double10pow[n5 + 64]);
                        n2 -= n5;
                        n5 = 1;
                        l += (long)n;
                    }
                    n = byArray[i] & 0xF;
                    if (n == 0) {
                        ++n5;
                        continue;
                    }
                    l = (long)((double)l * double10pow[n5 + 64]);
                    n2 -= n5;
                    n5 = 1;
                    l += (long)n;
                }
            }
            double d = l;
            d *= double10pow[n2 + 64];
            if (bl) {
                d = -d;
            }
            return d;
        }
        catch (Exception exception) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.conversion.VDNnumber", Tracer.Hex2String(byArray)));
        }
    }

    public static long number2long(byte[] byArray) throws SQLException {
        boolean bl;
        long l = 0L;
        int n = byArray.length * 2 - 2;
        int n2 = byArray[0] & 0xFF;
        if (n2 == 128) {
            return 0L;
        }
        if (n2 < 128) {
            int n3 = -(n2 - 64);
            if (n3 < 0 || n3 > n) {
                BigDecimal bigDecimal = VDNNumber.number2BigDecimal(byArray);
                return bigDecimal.longValue();
            }
            bl = true;
            for (int i = 0; i < n3; ++i) {
                int n4 = byArray[i / 2 + 1];
                if (i % 2 == 0) {
                    n4 &= 0xF0;
                    n4 >>>= 4;
                } else {
                    n4 &= 0xF;
                }
                l *= 10L;
                l += (long)(9 - n4);
            }
            ++l;
        } else {
            int n5 = n2 - 192;
            if (n5 < 0 || n5 > n) {
                BigDecimal bigDecimal = VDNNumber.number2BigDecimal(byArray);
                return bigDecimal.longValue();
            }
            bl = false;
            for (int i = 0; i < n5; ++i) {
                int n6 = byArray[i / 2 + 1];
                if (i % 2 == 0) {
                    n6 &= 0xF0;
                    n6 >>>= 4;
                } else {
                    n6 &= 0xF;
                }
                l *= 10L;
                l += (long)n6;
            }
        }
        if (bl) {
            l = -l;
        }
        return l;
    }

    public static int number2int(byte[] byArray) throws SQLException {
        return (int)VDNNumber.number2long(byArray);
    }

    private static void packDigits(char[] cArray, int n, int n2, boolean bl, byte[] byArray) {
        int n3;
        int n4 = n + n2 - 1;
        if (bl) {
            for (n3 = n; n3 < n4; ++n3) {
                cArray[n3] = (char)(9 - cArray[n3]);
            }
            cArray[n4] = (char)(10 - cArray[n4]);
            n3 = n4;
            while (cArray[n3] == '\n') {
                cArray[n3] = '\u0000';
                int n5 = n3 - 1;
                cArray[n5] = (char)(cArray[n5] + '\u0001');
                --n3;
            }
        }
        n3 = 1;
        while (n <= n4) {
            byte by = (byte)cArray[n];
            byte by2 = n + 1 <= n4 ? (byte)cArray[n + 1] : (byte)0;
            byArray[n3] = (byte)(by << 4 | by2);
            ++n3;
            n += 2;
        }
    }

    public static String number2string(byte[] byArray, boolean bl, int n, int n2) throws SQLException {
        try {
            int n3;
            int n4;
            int n5;
            int n6 = byArray[0] & 0xFF;
            if (n6 == 128) {
                return "0";
            }
            char[] cArray = new char[n];
            int n7 = 0;
            boolean bl2 = false;
            if (n6 < 128) {
                bl2 = true;
                n5 = -(n6 - 64);
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 % 2 == 0 ? (byArray[1 + n4 / 2] & 0xFF) >> 4 : byArray[1 + n4 / 2] & 0xF;
                    if (n3 != 0) {
                        n7 = n4;
                    }
                    cArray[n4] = (char)(9 - n3 + 48);
                }
                int n8 = n7;
                cArray[n8] = (char)(cArray[n8] + '\u0001');
            } else {
                n5 = n6 - 192;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n4 % 2 == 0 ? (byArray[1 + n4 / 2] & 0xFF) >> 4 : byArray[1 + n4 / 2] & 0xF;
                    if (n3 != 0) {
                        n7 = n4;
                    }
                    cArray[n4] = (char)(n3 + 48);
                }
            }
            String string = bl2 ? "-" : "";
            String string2 = new String(cArray, 0, n7 + 1);
            if (bl) {
                if (n5 > 0) {
                    if (string2.length() < n) {
                        string2 = string2 + zerostring.substring(0, n - string2.length());
                    }
                    if (n2 != 0) {
                        return string + string2.substring(0, n5) + "." + string2.substring(n5, n5 + n2);
                    }
                    return string + string2.substring(0, n5);
                }
                int n9 = n2 - -n5 - string2.length();
                if (n9 < 0) {
                    n9 = 0;
                }
                return string + "0." + zerostring.substring(0, -n5) + string2 + zerostring.substring(0, n9);
            }
            if (n5 < -3 || n5 > 7) {
                return string + "0." + string2 + "E" + n5;
            }
            switch (n5) {
                case -3: {
                    return string + "0.000" + string2;
                }
                case -2: {
                    return string + "0.00" + string2;
                }
                case -1: {
                    return string + "0.0" + string2;
                }
                case 0: {
                    return string + "0." + string2;
                }
            }
            if (string2.length() <= n5) {
                return string + string2 + zerostring.substring(0, n5 - string2.length());
            }
            return string + string2.substring(0, n5) + "." + string2.substring(n5);
        }
        catch (Exception exception) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.conversion.VDNnumber", Tracer.Hex2String(byArray)));
        }
    }

    public static void dumpVDN(String string, byte[] byArray) {
        StructuredBytes structuredBytes = new StructuredBytes(byArray);
        System.out.println(string);
        structuredBytes.traceOn(System.out);
    }
}

