
// This file contains MA TUT test cases for myx_backup.c
//
//

//----------------------------------------------------------------------------------------------------------------------

#include <fstream>

#include "test.h"
#include "myx_admin_library.h"
#include "myx_shared_util_functions.h"

// Private test data.
BEGIN_TEST_DATA_CLASS(myx_admin_library_test_module)
protected:
  Test_connection* connection;
END_TEST_DATA_CLASS

TEST_MODULE(myx_admin_library_test_module, "MySQL Administrator test suite");

//----------------------------------------------------------------------------------------------------------------------

/*
  Prepares all needed data structures etc. for the tests in this module (including a backup context).
*/

TEST_FUNCTION(5)
{
  connection= test_group_singleton.get_connection();
  ensure("Server connection", connection != NULL);
}

//----------------------------------------------------------------------------------------------------------------------

/*
  Test for bug #23325
*/
TEST_FUNCTION(10)
{
  ensure("Cannot set global variable",
    myx_set_variable(connection->get_mysql(), "tx_isolation", "REPEATABLE-READ") == 0);
}

//----------------------------------------------------------------------------------------------------------------------

TEST_FUNCTION(500)
{
}

//----------------------------------------------------------------------------------------------------------------------

END_TESTS;

//----------------------------------------------------------------------------------------------------------------------

