//
//  mxUtils.m
//  MySQLGUICommon
//
//  Created by Alfredo Kojima on 9/20/04.
//  Copyright 2004 MySQL AB. All rights reserved.
//

#import "mxUtils.h"

#define N_(s) s


NSString *MXGetErrorString(MYX_LIB_ERROR error)
{
  static NSString *msgs[]= {
    @"",
    N_(@"Can't open file."),
    N_(@"Can't connect to server instance."),
    N_(@"Error parsing XML file."),
    N_(@"Error parsing XML file (bad document)."),
    N_(@"Error parsing XML file (empty document)."),
    N_(@"Error executing SQL command."),
    N_(@"Executing stopped."),
    N_(@"Internal error in libxml (could not change memory allocators)."),
    N_(@"The object was not found in the database."),
    N_(@"Cannot read from file."),
    N_(@"Error during character set conversion."),
    N_(@"Invalid character set specified.")
  };

  if (error < sizeof(msgs)/sizeof(NSString*))
    return NSLocalizedString(msgs[error], nil);
  else
    return @"Unknown error.";
}


void MXRunAlertPanelWithError(NSString *title, NSString *message, MYX_LIB_ERROR error)
{
  NSString *errmsg= MXGetErrorString(error);
  
  NSRunAlertPanel(title, @"%@\n%@", nil, nil, nil, message, 
                  errmsg,nil);
}

void MXRunAlertPanelWithMySQLError(NSString *title, NSString *message, MYSQL *mysql)
{
  char *tmp;
  NSRunAlertPanel(title, @"%@\n%s (error %i)", nil, nil, nil, message, 
                  tmp= myx_mysql_error(mysql), myx_mysql_errno(mysql));
  g_free(tmp);
}


NSImage *MXGetImageFromBundle(NSBundle *bundle, NSString *image)
{
  NSString *path= [bundle pathForResource:[image stringByDeletingPathExtension]
                                   ofType:[image pathExtension]];
  if (!path)
    return nil;
  
  return [[[NSImage alloc] initWithContentsOfFile:path] autorelease];
}


void MXExpandOutline(NSOutlineView *outline, BOOL expandChildren)
{
  id ds= [outline dataSource];
  id item;
  int i;
  int count= [ds outlineView:outline numberOfChildrenOfItem:nil];

  for (i= 0; i < count; i++)
  {
    item= [ds outlineView:outline child:i ofItem:nil];
    [outline expandItem:item expandChildren:expandChildren];
  }
}
