/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/**
 * @file myx_gc_style.h 
 * @brief Implementation of the style class.
 * 
 */

#ifndef __GC_STYLE_H__
#define __GC_STYLE_H__

#include "myx_gc_datatypes.h"
#include "myx_gc_figure.h"

//----------------------------------------------------------------------------------------------------------------------

class CSVGParser;

/** A compiled style with its associated bounding box. */
class CGCStyle
{
  friend class CSVGParser;
private:
  TBoundingBox FBoundingBox;      // The box that covers the whole content of this style.
  GLuint FDisplayList;            // An OpenGL display list to render this style element.
  CElementSet FListeners;         // A list of figure elements, which use this style.
  bool FDestroying;               // True, when the class is being destroyed (don't add/remove listeners anymore, etc.).
public:
  CGCStyle(void);

  void AddListener(CFigureElement* Element);
  TBoundingBox* BoundingBox(void);
  GLuint DisplayList(void);
  void RemoveListener(CFigureElement* Element);
};

//----------------------------------------------------------------------------------------------------------------------

#endif // __GC_STYLE_H__
