#import "MAServerLogs.h"
#import "MAServerLogView.h"
#include "mahelper.h"


@implementation MAServerLogs

- (char*)performOpenCommand:(MAHelperCommandType)command
					forFile:(int*)fd
				  withRight:(const char*)rightName
{
  NSString *helperPath;
  AuthorizationItem right = { rightName, 0, NULL, 0 };
  AuthorizationRights rightSet = { 1, &right };
  OSStatus status;
  MAHelperCommand cmd= {command, 0};
  
  helperPath= [[NSBundle bundleForClass:[self class]] pathForResource:@"mahelper"
															   ofType:@""];
  if (!_authRef)
  {
	if (AuthorizationCreate(NULL, kAuthorizationEmptyEnvironment, kAuthorizationFlagDefaults, 
							&_authRef)!=errAuthorizationSuccess)
	{
	  NSLog(@"Could not create authorization reference object.");
	  return NULL;
	}
  }
  
  status = AuthorizationCopyRights(_authRef, &rightSet, kAuthorizationEmptyEnvironment, 
								   kAuthorizationFlagDefaults | kAuthorizationFlagPreAuthorize
								   | kAuthorizationFlagInteractionAllowed | kAuthorizationFlagExtendRights,
								   NULL);
  
  if (status == errAuthorizationSuccess)
  {
    int hstatus;
	char *error_message= NULL;
	
    hstatus = mhelperPerformOpenCommand(_authRef, [helperPath fileSystemRepresentation], cmd,
										fd, &error_message);
	
    if (hstatus != MAHelperCommandSuccess || fd < 0)
	{
	  *fd= -1;
	}
	return error_message;
  }
  else
  {
	AuthorizationFree(_authRef, kAuthorizationFlagDestroyRights);
	_authRef= 0;
	*fd= -1;
	return NULL;
  }
}


+ (NSImage*)icon
{
  return [NSImage imageNamed:@"OSX-Icons_43.png"];
}

+ (NSString*)label
{
  return @"Logs";
}

+ (NSString*)toolTip
{
  return @"View MySQL Server Logs.";
}


- (id)initWithOwner: (id<MAdministratorProtocol>)owner
{
  self= [super initWithNibFile: @"ServerLogs" panelOwner: owner];
  if (self)
  {
    _defaultFrame= [[self topView] frame];
  
    [tabView removeTabViewItem:[tabView tabViewItemAtIndex:0]];  
	
	if (![_owner isLocal])
	{
	  [tabView setHidden:YES];
	  [bigText setHidden:NO];
	}
	else
	{
	  [tabView setHidden:NO];
	  [bigText setHidden:YES];
	}
  }
  return self;
}

- (void)dealloc
{
  if (_authRef)
  	AuthorizationFree(_authRef, kAuthorizationFlagDestroyRights);
  [_pages release];
  
  [super dealloc];
}

- (void)didShow
{
  if (!_pages)
  {
    NSString *host;
    char buffer[1024];
    _pages= [[NSMutableArray alloc] init];
   
    if (gethostname(buffer, sizeof(buffer)) < 0)
    {
      // Very slow! so only use as a fallback
      host= [[NSHost currentHost] name];
    }
    else
      host= [NSString stringWithCString:buffer];
  
    [self createPage: @"Error Log"
			withType: MAHelperOpenErrorLog
       parseFunction: myx_parse_error_logf];
	
	[self createPage: @"General Log"
			withType: MAHelperOpenGeneralLog
       parseFunction: myx_parse_general_logf];

	[self createPage: @"Slow Log"
			withType: MAHelperOpenSlowLog
       parseFunction: myx_parse_slow_logf];	
  }
}

- (void)createPage:(NSString*)name
          withType:(int)type
     parseFunction:(MALogParserFunction)func
{
  char *error= NULL;
  int fd= -1;
  MAServerLogView *view;
  
  error= [self performOpenCommand:type
						  forFile:&fd
						withRight:"com.mysql.administrator.read_log"];

  view= [[[MAServerLogView alloc] initWithFile:fd < 0 ? NULL : fdopen(fd, "r")
										  path:(fd < 0 || !error) ? @"" : [NSString stringWithUTF8String:error]
										 error:(fd < 0 && error) ? [NSString stringWithUTF8String:error] : nil
										parser:func] autorelease];
  
  if (![NSBundle loadNibNamed:@"ServerLogView" owner:view])
  {
    NSRunAlertPanel(nil,@"Could not instantiate interface for log viewing.",
                    nil, nil, nil);
  }
  else
  {
    NSTabViewItem *item= [[[NSTabViewItem alloc] initWithIdentifier:name] autorelease];

    [item setLabel:name];
    [_pages addObject:view];
    [item setView:[view topView]];
    [tabView addTabViewItem:item];
  }
  
  if (error)
	free(error);
}

@end
