<?php
/**
 * $Id: dump.php,v 1.9 2003/03/26 08:31:28 courou Exp $
 *
 * Gnration d'un fichier SYLK  partir de donnes MySQL en vue d'une rcupration sous Excel.
 * L'avantange du format SYLK par rapport au format CSV est qu'il permet de dfinir des attributs
 * de mise en forme pour les donnes : alignement,gras, itallique, formats de donnes, ..
 * Auteur: J-Pierre DEZELUS
 * Email:  jpdezelus&#64;phpinfo.net
 * Web:    http://www.phpinfo.net/
 *
 * Date:  02/12/2001
 * Adaptation: Courou -- MyPhpMoney
 * Web:    http://allreponse.ath.cx
 * Email:  courou&#64;users.sourceforge.net
 *
 * Support    : http://sourceforge.net/projects/myphpmoney/
 * CVS        : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/myphpmoney/
 */

/**
 * INCLUDE FILE
 */
     require_once 'config/settings.inc.php';

/**
 * ENTER IN THE SESSION OR BUILD THE LOGIN FORM
 */
     if (SQL_VerifSession()) {

/**
 * DEFINES VARIABLES FOR THE EXCEL FILE
 */
      define('__ALIGN_RIGHT__',                           'R'); ## ALIGN RIGHT
      define('__ALIGN_LEFT__',                            'L'); ## ALIGN LEFT
      define('__ALIGN_CENTER__',                          'C'); ## ALIGN CENTER
      define('__FORMAT_REEL__',                             1); ## #,##0.00
      define('__FORMAT_ENTIER__',                           2); ## #,##0
      define('__FORMAT_TEXTE__',                            3); ## @

      $DEFINE_SYLK_FORMATS[__FORMAT_REEL__]            = 'FF2'; ## FORMAT_REEL
      $DEFINE_SYLK_FORMATS[__FORMAT_ENTIER__]          = 'FF0'; ## FORMAT_ENTIER
      $DEFINE_SYLK_FORMATS[__FORMAT_TEXTE__]           = 'FG0'; ## FORMAT_TEXTE

/**
 * DATABASE QUERY
 */
if (isset($db)) {
    $CPTES = urlencode(SQL_NameAccount((isset($_GET['ID']) ? $_GET['ID'] : '' )));
    if ($CPTES == '') $CPTES ='ALL';

    // need becasue usage sprintf (problem %m %Y -:)
    $pre_requete  = "
            SELECT
               ".$_MPM['table'][1].".OPID,
               ".$_MPM['table'][1].".DATES,
               ".$_MPM['table'][0].".CAT,
               ".$_MPM['table'][1].".NUMID,
               ".$_MPM['table'][4].".THIRD,
               ".$_MPM['table'][1].".COMMENTS,
               ".$_MPM['table'][1].".OUT,
               ".$_MPM['table'][1].".IMP,
               ".$_MPM['table'][2].".ACCOUNT,
               ".$_MPM['table'][1].".BALANCE AS BALANCE,
               DATE_FORMAT(".$_MPM['table'][1].".DATES,'%m-%Y') AS N_DATES";
    $requete  = "
            FROM
               ".$_MPM['table'][0].",
               ".$_MPM['table'][1].",
               ".$_MPM['table'][2].",
               ".$_MPM['table'][3].",
               ".$_MPM['table'][4]."
            WHERE
               ".$_MPM['table'][1].".TEMPID=1
               AND ".$_MPM['table'][1].".ACCOUNT %s '%s'
               AND ".$_MPM['table'][1].".USERID='$sess_pid'
               AND ".$_MPM['table'][0].".USERID='$sess_pid'
               AND ".$_MPM['table'][0].".CATID=".$_MPM['table'][1].".CAT
               AND ".$_MPM['table'][4].".THIRDID=".$_MPM['table'][1].".THIRD
               AND ".$_MPM['table'][2].".ACCOUNTID=".$_MPM['table'][1].".ACCOUNT
               AND ".$_MPM['table'][1].".USERID=".$_MPM['table'][3].".USERID
               ORDER BY N_DATES,
               ".$_MPM['table'][1].".ACCOUNT,
               ".$_MPM['table'][1].".OPID ASC";

    if (isset($_GET['SAUV']) && $_GET['SAUV'] == 'ALL') {
      $sql = $pre_requete.''.sprintf($requete,'<>','');
    } else {
      $sql = $pre_requete.''.sprintf($requete,'=',$_GET['ID']);
    }

$db->query($sql);
if ($db->num_rows() >= 0) {

/**
 *              CHAMPS         EN-TETE                        FORMAT                 ALIGN                WIDTH
 */
 $champs =
     array
     (
         array('OPID',         $_VAR['LANG_ACCOUNT_2'],    __FORMAT_TEXTE__,      __ALIGN_CENTER__,       20),
         array('DATES',        $_VAR['SIMUL_FORM_2'],      __FORMAT_TEXTE__,      __ALIGN_CENTER__,       10),
         array('CAT',          $_VAR['LANG_ACCOUNT_5'],    __FORMAT_TEXTE__,      __ALIGN_CENTER__,       45),
         array('NUMID',        $_VAR['LANG_ACCOUNT_21'],   __FORMAT_TEXTE__,      __ALIGN_CENTER__,       25),
         array('THIRD',        $_VAR['LANG_ACCOUNT_6'],    __FORMAT_TEXTE__,      __ALIGN_CENTER__,       45),
         array('COMMENTS',     $_VAR['LANG_ACCOUNT_7'],    __FORMAT_TEXTE__,      __ALIGN_CENTER__,       45),
         array('OUT',          $_VAR['LANG_ACCOUNT_17'],   __FORMAT_REEL__,       __ALIGN_CENTER__,       15),
         array('IMP',          $_VAR['LANG_ACCOUNT_18'],   __FORMAT_REEL__,       __ALIGN_CENTER__,       15),
         array('ACCOUNT',      $_VAR['LANG_ACCOUNT_4'],    __FORMAT_TEXTE__,      __ALIGN_CENTER__,       15),
         array('BALANCE',      $_VAR['LANG_BOOK_3'],       __FORMAT_REEL__,       __ALIGN_CENTER__,       15)
     );

/**
 *  EN-TETE HTTP
 */
        $tools->Construc_header($sess_user.'-'.$CPTES.'.slk');
/**
 *  EN-TETE FILE
 */
        $excel_file  =  "ID;MYPHPMONEY\n"; ## ID;Pappli
        $excel_file .=  "\n";
/**
 *  FORMATS
 */
        $excel_file .=  "P;PGeneral\n";
        $excel_file .=  "P;P#,##0.00\n";       ## P;Pformat_1 (reels)
        $excel_file .=  "P;P#,##0\n";          ## P;Pformat_2 (entiers)
        $excel_file .=  "P;P@\n";              ## P;Pformat_3 (textes)
        $excel_file .=  "\n";
/**
 *  POLICE
 */
        $excel_file .=  "P;EArial;M200\n";
        $excel_file .=  "P;EArial;M200\n";
        $excel_file .=  "P;EArial;M200\n";
        $excel_file .=  "P;FArial;M200;SB\n";
        $excel_file .=  "\n";
/**
 *  NUMBER OF LIGNES * NUMBERS OF COLUMN
 */
        $excel_file .=  "B;Y".($db->num_rows() + 1);
        $excel_file .=  ";X".($nbcol =  count($champs))."\n"; ## B;Yligmax;Xcolmax
        $excel_file .=  "\n";
/**
 *  RECOVERY OF THE INFORMATION OF FORMATTING
 */
        for ($cpt = 0; $cpt < $nbcol; $cpt++) {
            $num_format[$cpt] = $champs[$cpt][2];
            $format[$cpt]     = $DEFINE_SYLK_FORMATS[ $num_format[$cpt] ] . $champs[$cpt][3];
        }
/**
 *  WIDTH OF THE COLUMNS
 */
        for ($cpt = 1; $cpt <= $nbcol; $cpt++) {
            $excel_file .=  "F;W".$cpt." ".$cpt." ".$champs[$cpt-1][4]."\n";
        }
        $excel_file .=  "F;W".$cpt." 256 8\n"; ## F;Wcoldeb colfin largeur
        $excel_file .=  "\n";
/**
 *  EN-TETE OF THE COLUMNS (BOLD --> SDM4)
 */
        for ($cpt = 1; $cpt <= $nbcol; $cpt++) {
            $excel_file .=  "F;SDM4;FG0C;".($cpt == 1 ? "Y1;" : "")."X".$cpt."\n";
            $excel_file .=  "C;N;K\"".$champs[$cpt-1][1]."\"\n";
        }
        $excel_file .=  "\n";
/**
 *  THE DATAS
 */
        $ligne = 2;
        $enr[] = array();
        while ($db->next_record()) {
/**
 *  THE FIELDS
 */
        for ($cpt = 0; $cpt < $nbcol; $cpt++) {
        ## Ajout du 24/11/2002 (suite a modif phplib)
        $enr[$cpt] = $db->f($champs[$cpt][0]);
/**
 *  FORMAT
 */
        $excel_file .=  "F;P".$num_format[$cpt].";".$format[$cpt];
        $excel_file .=  ($cpt == 0 ? ";Y".$ligne : "").";X".($cpt+1)."\n";
/**
 * VALUE
 */
        if ($num_format[$cpt] == __FORMAT_TEXTE__)
           $excel_file .=  "C;N;K\"".str_replace(';', ';;', $enr[$cpt])."\"\n"; ## ajout des ""
        else
          $excel_file .=  "C;N;K".$enr[$cpt]."\n";
        }
       $excel_file .=  "\n";
 $ligne++;
} ## end of while ($enr = $db->next_record())

/**
 * END OF THE FILE
 */
        $excel_file .=  "E\n";
        }
} ## end of if (isset($db))

     echo $excel_file;
     page_close();
     } else {
          XHTML_DisplayLogin();
     XHTML_footer();
     } ## end if (SQL_VerifSession())