// actioncallback.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// This replaces the antiquated macro nonsense in Interviews/action.h.  An
// ActionCallback<T> object encapsulates function callbacks which take no 
// parameters and return void.

#include <InterViews/action.h>
#include "localdefs.h"

#undef ActionCallback	/* undo action.h stuff */

template <class T>
class ActionCallback : public Action {
public:
	ActionCallback(T* t, void (T::*fun)()) : myObject(t), myFunction(fun) {}
	redefined void execute() { (myObject->*myFunction)(); }
private:
	T* myObject;
	void (T::*myFunction)();
};

