//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: xml.h,v 1.2 2001/11/20 15:19:32 muse Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __XML_H__
#define __XML_H__

#include <stdio.h>
#include <qstring.h>

//---------------------------------------------------------
//   Xml
//    very simple XML-like parser
//---------------------------------------------------------

class Xml {
      FILE* f;
      int _line;
      int _col;
      QString _s1, _s2, _tag;
      int level;
      bool inTag;
      int c;            // current char
      char lbuffer[512];
      const char* bufptr;

      void next();
      void nextc();
      void token(int);
      void stoken();
      QString strip(const QString& s);
      void putLevel(int n);

   public:
      enum Token {Error, TagStart, TagEnd, Flag,
         Proc, Text, Attribut, End};
      Xml(FILE*);
      Xml(const char*);
      Token parse();
      QString parse(const QString&);
      QString parse1();
      int parseInt();
      double parseDouble();
      void unknown(const char*);
      int line() const    { return _line; }    // current line
      int col()  const    { return _col; }     // current col
      const QString& s1() { return _s1; }
      const QString& s2() { return _s2; }

      void header();
      void put(const char* format, ...);
      void put(int level, const char* format, ...);
      void nput(int level, const char* format, ...);
      void nput(const char* format, ...);
      void tag(int level, const char* format, ...);
      void etag(int level, const char* format, ...);
      void intTag(int level, const char* const name, int val);
      void doubleTag(int level, const char* const name, double val);
      void strTag(int level, const char* const name, const char* val);
      void strTag(int level, const char* const name, const QString& s);
      };

#endif

