//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: noteinfo.h,v 1.2 2001/11/20 15:19:35 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __NOTE_INFO_H__
#define __NOTE_INFO_H__

#include "desk.h"

class PosEdit;
class QSpinBox;
class PitchEdit;

class NoteInfo : public ToolBar {
      PosEdit* selTime;
      QSpinBox* selLen;
      PitchEdit* selPitch;
      QSpinBox* selVelOn;
      QSpinBox* selVelOff;
      QSpinBox* selChannel;

      Q_OBJECT

   public:
      enum ValType {VAL_TIME, VAL_LEN, VAL_VELON, VAL_VELOFF, VAL_CHANNEL, VAL_PITCH };
      NoteInfo(MainWindow* parent);
      void setValues(int, int, int, int, int, int);

   private:
   private slots:
      void lenChanged(int);
      void velOnChanged(int);
      void velOffChanged(int);
      void channelChanged(int);
      void pitchChanged(int);

   public slots:
      void setValue(ValType, int);

   signals:
      void valueChanged(NoteInfo::ValType, int);
      };
#endif

