//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: organgui.h,v 1.4 2001/11/27 08:16:26 muse Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __ORGANGUI_H__
#define __ORGANGUI_H

#include "organguibase.h"
#include "driver/midirawin.h"
#include "organ.h"

class QLineEdit;
class MidiDecoder;
class QListBoxItem;
class Preset;
class QString;
class QSignalMapper;

struct SynthGuiCtrl  {
      enum EditorType { SLIDER, SWITCH };
      QWidget* editor;
      QWidget* label;
      EditorType type;
      SynthGuiCtrl() {}
      SynthGuiCtrl(QWidget* w, QWidget* l, const EditorType t)
         : editor(w), label(l), type(t) {}
      };

//---------------------------------------------------------
//   OrganGui
//---------------------------------------------------------

class OrganGui : public OrganGuiBase, public MidiRawIn {
      QSignalMapper* map;
      int ctrlHi;
      int ctrlLo;
      int dataHi;
      int dataLo;
      SynthGuiCtrl dctrl[NUM_CONTROLLER];

      Q_OBJECT
      void sendControllerChange(int ctrl, int val);
      void initParameter();
      void setParam(int, int);
      void setPreset(Preset* preset);
      void addNewPreset(const QString&);
      void activatePreset(Preset* preset);

   private slots:
      void closeEvent(QCloseEvent*);
      void readStdin(int);
      void ctrlChanged(int idx);

      void presetClicked(QListBoxItem*);
      void setPreset();
      void loadPresetsPressed();
      void savePresetsPressed();

   protected:
      virtual void sysexReceived(const unsigned char*, int);
      virtual void eventReceived(int, int, int);

   public:
      OrganGui();
      };

#endif


