//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: midiitransform.h,v 1.1 2001/11/29 11:19:34 muse Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __MIDIITRANSFORM_H__
#define __MIDIITRANSFORM_H__

#include "itransformbase.h"

class QListBoxItem;
class MidiTransformation;
class MidiInputTransformPrivate;
class MidiEvent;
class MidiPart;
class Xml;

#include "miditransform.h"

//---------------------------------------------------------
//   MidiInputTransform
//---------------------------------------------------------

class MidiInputTransformDialog : public MidiInputTransformDialogBase {
      Q_OBJECT
      MidiInputTransformPrivate* data;

      virtual void accept();
      virtual void reject();
      void setValOp(QWidget* a, QWidget* b, ValOp op);
      void changeModul(int k);
      virtual void closeEvent(QCloseEvent*);

   signals:
      void hideWindow();

   private slots:
      void presetNew();
      void presetDelete();

      void selEventOpSel(int);
      void selTypeSel(int);
      void selVal1OpSel(int);
      void selVal2OpSel(int);
      void procEventOpSel(int);
      void procEventTypeSel(int);
      void procVal1OpSel(int);
      void procVal2OpSel(int);
      void funcOpSel(int);
      void presetChanged(QListBoxItem*);
      void nameChanged(const QString&);
      void commentChanged();
      void selVal1aChanged(int);
      void selVal1bChanged(int);
      void selVal2aChanged(int);
      void selVal2bChanged(int);
      void procVal1aChanged(int);
      void procVal1bChanged(int);
      void procVal2aChanged(int);
      void procVal2bChanged(int);
      void modul1selectChanged(bool);
      void modul1enableChanged(bool);
      void modul2selectChanged(bool);
      void modul2enableChanged(bool);
      void modul3selectChanged(bool);
      void modul3enableChanged(bool);
      void modul4selectChanged(bool);
      void modul4enableChanged(bool);

      void selPortOpSel(int);
      void selPortValaChanged(int);
      void selPortValbChanged(int);
      void selChannelOpSel(int);
      void selChannelValaChanged(int);
      void selChannelValbChanged(int);
      void procPortOpSel(int);
      void procPortValaChanged(int);
      void procPortValbChanged(int);
      void procChannelOpSel(int);
      void procChannelValaChanged(int);
      void procChannelValbChanged(int);

   public:
      MidiInputTransformDialog(QWidget* parent = 0, const char* name = 0,
         bool modal = false, WFlags fl = 0);
      ~MidiInputTransformDialog();
      };

extern void writeMidiInputTransforms(int level, Xml& xml);
extern void readMidiInputTransform(Xml&);
extern bool applyMidiInputTransformation(MidiEvent* event);
#endif
