//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: panknob.cpp,v 1.1 2002/01/30 12:08:38 muse Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#include <math.h>
#include "../audiothread.h"
#include "panknob.h"
#include "globals.h"

//---------------------------------------------------------
//   VolSlider
//---------------------------------------------------------

PanKnob::PanKnob(QWidget* parent, AudioNode* s)
   : Knob(parent, "pan")
      {
      src = s;
      connect(this, SIGNAL(valueChanged(double)), SLOT(valueChanged(double)));
      }

//---------------------------------------------------------
//   panChanged
//---------------------------------------------------------

void PanKnob::valueChanged(double val)
      {
      audioThread->msgSetPan(src, val);
      }


