//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: quantconfig.cpp,v 1.1 2002/01/30 14:10:08 muse Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#include "quantconfig.h"
#include <qspinbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <qgroupbox.h>
#include <qwhatsthis.h>

const char* wtStrengthTxt = "sets amount of quantization:\n"
                            "0   - no quantization\n"
                            "100 - full quantization";
const char* wtQLimitTxt = "don't quantize notes above this tick limit";
const char* wtQLenTxt = "quantize also note len as default";

//---------------------------------------------------------
//   QuantConfig
//---------------------------------------------------------

QuantConfig::QuantConfig(int s, int l, bool lenFlag)
   : QDialog()
//   : QGroupBox(2, Horizontal, tr("Config Quantize"), 0)
      {
      setCaption("MusE");
      QVBoxLayout* layout = new QVBoxLayout(this);
      QGroupBox* gb = new QGroupBox(2, Horizontal, tr("Config Quantize"), this);
      layout->addWidget(gb);

      QLabel* l1 = new QLabel(tr("Strength"), gb);
      QSpinBox* sb1 = new QSpinBox(0, 100, 1, gb);
      sb1->setSuffix("%");
      sb1->setValue(s);
      QLabel* l2 = new QLabel(tr("Dont Quantize"), gb);
      QSpinBox* sb2 = new QSpinBox(0, 500, 1, gb);
      sb2->setValue(l);
      QLabel* l3 = new QLabel(tr("Quant Len"), gb);
      QRadioButton* but = new QRadioButton(gb);
      but->setChecked(lenFlag);
      connect(sb1, SIGNAL(valueChanged(int)), SIGNAL(setQuantStrength(int)));
      connect(sb2, SIGNAL(valueChanged(int)), SIGNAL(setQuantLimit(int)));
      connect(but, SIGNAL(toggled(bool)), SIGNAL(setQuantLen(bool)));

      QWhatsThis::add(l1,  wtStrengthTxt);
      QWhatsThis::add(sb1, wtStrengthTxt);
      QWhatsThis::add(l2,  wtQLimitTxt);
      QWhatsThis::add(sb2, wtQLimitTxt);
      QWhatsThis::add(l3,  wtQLenTxt);
      QWhatsThis::add(but, wtQLenTxt);
      }

