//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: globals.cpp,v 1.5 2002/02/28 09:02:25 muse Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#include "globals.h"
#include <qpixmap.h>
#include "sf/sndfile.h"
#include <unistd.h>

Song* song;
Sequencer* seq;
MidiThread* midiThread;
AudioThread* audioThread;
AudioPrefetch* audioPrefetch;

bool alsaFound = false;
int division    = 384;           // internal division (ticks/quarternote)
volatile int sampleRate  = 44100;
volatile int segmentSize = 512;  // segmentSize in samples
int rtcTicks    = 4096;
int minMeter    = -60;
int minSlider   = -60;
int guiRefresh  = 20;
bool noAudio = false;
int configFontSize;

bool hIsB = true;             // call note h "b"

const char sharpTab[14][7] = {
      { 0, 3, -1, 2, 5, 1, 4 },
      { 0, 3, -1, 2, 5, 1, 4 },
      { 0, 3, -1, 2, 5, 1, 4 },
      { 0, 3, -1, 2, 5, 1, 4 },
      { 2, 5,  1, 4, 7, 3, 6 },
      { 2, 5,  1, 4, 7, 3, 6 },
      { 2, 5,  1, 4, 7, 3, 6 },
      { 4, 0,  3, -1, 2, 5, 1 },
      { 7, 3,  6, 2, 5, 1, 4 },
      { 5, 8,  4, 7, 3, 6, 2 },
      { 3, 6,  2, 5, 1, 4, 7 },
      { 1, 4,  0, 3, 6, 2, 5 },
      { 6, 2,  5, 1, 4, 0, 3 },
      { 0, 3, -1, 2, 5, 1, 4 },
      };
const char flatTab[14][7]  = {
      { 4, 1, 5, 2, 6, 3, 7 },
      { 4, 1, 5, 2, 6, 3, 7 },
      { 4, 1, 5, 2, 6, 3, 7 },
      { 4, 1, 5, 2, 6, 3, 7 },
      { 6, 3, 7, 4, 8, 5, 9 },
      { 6, 3, 7, 4, 8, 5, 9 },
      { 6, 3, 7, 4, 8, 5, 9 },

      { 1, 5, 2, 6, 3, 7, 4 },
      { 4, 1, 5, 2, 6, 3, 7 },
      { 2, 6, 3, 7, 4, 8, 5 },
      { 7, 4, 1, 5, 2, 6, 3 },
      { 5, 2, 6, 3, 7, 4, 8 },
      { 3, 0, 4, 1, 5, 2, 6 },
      { 4, 1, 5, 2, 6, 3, 7 },
      };

ClipList* waveClips;
SndFileList* sndFiles;

QString museGlobalLib("");
QString museGlobalShare("");
QString museUser("");
QString museProject("");

bool debugMode = false;
bool debugMsg = false;
bool debugSync = false;
bool midiInputTrace = false;
bool midiOutputTrace = false;
bool realTimeScheduling = false;
int realTimePriority = 50;
bool lockMemory = false;

const char* midi_file_pattern[] = {
      "Midi/Kar (*.mid *.kar *.mid.gz *.mid.bz2)",
      "Midi (*.mid *.mid.gz *.mid.bz2)",
      "Karaoke (*.kar *.kar.gz *.kar.bz2)",
      "All Files (*)",
      0
      };
const char* med_file_pattern[] = {
      "med Files (*.med *.med.gz *.med.bz2)",
      "All Files (*)",
      0
      };
const char* image_file_pattern[] = {
      "(*.jpg *.gif *.png)",
      "(*.jpg)",
      "(*.gif)",
      "(*.png)",
      "All Files (*)",
      0
      };

const char* ctrl_file_pattern[] = {
      "ctrl Files (*.ctrl *.ctrl.gz *.ctrl.bz2)",
      "All Files (*)",
      0
      };

QString scoreBg("");        // Background Pixmap Pathname for score canvas

double paperWidth   = 210.0;  // mm
double paperHeight  = 297.0;
double topMargin    = 10.0;
double bottomMargin = 10.0;
double leftMargin   = 10.0;
double rightMargin  = 10.0;
double printScale   = 1.0;

double beamWidth        = 3.0;
double beamSpacing      = 2.125;
double beamSlopeTrigger = 0.5;

int barsPage        = 4;

// QString family("lucida");
QString family("arial");
// QString family("Helvetica");

QFont font0("arial", 12, QFont::Normal);
//QFont font1("arial", 8,  QFont::Normal);
QFont font1("arial", 10,  QFont::Normal);
QFont font2("arial", 10, QFont::Normal);
QFont font3("lucida", 10, QFont::Bold);
//QFont font4("arial", 8,  QFont::Bold);
QFont font4("arial", 10,  QFont::Normal);
QFont font5("Lucidatypewriter", 14,  QFont::Bold);

Qt::ButtonState globalKeyState;

bool extendedMidi = true;
int midiDivision  = 384;      // division for midi export

// Midi Filter Parameter
int midiInputPorts   = 0;    // receive from all devices
int midiInputChannel = 0;    // receive all channel
int midiRecordType   = 0;    // receive all events
int midiThruType = 0;        // transmit all events
int midiFilterCtrl1 = 0;
int midiFilterCtrl2 = 0;
int midiFilterCtrl3 = 0;
int midiFilterCtrl4 = 0;
QActionGroup* undoRedo;
QAction* undoAction;
QAction* redoAction;

AudioMixerApp* audioMixer;
MusE* muse;

int extSyncPort = 1;
int deviceId    = 0x7f;       // any device
int mtcType     = 1;
MTC mtcOffset;
BValue extSyncFlag(0, "extSync");       // false - MASTER, true - SLAVE
bool genMTCSync = false;      // output MTC Sync
bool genMCSync  = false;      // output MidiClock Sync
bool genMMC     = false;      // output Midi Machine Control
bool acceptMTC  = false;
bool acceptMC   = true;
bool acceptMMC  = true;

int preMeasures = 2;
unsigned char measureClickNote = 63;
unsigned char measureClickVelo = 127;
unsigned char beatClickNote    = 63;
unsigned char beatClickVelo    = 70;
unsigned char clickChan = 9;
unsigned char clickPort = 0;
bool precountEnableFlag = true;
bool precountFromMastertrackFlag = true;
int precountSigZ = 4;
int precountSigN = 4;
bool precountPrerecord = false;
bool precountPreroll = false;
bool midiClickFlag   = true;
bool audioClickFlag  = false;

bool rcEnable = false;
unsigned char rcStopNote = 28;
unsigned char rcRecordNote = 31;
unsigned char rcGotoLeftMarkNote = 33;
unsigned char rcPlayNote = 29;

uid_t euid, ruid;  // effective user id, real user id

//---------------------------------------------------------
//   doSetuid
//    Restore the effective UID to its original value.
//---------------------------------------------------------

void doSetuid()
      {
      int status;

#ifdef _POSIX_SAVED_IDS
      status = seteuid (euid);
#else
      status = setreuid (ruid, euid);
#endif
      if (status < 0) {
            fprintf(stderr, "Couldn't set uid.\n");
            }
      }

//---------------------------------------------------------
//   undoSetuid
//    Set the effective UID to the real UID.
//---------------------------------------------------------

void undoSetuid()
      {
      int status;

#ifdef _POSIX_SAVED_IDS
      status = seteuid (ruid);
#else
      status = setreuid (euid, ruid);
#endif
      if (status < 0) {
            fprintf (stderr, "Couldn't set uid.\n");
            exit (status);
            }
      }

