//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: ctrlpanel.cpp,v 1.2 2002/02/08 09:56:29 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#include <stdio.h>
#include <list>

#include "ctrlpanel.h"
#include "ctrlcanvas.h"

#include <qlayout.h>
#include <qpushbutton.h>
#include <qpopupmenu.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qsizepolicy.h>

#include "globals.h"
#include "midictrl.h"
#include "xml.h"
#include "icons.h"
#include "event.h"
#include "midieditor.h"
#include "part.h"

//---------------------------------------------------------
//   CtrlPanel
//---------------------------------------------------------

CtrlPanel::CtrlPanel(QWidget* parent, MidiEditor* e, const char* name = 0)
   : QWidget(parent, name)
      {
      editor = e;
      setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding));
      QGridLayout* cgrid = new QGridLayout(this, 4, 1, 0);

      selCtrl = new QPushButton("Sel", this, "selCtrl");
      selCtrl->setFont(font3);
      selCtrl->setSizePolicy(
         QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed));
      QToolTip::add(selCtrl, tr("select controller"));

      pop = new QPopupMenu(selCtrl);

      // destroy button
      QPushButton* destroy = new QPushButton("x", this, "destroy");
      destroy->setFont(font3);
      destroy->setSizePolicy(
         QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed));
      QToolTip::add(destroy, tr("remove panel"));

      // Cursor Position
      connect(selCtrl, SIGNAL(clicked()), SLOT(ctrlPopup()));
      connect(destroy, SIGNAL(clicked()), SIGNAL(destroyPanel()));

      cgrid->addWidget(selCtrl, 0, 0);
      cgrid->addWidget(destroy,  2, 0);
      cgrid->setRowStretch(1,   50);
      }

//---------------------------------------------------------
//   setHeight
//---------------------------------------------------------

void CtrlPanel::setHeight(int h)
      {
      setFixedHeight(h);
      }

struct TCtrl {
      MidiController* ctrl;
      bool exists;
      TCtrl(MidiController* mc, bool flag) {
            ctrl = mc;
            exists = flag;
            }
      };

//---------------------------------------------------------
//   ctrlPopup
//---------------------------------------------------------

void CtrlPanel::ctrlPopup()
      {
      //---------------------------------------------------
      // build list of defined midi controllers
      //    check if controller exists in current parts
      //---------------------------------------------------

      std::list<struct TCtrl> clist;

      for (iMidiController i = midiControllerList.begin();
         i != midiControllerList.end(); ++i) {
            clist.push_back(TCtrl(*i, false));
            }
      PartList* parts = editor->parts();
      for (iPart ip = parts->begin(); ip != parts->end(); ++ip) {
            EventList* el = ip->second->events();
            for (iEvent ie = el->begin(); ie != el->end(); ++ie) {
                  MidiEvent* ev = (MidiEvent*)(ie->second);
                  if (ev->type() == MidiEvent::Ctrl7
                     || ev->type() == MidiEvent::Ctrl14) {
                        for (std::list<struct TCtrl>::iterator i = clist.begin();
                           i != clist.end(); ++i) {
                              MidiController* ctrl = i->ctrl;
                              if (ev->cntrl() != ctrl->hnum())
                                    continue;
                              // TODO: check more
                              i->exists = true;
                              break;
                              }
                        }
                  }
            }

      pop->clear();
      pop->insertItem("Velocity", 1);
      pop->insertItem("Pitch", 2);

      for (std::list<struct TCtrl>::const_iterator i = clist.begin();
         i != clist.end(); ++i) {
            pop->insertItem(i->exists ? *dotIcon : QPixmap(),
               i->ctrl->name());
            }

      pop->insertItem(QIconSet(*configureIcon), tr("other ..."), 3);
      int rv = pop->exec(selCtrl->mapToGlobal(QPoint(0,0)));
      if (rv == -1)
            return;

      QString s = pop->text(rv);
      if (rv == 1) {
            MidiController ctrl(MidiController::Velo, "Velocity");
            ctrl.setMinVal(0);
            ctrl.setMaxVal(127);
            emit controllerChanged(ctrl);
            }
      else if (rv == 2) {
            MidiController ctrl(MidiController::Pitch, "Pitch");
            ctrl.setMinVal(-8192);
            ctrl.setMaxVal(+8191);
            emit controllerChanged(ctrl);
            }
      else if (rv == 3) {
            configMidiController();
            }
      else {
            for (iMidiController i = midiControllerList.begin();
               i != midiControllerList.end(); ++i) {
                  if (s == (*i)->name()) {
                        emit controllerChanged(**i);
                        break;
                        }
                  }
            }
      }

