//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: audiothread.h,v 1.3 2002/02/13 11:42:56 muse Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __AUDIOTHREAD_H__
#define __AUDIOTHREAD_H__

#include "thread.h"

class AudioPort;
class SndFile;
class AudioNode;
class PluginI;
class SynthI;
class AudioDevice;
class AudioNode;

enum {
      AUDIO_SET_MIXDOWN, AUDIO_OPEN_MIXDOWN, AUDIO_CLOSE_MIXDOWN,
      AUDIO_ROUTEADD, AUDIO_ROUTEREMOVE,
      AUDIO_VOL, AUDIO_PAN,
      AUDIO_ADDPLUGIN,
      AUDIO_MUTE,
      AUDIO_REMOVE_SYNTHI, AUDIO_ADD_SYNTHI,
      AUDIO_SET_DEVICE, AUDIO_SET_SEG_SIZE,
      AUDIO_SET_PREFADER, AUDIO_SET_CHANNELS
      };

struct AudioMsg : public ThreadMsg {   // this should be an union
      SndFile* downmix;
      AudioNode* snode;
      AudioNode* dnode;
      AudioPort* port;
      AudioDevice* device;
      int ival;
      int iival;
      double dval;
      PluginI* plugin;
      SynthI* synth;
      };

const int PREFETCH_BUFFER = 32;

//---------------------------------------------------------
//   AudioThread
//---------------------------------------------------------

class AudioThread : public Thread {
      int curSamplePos;
      int prefetchSamplePos;
      int rPrefetchIdx;
      int wPrefetchIdx;

      void updatePollFd();
      SndFile* _masterMix;
      virtual void processMsg(const ThreadMsg* msg);
      volatile bool playState;
      bool _mixdownRecord;

   protected:
      virtual void defaultTick();

   public:
      AudioThread(bool rt=true, int prio=50, bool ml = true);
      ~AudioThread();
      SndFile* masterMix() const { return _masterMix; }
      void audioTick(AudioPort*);
      void audioRead(AudioPort*);

      virtual void start();

      void msgRemoveRoute(AudioNode*, AudioNode*);
      void msgAddRoute(AudioNode*, AudioNode*);
      void msgAddPlugin(AudioNode*, int idx, PluginI* plugin);
      void msgSetMute(AudioNode*, bool val);
      void msgSetVolume(AudioNode*, double val);
      void msgSetPan(AudioNode*, double val);
      void msgAddSynthI(SynthI* synth);
      void msgRemoveSynthI(SynthI* synth);
      void msgSetAudioDevice(AudioPort* port, AudioDevice* device);
      void msgSetSegSize(int, int);
      void msgSetPrefader(AudioNode*, int);
      void msgSetChannels(AudioNode*, int);

      void msgSetMixdownFile(SndFile* sf);
      void msgOpenMixdownRecord();
      void msgCloseMixdownRecord();
      bool mixdownRecord() const { return _mixdownRecord; }
      SndFile* mixdownFile() const { return _masterMix; }

      // transport:
      void play(int tickpos);
      void seek(int tickpos);
      void stopPlay();
      };

#endif

