//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: audioport.h,v 1.2 2001/11/20 15:19:31 muse Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __AUDIOPORT_H__
#define __AUDIOPORT_H__

#include "ssource.h"
#include "audiomix.h"

class AudioDevice;
class Xml;
class SndFile;

#ifndef AUDIO_CHANNELS
#define AUDIO_CHANNELS  2  // stereo
#endif

//---------------------------------------------------------
//   AudioPort
//---------------------------------------------------------

class AudioPort : public AudioFifo {
      AudioDevice* _device;
      QString _state;         // open state

      int _rwFlags;      // bits: 1 play, 2 capture, 3 duplex

      //------playback: data is read from src
      AudioNode* src;

   public:
      AudioPort();
      AudioDevice* device() const      { return _device; }
      const QString& state() const     { return _state; }
      void setAudioDevice(AudioDevice* dev);
      void read();                        // called from select loop
      void write(SndFile*, int frame, int idx);    // called from select loop
      int rwFlags() const              { return _rwFlags; }
      void setrwFlags(int val);
      virtual void connect(AudioNode* as) { src = as; }
      virtual void disconnect(AudioNode*) { src = 0; }

      void loadConfigAudioPort(Xml&);
      };

extern AudioPort audioPort;

#endif

