/* $Id: tools.c,v 1.9 2000/03/18 21:32:56 zap Exp $
 * -------------------------------------------------------
 * Copyright (c) 1998-2000 Sebastian Kienzl <zap@riot.org>
 * -------------------------------------------------------
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include "muh.h"
#include "tools.h"

void upcase( char *what )
{
    char *doit;
    if( what ) for( doit = what; doit && *doit; doit++ ) *doit = toupper( *doit );
}

void randname( char *random, int length )
{
    int i;
    if( random ) {
        for( i = 0; i < length; i++ ) random[ i ] = ( char )( 'A' + ( rand() % 56 ) );
        random[ length ] = 0;
    }
}

int pos( char *str, char what )
{
    int i = 0;
    if( str ) {
        while( str[ i ] ) {
            if( str[ i ] == what ) return i;
            i++;
        }
    }
    return -1;
}

int lastpos( char *str, char what )
{
    int i;
    if( str ) {
        i = strlen( str ) - 1;
        while( i ) {
            if( str[ i ] == what ) return i;
            i--;
        }
    }
    return -1;
}

char *nextword( char *string )
{
    int i;
    if( ( i = pos( string, ' ' ) ) < 0 )
        return NULL;
    else
        return ( string + i + 1 );
}


char *lastword( char *from )
{
    int i;
    if( ( i = lastpos( from, ' ' ) ) < 0 )
        return from;
    else return from + i + 1;
}

char * gettimestamp()
{
    time_t t;
    struct tm *lt;
    static char stamp[ 100 ];

    time( &t );
    lt = localtime( &t );
    strftime( stamp, 99, "%a %d %b %H:%M:%S", lt );
    return stamp;
}

void report( char *format, ... )
{
    char buffer[ 150 ];
    va_list	va;

    va_start( va, format );
    vsnprintf( buffer, 149, format, va );
    va_end( va );
    fprintf( stdout, "[%s] + %s", gettimestamp(), buffer );
}

void error( char *format, ... )
{
    char buffer[ 150 ];
    va_list	va;

    va_start( va, format );
    vsnprintf( buffer, 149, format, va );
    va_end( va );
    fprintf( stdout, "[%s] - %s", gettimestamp(), buffer );
}

int ismodechan( char *channel )
{
    /*
     this is a mode-chan: @#yo +#yo @&yo +&yo
     this ain't one     : #yo &yo +yo
     */

    if( channel[ 0 ] == '@' ||
        ( channel[ 0 ] == '+' && ( channel[ 1 ] == '#' || channel[ 1 ] == '&' ) ) ) return 1;
    return 0;
}
