%{
/* $Id: config.l,v 1.10 2000/03/19 13:49:23 zap Exp $
 * -------------------------------------------------------
 * Copyright (c) 1998-2000 Sebastian Kienzl <zap@riot.org>
 * -------------------------------------------------------
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include "muh.h"
#include "config.y.h"

extern int lineno;
char *s, *d;

%}

%option noyywrap
%option nounput
%x COMMENT

%%

[ \t]+          /* eat up whitespaces */

#.* |
"//".*		/* comment */
    
"/*"		{ BEGIN COMMENT; }
<COMMENT>"*/"  	{ BEGIN 0; }
<COMMENT>.	/* eat this */
<COMMENT>\n	lineno++;

yes |
enabled |
true		{ yylval.boolean = 1; return BOOLEAN; }

no |
disabled |
false		{ yylval.boolean = 0; return BOOLEAN; }


nick(name)?	{ return NICKNAME; }
altnick(name)?	{ return ALTNICKNAME; }
realname	{ return REALNAME; }
username	{ return USERNAME; }
servers	        { return SERVERS; }
hosts	        { return HOSTS; }
people		{ return PEOPLE; }

listen(port)?	{ return LISTENPORT; }
pass(word)?	{ return PASSWORD; }

logging		{ return LOGGING; }
leave		{ return LEAVE; }
leavemsg	{ return LEAVEMSG; }
away		{ return AWAY; }
getnick		{ return GETNICK; }
bind		{ return BIND; }
antiidle	{ return ANTIIDLE; }
nevergiveup	{ return NEVERGIVEUP; }
norestricted	{ return NORESTRICTED; }
rejoin		{ return REJOIN; }
forwardmsg      { return FORWARDMSG; }

[0-9]*          { 
    yylval.number = atoi( yytext );
    return NUMBER; 
}

\"[^\n"]*[\n"] {
    if( yytext[ yyleng - 2 ] == '\\' ) {
        yyless( yyleng - 1 );
        yymore();
    }
    else {
        yylval.string = malloc( yyleng + 1 );
        s = yytext + 1;
        d = yylval.string;

        while( *s ) {
            if( *s == '"' && *( s - 1 ) == '\\' )
                *( --d ) = *s;
            else
                *d = *s;
            d++; s++;
        }
        *( --d ) = 0;
        
        return STRING;
    }
}

\n		lineno++;

.		return yytext[ 0 ];

%%
