/*
 * Decompiled with CFR 0.152.
 */
package org.petzall.daapapplet;

import java.util.Arrays;
import javax.swing.JPanel;
import org.cdavies.itunes.ItunesConnection;
import org.cdavies.itunes.ItunesConnectionFactory;
import org.cdavies.itunes.Track;
import org.cdavies.itunes.TrackComparator;
import org.petzall.daapapplet.DAAPControls;
import org.petzall.daapapplet.gui.GUI;
import org.petzall.daapapplet.tracklist.TrackList;

public class DAAPPanel
extends JPanel
implements Runnable {
    private DAAPControls _control;
    TrackList _trackList;
    private ItunesConnection _conn;
    private String _daapServer;
    private int _daapPort;
    private GUI _gui;
    private String _searchStr;
    private String _searchKey;
    int _totalTrackCount = 0;

    public DAAPPanel(GUI gUI, String string, int n) throws Exception {
        this._gui = gUI;
        this._daapServer = string;
        this._daapPort = n;
        this._searchStr = "";
        this._searchKey = "";
        this._trackList = new TrackList();
        this._control = new DAAPControls(this._trackList, this._gui);
        this.setOpaque(true);
        this._gui.layoutPanel(this);
    }

    public TrackList getTrackList() {
        return this._trackList;
    }

    public DAAPControls getControl() {
        return this._control;
    }

    public void openConnection() {
        new Thread(this).start();
    }

    public void run() {
        try {
            this._gui.setStatusString("Establishing connection...");
            this._gui.addLogEntry("Connecting to " + this._daapServer + ":" + this._daapPort);
            ItunesConnectionFactory itunesConnectionFactory = new ItunesConnectionFactory();
            this._conn = itunesConnectionFactory.produceConnectionInstance(this._daapServer, this._daapPort, "default");
            this._conn.connect();
            this._gui.setStatusString("");
            this._gui.addLogEntry("Connected to DAAP server");
            this.updateList();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._gui.addLogEntry("Error: " + exception.getMessage());
            this._gui.setStatusString("DAAP link failed");
        }
    }

    private void updateList() {
        this._control.noNextTrack();
        Track[] trackArray = this._conn.getTracklist(this._conn.getDatabases()[0].getId());
        Arrays.sort(trackArray, new TrackComparator());
        this.setTrackList(trackArray);
    }

    public boolean matchTrack(Track track) {
        String string = track.getTrackName();
        if ((this._searchKey.equals("title") || this._searchKey.equals("")) && string != null && string.toLowerCase().indexOf(this._searchStr) >= 0) {
            return true;
        }
        string = track.getArtistName();
        if ((this._searchKey.equals("artist") || this._searchKey.equals("")) && string != null && string.toLowerCase().indexOf(this._searchStr) >= 0) {
            return true;
        }
        string = track.getAlbumName();
        return (this._searchKey.equals("album") || this._searchKey.equals("")) && string != null && string.toLowerCase().indexOf(this._searchStr) >= 0;
    }

    public int getTotalTrackCount() {
        return this._totalTrackCount;
    }

    public void setTrackList(Track[] trackArray) {
        this._totalTrackCount = trackArray.length;
        this._trackList.clear();
        for (int i = 0; i < trackArray.length; ++i) {
            if (!this._searchStr.equals("") && !this.matchTrack(trackArray[i])) continue;
            this._trackList.addRow(trackArray[i]);
        }
        this._gui.updateTable(this._searchKey, this._searchStr);
    }

    public void search(String string) {
        this._searchStr = string.toLowerCase();
        this._searchKey = "";
        this.updateList();
    }

    public void browseBy(String string, String string2) {
        this._searchStr = string2.toLowerCase();
        this._searchKey = string;
        if (string2.length() == 0) {
            this._searchKey = "";
        }
        this.updateList();
    }
}

