/*
 * Decompiled with CFR 0.152.
 */
package org.cdavies.itunes.request;

import itunes.FieldPair;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.cdavies.itunes.hash.ItunesHash;
import org.cdavies.itunes.request.NoServerPermissionException;

public abstract class Request {
    public static final int ITUNES_PORT = 3689;
    protected String server;
    protected int port;
    public byte[] data;
    protected int offset;
    protected int expectedLength;
    protected String dataType;
    protected ArrayList fieldPairs;
    protected ArrayList mlitIndexes;
    protected ArrayList mlclIndexes;
    protected ArrayList mdclIndexes;
    protected String requestString;
    protected URLConnection _conn;
    protected ItunesHash hash = null;

    public Request(String string, int n, String string2) {
        this.server = string;
        this.port = n;
        this.dataType = "";
        this.offset = 0;
        this.fieldPairs = new ArrayList();
        this.mlitIndexes = new ArrayList();
        this.mlclIndexes = new ArrayList();
        this.mdclIndexes = new ArrayList();
        this.requestString = string2;
    }

    public void constructQuery() {
        URL uRL = null;
        try {
            uRL = new URL("http://" + this.server + ":" + this.port + "/" + this.requestString);
            System.err.println("Connecting to " + uRL.toString());
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "AppleRecords");
            uRLConnection.addRequestProperty("Client-DAAP-Access-Index", "1");
            uRLConnection.addRequestProperty("Client-DAAP-Validation", this.hash.generateHash("/" + this.requestString, 1, -1));
            this._conn = uRLConnection;
        }
        catch (Exception exception) {
            this._conn = null;
        }
    }

    public abstract void runQuery() throws NoServerPermissionException;

    public void setHash(ItunesHash itunesHash) {
        this.hash = itunesHash;
    }

    protected static int readSize(String string) {
        return Request.readSize(string, 4);
    }

    protected static int readSize(String string, int n) {
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            string2 = string2 + (c > '\u000f' ? "" : "0") + Integer.toHexString(c);
        }
        return Integer.valueOf(string2, 16);
    }

    protected String dataString(int n) {
        return Request.readString(this.data, this.offset, n);
    }

    public static String readString(byte[] byArray, int n, int n2) {
        String string = "";
        try {
            string = new String(byArray, n, n2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string;
    }

    protected int dataInt() {
        return Request.readInt(this.data, this.offset, 4);
    }

    protected static int readInt(byte[] byArray, int n) {
        int n2 = 0;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, 4);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            n2 = dataInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n2;
    }

    public static int readInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n4 = n2 * 2 - 1;
            for (int i = 0; i < n2; ++i) {
                int n5 = 0xFF & dataInputStream.readByte();
                int n6 = (int)Math.pow(16.0, n4) * (n5 / 16);
                int n7 = (int)Math.pow(16.0, --n4) * (n5 % 16);
                n3 += n6 + n7;
                --n4;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n3;
    }

    public void process() throws NoServerPermissionException {
        if (this.data.length == 0) {
            return;
        }
        this.dataType = this.dataString(4);
        this.offset += 4;
        int n = this.dataInt();
        this.offset += 4;
        this.fieldPairs = this.processDataFields();
    }

    protected ArrayList processDataFields(byte[] byArray, int n) {
        ArrayList<FieldPair> arrayList = new ArrayList<FieldPair>();
        while (n < byArray.length) {
            String string = "";
            string = Request.readString(byArray, n, 4);
            int n2 = Request.readInt(byArray, n += 4);
            FieldPair fieldPair = new FieldPair(string, byArray, n += 4, n2);
            n += n2;
            arrayList.add(fieldPair);
            if (string.equals("mlcl")) {
                this.mlclIndexes.add(new Integer(arrayList.size() - 1));
                continue;
            }
            if (string.equals("mlit")) {
                this.mlitIndexes.add(new Integer(arrayList.size() - 1));
                continue;
            }
            if (!string.equals("mdcl")) continue;
            this.mdclIndexes.add(new Integer(arrayList.size() - 1));
        }
        return arrayList;
    }

    protected ArrayList processDataFields() {
        return this.processDataFields(this.data, this.offset);
    }
}

