/*
 * Decompiled with CFR 0.152.
 */
package org.cdavies.itunes.request;

import itunes.FieldPair;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.cdavies.itunes.Database;
import org.cdavies.itunes.request.DatabaseRequest;
import org.cdavies.itunes.request.NoServerPermissionException;
import org.cdavies.itunes.request.Request;

public class LegacyDatabaseRequest
extends Request
implements DatabaseRequest {
    protected ArrayList mlclDataFields;
    protected ArrayList mlitDataFields;
    private Database[] _dbNames;

    public LegacyDatabaseRequest(String string, int n, int n2) {
        super(string, n, "databases?session-id=" + n2);
    }

    public void runQuery() throws NoServerPermissionException {
        try {
            DataInputStream dataInputStream = new DataInputStream(this._conn.getInputStream());
            int n = this._conn.getContentLength();
            if (n == -1) {
                return;
            }
            this.data = new byte[n];
            dataInputStream.readFully(this.data);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            throw new NoServerPermissionException(iOException.getMessage());
        }
    }

    public void process() throws NoServerPermissionException {
        super.process();
        this.parseMLCL();
        this._dbNames = new Database[this.mlitDataFields.size()];
        for (int i = 0; i < this.mlitDataFields.size(); ++i) {
            ArrayList arrayList = (ArrayList)this.mlitDataFields.get(i);
            String string = null;
            int n = 0;
            int n2 = 0;
            for (int j = 0; j < arrayList.size(); ++j) {
                FieldPair fieldPair = (FieldPair)arrayList.get(j);
                if (fieldPair.name.equals("miid")) {
                    n = Request.readInt(fieldPair.value, 0);
                    continue;
                }
                if (fieldPair.name.equals("minm")) {
                    string = Request.readString(fieldPair.value, 0, fieldPair.value.length);
                    continue;
                }
                if (!fieldPair.name.equals("mimc")) continue;
                n2 = Request.readInt(fieldPair.value, 0);
            }
            this._dbNames[i] = new Database(n, string, n2);
        }
    }

    private void parseMLIT() {
        this.mlitDataFields = new ArrayList();
        for (int i = 0; i < this.mlitIndexes.size(); ++i) {
            byte[] byArray = ((FieldPair)this.mlclDataFields.get((int)((Integer)this.mlitIndexes.get((int)i)).intValue())).value;
            this.mlitDataFields.add(this.processDataFields(byArray, 0));
        }
    }

    protected void parseMLCL() {
        for (int i = 0; i < this.mlclIndexes.size(); ++i) {
            byte[] byArray = ((FieldPair)this.fieldPairs.get((int)((Integer)this.mlclIndexes.get((int)i)).intValue())).value;
            this.mlclDataFields = this.processDataFields(byArray, 0);
        }
        this.parseMLIT();
    }

    public Database[] getDatabases() {
        return this._dbNames;
    }
}

