/*
 * Decompiled with CFR 0.152.
 */
package org.cdavies.itunes.request;

import itunes.FieldPair;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.cdavies.itunes.request.NoServerPermissionException;
import org.cdavies.itunes.request.Request;
import org.cdavies.itunes.request.UpdateRequest;

public class Itunes45UpdateRequest
extends Request
implements UpdateRequest {
    public Itunes45UpdateRequest(String string, int n, int n2, int n3) {
        super(string, n, "update?session-id=" + n2 + "&revision-number=" + n3);
    }

    public void constructQuery() {
        URL uRL = null;
        try {
            uRL = new URL("http://" + this.server + ":" + this.port + "/" + this.requestString);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.addRequestProperty("Host", this.server);
            uRLConnection.addRequestProperty("Client-DAAP-Version", "3.0");
            uRLConnection.setRequestProperty("User-Agent", "AppleRecords");
            uRLConnection.addRequestProperty("Client-DAAP-Access-Index", "2");
            uRLConnection.addRequestProperty("Client-DAAP-Validation", this.hash.generateHash("/" + this.requestString, 2, -1));
            this._conn = uRLConnection;
        }
        catch (Exception exception) {
            this._conn = null;
        }
    }

    public void runQuery() throws NoServerPermissionException {
        try {
            DataInputStream dataInputStream = new DataInputStream(this._conn.getInputStream());
            int n = this._conn.getContentLength();
            if (n == -1) {
                return;
            }
            this.data = new byte[n];
            dataInputStream.readFully(this.data);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            throw new NoServerPermissionException(iOException.getMessage());
        }
    }

    public int getRevisionNumber() {
        int n = this.fieldPairs.indexOf(new FieldPair("musr", new byte[0], 0, 0));
        if (n == -1) {
            return n;
        }
        FieldPair fieldPair = (FieldPair)this.fieldPairs.get(n);
        return Itunes45UpdateRequest.readInt(fieldPair.value, 0);
    }
}

