/*
 * Decompiled with CFR 0.152.
 */
package org.cdavies.itunes.request;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.cdavies.itunes.request.NoServerPermissionException;
import org.cdavies.itunes.request.Request;
import org.cdavies.itunes.request.TrackRequest;

public class Itunes45TrackRequest
extends Request
implements TrackRequest {
    private BufferedInputStream _buf;
    private int _requestId;

    public Itunes45TrackRequest(String string, int n, int n2, int n3, int n4, String string2, int n5) {
        super(string, n, "databases/" + n3 + "/items/" + n4 + "." + string2 + "?session-id=" + n2);
        this._requestId = n5;
    }

    public void constructQuery() {
        URL uRL = null;
        try {
            uRL = new URL("http://" + this.server + ":" + this.port + "/" + this.requestString);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "AppleRecords");
            uRLConnection.addRequestProperty("Client-DAAP-Access-Index", "2");
            uRLConnection.addRequestProperty("Client-DAAP-Validation", this.hash.generateHash("/" + this.requestString, 2, this._requestId));
            uRLConnection.addRequestProperty("Client-DAAP-Request-ID", new Integer(this._requestId).toString());
            this._conn = uRLConnection;
        }
        catch (Exception exception) {
            this._conn = null;
        }
    }

    public void runQuery() throws NoServerPermissionException {
        try {
            int n = this._conn.getContentLength();
            if (n == -1) {
                return;
            }
            if (n == 0) {
                throw new NoServerPermissionException("Cannot get input stream for track");
            }
            this._buf = new BufferedInputStream(this._conn.getInputStream());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            throw new NoServerPermissionException(iOException.getMessage());
        }
    }

    public void process() {
    }

    public InputStream getInputStream() {
        return this._buf;
    }
}

