#ifndef CONVERTER_H_
#define CONVERTER_H_

#include <set>
#include <string>
#include <map>

#include <wx/string.h>

#include "SeriesHandler.h"
#include "OutputterBase.h"

namespace jcs {

typedef std::vector<wxString> Message;
typedef std::vector<Message> MessageList;


class Converter {

private :

	typedef std::string string;
	typedef std::vector<string> StringVector;
	typedef std::map<string, string> StringMap;
	typedef std::map<string, SeriesHandler*> HandlerMap;

public :

	Converter() {}
	Converter(int type);
	~Converter();

	OutputList* GetOutputList() { return &mpOutputter->mOutputList; }
	OutputterBase* GetOutputter() { return mpOutputter; }

	const StringVector GetStringInfo(const string& s) const;

	const StringVector GetSeriesList() const;
	SeriesHandler* GetHandler(const string& s) { return mHandlerMap[s]; }

	void SetOutput(int type);
	
	int AddFile(const wxString& path, const wxString& match = _T(""));
	void UpdateOutput();
	void UpdateAllOutput();
	void UpdateOutput(const string& seriesUid);

	// return value = 1 indicates that output list has changed
//	int ShowOptionsDlg();

	void RemoveSeries(const string& seriesUid);

	void Cancel() { mCancel = true; }
	bool IsCancelled() { return mCancel; }

	void ConvertAll();

	// This is for the "files added" messages
//	void ResetMessageBox();	
//	void ShowMessageBox();

	MessageList messages;

private :

	bool mAddFile(const wxString& path, const wxString& match, wxString& message);

	HandlerMap mHandlerMap;
	bool mCancel;

	OutputterBase* mpOutputter;

	std::set<std::string> mSeriesToUpdate;


};

}

/*
Notes:

Consider moving pointer to outputter into serieshandler class
*/


#endif
