/***************************************************************************
                          mp3listview.cpp  -  description
                             -------------------
    begin                : Tue Sep 18 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qheader.h>

#include <iostream.h>

#include "mp3list.h"

Mp3List::Mp3List(QWidget *parent, const char *name)
  : KListView(parent,name), sortCol(-1), sortAscending(true)
{
	connect(header(), SIGNAL(clicked(int)), this, SLOT(slotSortList(int)));
}

Mp3List::~Mp3List()
{
}

void Mp3List::setMp3Sorting(int col, bool asc)
{
	sortCol = col;
	sortAscending = asc;
	setSorting (col, asc);
}

void Mp3List::slotSortList(int col)
{
  if(col==sortCol) sortAscending=!sortAscending;
  else {
    emit sortingChanged(col);
    sortCol=col;
  }

  setSorting(col, sortAscending);

  if(currentItem()!=0) ensureItemVisible(currentItem());
	cerr << "Sort !" << endl;
}

#include "mp3list.moc"

