/***************************************************************************
                          mp3info.cpp  -  description
                             -------------------
    begin                : Sun Feb 24 2002
    copyright            : (C) 2002 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mp3info.h"

#include <iostream.h>
#include <id3/tag.h>
#include <id3/misc_support.h>
#include <ctype.h>

#define GENRE_MAX 148
#define MAXFRAMESIZE 1792

#define         MPG_MD_STEREO           0
#define         MPG_MD_JOINT_STEREO     1
#define         MPG_MD_DUAL_CHANNEL     2
#define         MPG_MD_MONO             3

static const char *genre_list[] = {
     "Blues",                 "Classic Rock",          "Country",
     "Dance",                 "Disco",                 "Funk",
     "Grunge",                "Hip-Hop",               "Jazz",
     "Metal",                 "New Age",               "Oldies",
     "Other",                 "Pop",                   "R&B",
     "Rap",                   "Reggae",                "Rock",
     "Techno",                "Industrial",            "Alternative",
     "Ska",                   "Death Metal",           "Pranks",
     "Soundtrack",            "Euro-Techno",           "Ambient",
     "Trip-Hop",              "Vocal",                 "Jazz+Funk",
     "Fusion",                "Trance",                "Classical",
     "Instrumental",          "Acid",                  "House",
     "Game",                  "Sound Clip",            "Gospel",
     "Noise",                 "Alt. Rock",             "Bass",
     "Soul",                  "Punk",                  "Space",
     "Meditative",            "Instrum. Pop",          "Instrum. Rock",
     "Ethnic",                "Gothic",                "Darkwave",
     "Techno-Indust.",        "Electronic",            "Pop-Folk",
     "Eurodance",             "Dream",                 "Southern Rock",
     "Comedy",                "Cult",                  "Gangsta",
     "Top 40",                "Christian Rap",         "Pop/Funk",
     "Jungle",                "Native American",       "Cabaret",
     "New Wave",              "Psychadelic",           "Rave",
     "Showtunes",             "Trailer",               "Lo-Fi",
     "Tribal",                "Acid Punk",             "Acid Jazz",
     "Polka",                 "Retro",                 "Musical",
     "Rock & Roll",           "Hard Rock",             "Folk",
     "Folk/Rock",             "National Folk",         "Swing",
     "Fusion",                "Bebob",                 "Latin",
     "Revival",               "Celtic",                "Bluegrass",
     "Avantgarde",            "Gothic Rock",           "Progress. Rock",
     "Psychadel. Rock",       "Symphonic Rock",        "Slow Rock",
     "Big Band",              "Chorus",                "Easy Listening",
     "Acoustic",              "Humour",                "Speech",
     "Chanson",               "Opera",                 "Chamber Music",
     "Sonata",                "Symphony",              "Booty Bass",
     "Primus",                "Porn Groove",           "Satire",
     "Slow Jam",              "Club",                  "Tango",
     "Samba",                 "Folklore",              "Ballad",
     "Power Ballad",          "Rhythmic Soul",         "Freestyle",
     "Duet",                  "Punk Rock",             "Drum Solo",
     "A Capella",             "Euro-House",            "Dance Hall",
     "Goa",                   "Drum & Bass",           "Club-House",
     "Hardcore",              "Terror",                "Indie",
     "BritPop",               "Negerpunk",             "Polsk Punk",
     "Beat",                  "Christian Gangsta Rap", "Heavy Metal",
     "Black Metal",           "Crossover",             "Contemporary Christian",
     "Christian Rock",        "Merengue",              "Salsa",
     "Trash Metal",           "Anime",                 "Jpop",
     "Synthpop"};

/*unsigned int bitrates[3][3][15] =
{
    {
  {0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448},
     {0, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384},
        {0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320}
    },
    {
     {0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256},
        {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160},
        {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160}
    },
    {
     {0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256},
        {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160},
        {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160}
    }};
*/

unsigned int bitrates[2][3][16] =
{
	{
    {0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448,},
       {0, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384,},
       {0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320,}},

	{
       {0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256,},
	    {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160,},
	    {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160,}}
};

/*unsigned int s_freq[3][4] =
{
    {44100, 48000, 32000, 0},
    {22050, 24000, 16000, 0},
    {11025, 8000, 8000, 0}
};
*/

unsigned int s_freq[9] =
{44100, 48000, 32000, 22050, 24000, 16000, 11025, 12000, 8000};

static const char *mode_names[5] =
{"Stereo", "Joint Stereo", "Dual Ch", "Mono", "Multi Ch"};
const char *layer_names[3] =
{"I", "II", "III"};
const char *version_names[3] =
{"MPEG-1", "MPEG-2 LSF", "MPEG-2.5"};
const char *version_nums[3] =
{"1", "2", "2.5"};

Mp3Info::Mp3Info(const char* filein)
{
     success = existsTag = false;
     fileglob = strdup(filein);

     FILE* file;

     setDefault();

     if ((file = fopen(filein, "r")))
     {
          if ((success=readLayerInfo(file)))
          {
               existsTag = readTagInfo(filein, file);
          }
          else  // File isn't a mp3 !
          {
               cerr << "Error file: " << filein << endl;
               success=false;
          }
          fclose(file);
     }
     else   // File isn't readable
     {
		 	cerr << "Error opening file: " << filein << endl;
          success = false;
     }


}

Mp3Info::~Mp3Info()
{
}

void Mp3Info::writeTagInfo(const char* title, const char* artist,
                            const char* album, const char* comment,
                            const char* year, int genre, const char* track, int mod)
{

  if ((mod == 2) || (mod == 1)) {
    ID3_Frame *frame = NULL;
    ID3_Tag myTag;
    myTag.Link(fileglob);

    cerr << "create tag" << endl;

    while ( (frame = myTag.Find(ID3FID_LEADARTIST)) ||
            (frame = myTag.Find(ID3FID_ALBUM)) ||
            (frame = myTag.Find(ID3FID_TITLE)) ||
            (frame = myTag.Find(ID3FID_YEAR)) ||
            (frame = myTag.Find(ID3FID_COMMENT)) ||
            (frame = myTag.Find(ID3FID_TRACKNUM)) ||
            (frame = myTag.Find(ID3FID_CONTENTTYPE))
          ) {
            frame = myTag.RemoveFrame(frame);
           // delete frame;
            }
    cerr << "old tag deleted" << endl;

    frame = new ID3_Frame(ID3FID_LEADARTIST);
    if (frame)
    {
      frame->Field(ID3FN_TEXT) = artist;
      myTag.AttachFrame(frame);
    }
  //  delete frame;

    //cerr << "aggiunto artista" << endl;

    frame = new ID3_Frame(ID3FID_TITLE);
    if (frame)
    {
      frame->Field(ID3FN_TEXT) = title;
      myTag.AttachFrame(frame);
    }
    //delete frame;

    //cerr << "aggiunto titolo" << endl;

    frame = new ID3_Frame(ID3FID_ALBUM);
    if (frame)
    {
      frame->Field(ID3FN_TEXT) = album;
      myTag.AttachFrame(frame);
    }
    //delete frame;

    //cerr << "aggiunto album " << endl;
    frame = new ID3_Frame(ID3FID_COMMENT);
    if (frame)
    {
      frame->Field(ID3FN_TEXT) = comment;
      myTag.AttachFrame(frame);
    }
   // delete frame;

    //cerr << "aggiunto commento " << endl;
    frame = new ID3_Frame(ID3FID_YEAR);
    if (frame)
    {
      frame->Field(ID3FN_TEXT) = year;
      myTag.AttachFrame(frame);
    }
   // delete frame;

    //cerr << "aggiunto anno" << endl;

    frame = new ID3_Frame(ID3FID_CONTENTTYPE);
    if (NULL != frame)
    {
    //  char sGenre[6];
		char* sGenre;
		sGenre = new char [strlen (genre_list[genre])+6];
		/*	int len =(strlen (genre_list[genre])+6);
			char sGenre[len];*/
			//sGenre = (char*)calloc (strlen ((genre_list[genre])+6), sizeof(char));
      sprintf(sGenre, "(%lu)%s", (luint) genre, genre_list[genre]);
//sprintf(sGenre, "(%lu)", (luint) genre);
      frame->Field(ID3FN_TEXT) = sGenre;
      myTag.AttachFrame(frame);
			delete[] sGenre;
			//free ((void*)sGenre);
    }

    //cerr << "aggiunto genere "<< endl;

    frame = new ID3_Frame(ID3FID_TRACKNUM);
    if (frame)
    {
      frame->Field(ID3FN_TEXT) = track;
      myTag.AttachFrame(frame);
    }
   // delete frame;

    //cerr << "aggiunta track" << endl;

    myTag.Update(ID3TT_ID3V2);

    cerr << "update done " << endl;

  }

 if ((mod == 0) || (mod ==  2)) {
    FILE* file;
    file = fopen (fileglob, "r+");
    int trackn;

    if (file)
    {
        if (existsTag)
            fseek(file, -128, SEEK_END);
        else
            fseek(file, 0, SEEK_END);

        Mp3Tag tag;
        trackn=atoi(track);

        tag.tag[0] = 'T';
        tag.tag[1] = 'A';
        tag.tag[2] = 'G';

        strncpy(&tag.title[0], title, 30);
        strncpy(&tag.artist[0], artist, 30);
        strncpy(&tag.album[0], album, 30);
        strncpy(&tag.year[0], year, 4);
        strncpy(&tag.comment[0], comment, 28);
        tag.comment[28]=0;
        if ((trackn >= 0) && (trackn <=255))
          tag.comment[29]=trackn;
        else
          tag.comment[29]=0;
        tag.genre = genre;

        int wlen = fwrite(&tag, 128, 1, file);
        fclose(file);

        if(!wlen)
        {
            cerr << "Write Tag error" << endl;
           // return false;
        }
    }
    else
    {
        cerr << "File open error" << endl;
        //return false;
    }
    }
  //  return false;

}

bool Mp3Info::readTagInfo (const char* filein, FILE* file)
{
	ID3_Tag myTag;
	myTag.Link(filein);

	if (myTag.HasV2Tag())
		cerr << "Found Tag V2 "<< fileglob << endl;
	if (myTag.HasV1Tag())
		cerr << "Found Tag V1: " << fileglob << endl;

	if (myTag.HasV2Tag())
	{
		//cerr << "Trovata Tag V2 "<< fileglob << endl;
		ID3_Frame *frame = NULL;
		if ((frame = myTag.Find(ID3FID_LEADARTIST)) ||
        (frame = myTag.Find(ID3FID_BAND))       ||
        (frame = myTag.Find(ID3FID_CONDUCTOR))  ||
        (frame = myTag.Find(ID3FID_COMPOSER)))
		{
			artist = ID3_GetString(frame, ID3FN_TEXT);
		}
		else
			artist = NULL;

		frame =  myTag.Find(ID3FID_ALBUM);
		if (frame != NULL)
		{
			album = ID3_GetString(frame, ID3FN_TEXT);
		}
		else
			album = NULL;

		frame = myTag.Find(ID3FID_TITLE);
		if (frame != NULL)
		{
			title = ID3_GetString(frame, ID3FN_TEXT);
		}
		else
			title = NULL;

		frame = myTag.Find(ID3FID_YEAR);
		if (frame != NULL)
		{
			year = ID3_GetString(frame, ID3FN_TEXT);
		}
		else
			year = NULL;

		frame = myTag.Find(ID3FID_COMMENT);

		if (frame)
		{
			comment = ID3_GetString(frame, ID3FN_TEXT);
		}
		else
			comment = NULL;

		frame = myTag.Find(ID3FID_TRACKNUM);
		if (frame != NULL)
		{
			track = ID3_GetString(frame, ID3FN_TEXT);
		}
		else
			track = NULL;

		frame = myTag.Find(ID3FID_CONTENTTYPE);
		if (frame != NULL)
		{
			char* sGenre = ID3_GetString(frame, ID3FN_TEXT);
			char *pCur= sGenre;

			genre = 255;

			cerr << "Genre: " << sGenre<< endl;

			while ((pCur = strchr(pCur, '('))!= NULL)
			{
				//cerr << "Parentesi Trovata" << endl;
				pCur++;
				if ((*pCur!='R') || (*pCur!='C'))
				{
					genre = (((0xFF) < atoi(pCur)) ? (0xFF) : atoi(pCur));
					//cerr << "Trovaro Genre : " << genre << " N: " << pCur << endl;
					break;
				}
				//pCur2 = strchr(pCur, ')') + 1;
			}
			if (genre == 255)
			{
				//cerr << "Niente number" << endl;
				if ((pCur = strrchr (sGenre, ')')) == NULL)
					pCur = sGenre;
				else
					pCur++;

				while (*pCur == ' ')
					pCur++;

				for (int i=0; i<GENRE_MAX; i++)
					if (strcmp(pCur, genre_list[i])==0)
					{
						genre = i;
						break;
					}
			}
/*
			if ((pCur = strchr(sGenre, '(')) && (strchr(sGenre, ')')))
			{
				pCur++;
				genre = (((0xFF) < (atoi(pCur))) ? (0xFF) : (atoi(pCur)));
			}

			else
			{
				int i;
				genre = 255;

				for (i=0; i<GENRE_MAX; i++)
					if (strcmp(sGenre, genre_list[i])==0)
					{
						genre = i;
						break;
					}

			}*/
		}
		else
			genre = 255;
		return true;
	}

	if ((myTag.HasV1Tag()))
	{
		//cerr << "Trovata Tag V1: " << fileglob << endl;
		Mp3Tag tag;

		fseek(file, -128, SEEK_END);
		fread(&tag, 128, 1, file);

		char buf[30];
		if (!strncmp(tag.tag, "TAG", 3))
		{
			copyTagInfo (buf, tag.title, 30);
			title = strdup(buf);
			copyTagInfo (buf, tag.artist, 30);
			artist = strdup(buf);
			copyTagInfo (buf, tag.album, 30);
			album = strdup(buf);
			copyTagInfo (buf, tag.year, 4);
			year = strdup(buf);
			if (tag.comment[28]==0)
			{
				copyTagInfo (buf, tag.comment, 28);
				comment = strdup(buf);
				int tmp = tag.comment[29];
				if (tmp)
				{
					sprintf (buf, "%i", tmp);
					track = strdup(buf);
				}
				/*else
					track = strdup("");*/
				//cerr << "Tag V1.1" << endl;
			}
			else
			{
				copyTagInfo (buf, tag.comment, 30);
				comment = strdup(buf);
				//track = strdup("");
				//cerr << "Tag V1" << endl;
			}
			genre = tag.genre & 0xFF;
			return true;
		}
	}
	return false;
}

void Mp3Info::deleteTag(int mod)
{
  ID3_Tag myTag;
  myTag.Link(fileglob);

  if (mod == 1)
  {
    myTag.Strip(ID3TT_ID3V1);
		cerr << "Id3 Tag V1 deleted: " << fileglob << endl;
  }
  else if (mod == 2 )
  {
    myTag.Strip(ID3TT_ID3V2);
		cerr << "Id3 Tag V2 deleted: " << fileglob << endl;
  }
}

bool Mp3Info::readLayerInfo (FILE* file)
{
	unsigned char buf[4];
	unsigned long head;
	unsigned char* bufFrame;
	struct stat fi;

	fstat(fileno(file), &fi);
	filelen = fi.st_size;

	fseek(file, 0, SEEK_SET);
	if (fread(buf, 1, 4, file) != 4)
	{
		cerr << "File too short < 4 Bytes" << endl;
		return false;
	}

	head = ((unsigned long) buf[0] << 24) | ((unsigned long) buf[1] << 16) |
		((unsigned long) buf[2] << 8) | ((unsigned long) buf[3]);

	while (!headCheck(head))
	{
		head <<= 8;
		if (fread(buf, 1, 1, file) != 1)
		{
			return false;
		}
		head |= buf[0];
	}

	if (!loadHeader(head))
	{
		cerr << "Errot while loading header" << endl;
		return false;
	}

	bufFrame = new unsigned char [frameH.framesize + 4];
	fseek(file, -4, SEEK_CUR);
	fread(bufFrame, 1, frameH.framesize + 4, file);
	xingH.toc = NULL;
	tpf = computeTpf(&frameH);

	// cerr << "Tpf : " << tpf << endl;
	if (checkXingHeader(&xingH, bufFrame))
	{
		vbr = true;
		numFrames = xingH.frames;
		//cerr << "Frames : " << numFrames << endl;
	}
	else
	{
		vbr=false;
		numFrames = (int) (filelen / computeBpf(&frameH));
		//cerr << "Frames : " << numFrames << " bpf : " << computeBpf(&frameH) << endl;
	}
	if (getBitrate() == 0)
	{
		cerr << "Bitrate = 0 " << endl;
		delete[] bufFrame;
		return false;
	}

	delete[] bufFrame;
	return true;
}





bool Mp3Info::headCheck(unsigned long head)
{
	if ((head & 0xffe00000) != 0xffe00000)
		return false;
	if (!((head >> 17) & 3))
		return false;
	if (((head >> 12) & 0xf) == 0xf)
		return false;
	if (!((head >> 12) & 0xf))
		return false;
	if (((head >> 10) & 0x3) == 0x3)
		return false;
	if (((head >> 19) & 1) == 1 && ((head >> 17) & 3) == 3 &&
                                    ((head >> 16) & 1) == 1)
		return false;
	if ((head & 0xffff0000) == 0xfffe0000)
		return false;

	return true;
}

bool Mp3Info::loadHeader(unsigned long head)
{
 if (head & (1 << 20))
	{
		frameH.lsf = (head & (1 << 19)) ? 0x0 : 0x1;
		frameH.mpeg25 = 0;
	}
	else
	{
		frameH.lsf = 1;
		frameH.mpeg25 = 1;
	}

	/*switch (((head >> 19) & 0x3) )
	{
		case 3:
			version = 0;
			break;
		case 2:
			version = 1;
			break;
		case 0:
			version = 2;
			break;
		default:
			return false;
	}*/
	frameH.layer = 4 - ((head >> 17) & 3);
	if (frameH.mpeg25)
	{
		frameH.sampling_frequency = 6 + ((head >> 10) & 0x3);
	}
	else
		frameH.sampling_frequency = ((head >> 10) & 0x3) + (frameH.lsf * 3);
	frameH.error_protection = ((head >> 16) & 0x1) ^ 0x1;

	if (frameH.mpeg25)		/* allow Bitrate change for 2.5 ... */
		frameH.bitrate_index = ((head >> 12) & 0xf);

	frameH.bitrate_index = ((head >> 12) & 0xf);
	frameH.padding = ((head >> 9) & 0x1);
	frameH.extension = ((head >> 8) & 0x1);
	frameH.mode = ((head >> 6) & 0x3);
	frameH.mode_ext = ((head >> 4) & 0x3);
	frameH.copyright = ((head >> 3) & 0x1);
	frameH.original = ((head >> 2) & 0x1);
	frameH.emphasis = head & 0x3;

	frameH.stereo = (frameH.mode == MPG_MD_MONO) ? 1 : 2;

	//ssize = 0;

	if (!frameH.bitrate_index)
		return false;

	switch (frameH.layer)
	{
		case 1:
			frameH.framesize = (long) bitrates[frameH.lsf][0][frameH.bitrate_index] * 12000;
			frameH.framesize /= s_freq[frameH.sampling_frequency];
			frameH.framesize = ((frameH.framesize + frameH.padding) << 2) - 4;
			break;
		case 2:
			frameH.framesize = (long) bitrates[frameH.lsf][1][frameH.bitrate_index] * 144000;
			frameH.framesize /= s_freq[frameH.sampling_frequency];
			frameH.framesize += frameH.padding - 4;
			break;
		case 3:
			/*if (frameH.lsf)
				ssize = (frameH.stereo == 1) ? 9 : 17;
			else
				ssize = (frameH.stereo == 1) ? 17 : 32;
			if (frameH.error_protection)
				ssize += 2;*/
			frameH.framesize = (long) bitrates[frameH.lsf][2][frameH.bitrate_index] * 144000;
			frameH.framesize /= s_freq[frameH.sampling_frequency] << (frameH.lsf);
			frameH.framesize = frameH.framesize + frameH.padding - 4;
			break;
		default:
			return false;
	}
	if(frameH.framesize > MAXFRAMESIZE)
		return false;
	return true;
}

bool Mp3Info::checkXingHeader(mpegXingHeader * x, unsigned char *buf)
{
	int i, head_flags;
	int h_id, h_mode, h_sr_index;
	static int sr_table[4] =
	{44100, 48000, 32000, 99999};

	/* get Xing header data */
	x->flags = 0;	/* clear to null incase fail */

	/* get selected MPEG header data */
	h_id = (buf[1] >> 3) & 1;
	h_sr_index = (buf[2] >> 2) & 3;
	h_mode = (buf[3] >> 6) & 3;



	/* determine offset of header */
	if (h_id)
	{			/* mpeg1 */
		if (h_mode != 3)
			buf += (32 + 4);
		else
			buf += (17 + 4);
	}
	else
	{			/* mpeg2 */
		if (h_mode != 3)
			buf += (17 + 4);
		else
			buf += (9 + 4);
	}

	if (buf[0] != 'X')
		return false;	/* fail */
	if (buf[1] != 'i')
		return false;	/* header not found */
	if (buf[2] != 'n')
		return false;
	if (buf[3] != 'g')
		return false;
	buf += 4;

	x->h_id = h_id;
	x->samprate = sr_table[h_sr_index];
	if (h_id == 0)
		x->samprate >>= 1;
	head_flags = x->flags = extractI4(buf);
	buf += 4;		/* get flags */

	if (head_flags & 0x0001)
	{
		x->frames = extractI4(buf);
		cerr << "Xing frames : " << x->frames << endl;
		buf += 4;
	}
	if (head_flags & 0x0002)
	{
		x->bytes = extractI4(buf);
		buf += 4;
	}

	if (head_flags & 0x0004)
	{
		if (x->toc != NULL)
		{
			for (i = 0; i < 100; i++)
				x->toc[i] = buf[i];
		}
		buf += 100;
	}

	x->vbr_scale = -1;
	if (head_flags & 0x0008)
	{
		x->vbr_scale = extractI4(buf);
		buf += 4;
	}


/*if( X->toc != NULL ) {
 *for(i=0;i<100;i++) {
 *    if( (i%10) == 0 ) printf("\n");
 *    printf(" %3d", (int)(X->toc[i]));
 *}
 *}
 */

	return true;	/* success */
}

int Mp3Info::extractI4(unsigned char *buf)
{
	int x;

	/* big endian extract */
	x = buf[0];
	x <<= 8;
	x |= buf[1];
	x <<= 8;
	x |= buf[2];
	x <<= 8;
	x |= buf[3];
	return x;
}

double Mp3Info::computeTpf(mpegFrameHeader *fr)
{
	static int bs[4] =
	{0, 384, 1152, 1152};
	double tpf;

	tpf = (double) bs[fr->layer];
	tpf /= s_freq[fr->sampling_frequency] << (fr->lsf);
	return tpf;
}

double Mp3Info::computeBpf(mpegFrameHeader *fr)
{
	double bpf;

	switch (fr->layer)
	{
		case 1:
			bpf = bitrates[fr->lsf][0][fr->bitrate_index];
			bpf *= 12000.0 * 4.0;
			bpf /= s_freq[fr->sampling_frequency] << (fr->lsf);
			break;
		case 2:
		case 3:
			bpf = bitrates[fr->lsf][fr->layer - 1][fr->bitrate_index];
			bpf *= 144000;
			bpf /= s_freq[fr->sampling_frequency] << (fr->lsf);
			break;
		default:
			bpf = 1.0;
	}

	return bpf;
}

int Mp3Info::getBitrate(){
	//return (bitrates[version][layer - 1][bitrate_index]);
	if (vbr)
		return (int)((xingH.bytes * 8) / (tpf * xingH.frames * 1000));
	else
		return (bitrates[frameH.lsf][frameH.layer - 1][frameH.bitrate_index]);

}

int Mp3Info::getSamplerate(){
	return (s_freq[frameH.sampling_frequency]);
}

const char* Mp3Info::getMpegver(){
	return (version_names[(frameH.lsf)+(frameH.mpeg25)]);
}

int Mp3Info::getLayer() {
	return frameH.layer;
}

const char* Mp3Info::getTrack() {
  if (track)
  {
    int c = atoi(track);
    if (c == 0)
      return "";
    if (c < 10)
    {
      char buf[3];
      sprintf (buf, "0%d", c);
      //cerr << "Track: " << buf << endl;
      return strdup(buf);
    }
    return track;
  }
  return "";
}

const char* Mp3Info::getMode(int mode)
{
     if ((mode >= 0) && (mode < 5))
	     return (mode_names[mode]);

     return "Stereo";
}

int Mp3Info::getMode()
{
     return frameH.mode;
}

int Mp3Info::getLength() {
	//return (int) (((8 * filelen) / 1000) / getBitrate());
	return (int) (numFrames * tpf);
}

char* Mp3Info::getLengthChar() {
	int min, sec;
	char buf[6];

	min=getLength()/60;
	sec=getLength()%60;
  /*   if (sec < 10)
          sprintf (buf, "%d:0%d", min, sec);
     else   */
	     sprintf (buf, "%d:%02d", min, sec);
	lengthchar=strdup (buf);
	return lengthchar;
}

int Mp3Info::getSize() {
	return filelen;
}

const char* Mp3Info::getPath() {
     char* buf=new char [strlen(fileglob)+1];
     char* p;
     strcpy (buf, fileglob);
     p=strrchr(buf, '/');
     *p='\0';
     path=strdup(buf);
     delete[] buf;
     return path;
}

const char* Mp3Info::getName() {
	return name=(strdup(strrchr(fileglob, '/')+1));
}

const char* Mp3Info::getArtist()
{
  if (artist)
     return artist;
  return "";
}

const char* Mp3Info::getTitle()
{
  if (title)
     return title;
  else
    return "";
}

const char* Mp3Info::getAlbum()
{
  if (album)
     return album;
  else
    return "";
}

const char* Mp3Info::getYear()
{
  if (year)
     return year;
  else
    return "";
}

const char* Mp3Info::getComment()
{
  if (comment)
     return comment;
  else
    return "";
}

const char* Mp3Info::getGenre(int numgen)
{
	if (numgen < GENRE_MAX && numgen>=0)
		return genre_list[numgen];

	return "";
}

int Mp3Info::getGenre()
{
     return genre;
}

const char* Mp3Info::getGenreC()
{
    if (genre < GENRE_MAX && genre>=0)
        return genre_list[genre];
    return "";
}

bool Mp3Info::getResult()
{
     return success;
}

// Erase white spaces from tag info

void Mp3Info::copyTagInfo(char *to, char *from, int maxlen){
    int where;
    strncpy(to, from, maxlen);
    to[maxlen] = 0;
    for (where = maxlen - 1; ((where >= 0) && (to[where] == ' ')); where--) {
        to[where] = 0;
    }
}

void Mp3Info::setDefault()
{
     title = artist = album = year = comment = track = NULL;
     genre = 255;

    /* layer = 0;
     error_protection = 0;
     bitrate_index = 0;
     sampling_frequency = 0;
     padding = 0;
     extension = 0;
     mode = 0;
     mode_ext = 0;
     copyright = 0;
     original = 0;
     emphasis = 0;   */
}
