#ifndef LIBBTTRACKER_TYPE_BTT_DB_H
#define LIBBTTRACKER_TYPE_BTT_DB_H

/* libc */
#include <sys/types.h>

/* other libs */
#include <apr.h>
#include <db.h>

/* local */
#include <libbtutil.h>

typedef struct btt_db_s
{
 unsigned char	open;
 DB_ENV*                env;
 DB*                    hashes;
 DB*                    peers;
 DB*                    index;
 char                   dir[BT_FILE_LEN];
 apr_size_t             cache;
} btt_db;

extern const btt_db new_btt_db;

/* need to define this here since bt_tracker and bt_db both use it in const's */
#define new_btt_db_d { 0,	/* open */ NULL, /* env */ NULL, /* hashes */ NULL,	/* peers */ NULL, /* indexes */ BTT_HOME, /* dir */ 1048576 * 10 /* cache */ }

#endif /* LIBBTTRACKER_TYPE_BTT_DB_H */
