/*
 *  mod_bt - Making Things Better For Seeders
 *  Copyright 2004, 2005, 2006 Tyler MacDonald <tyler@yi.org>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/* other libs */
#include <db.h>
#include <apr.h>
#include <apr_pools.h>
/* local */
#include <libbttracker.h>

/* data is set to the infohash */
/* modifies infohash, does not save */
int btt_iter_peer_stats(
    apr_pool_t* p, DB_TXN* txn, DBC* cursor, DBT* key, DBT* val, void* data
) {
    btt_infohash* infohash = (btt_infohash*) data;
    btt_peer* peer = (btt_peer*) val->data;
 
    infohash->peers ++;
 
    if(peer->last_t > infohash->last_t)
        infohash->last_t = peer->last_t;
 
    if(peer->last_t > infohash->last_peer_t)
        infohash->last_peer_t = peer->last_t;
 
    if(!infohash->first_peer_t)
        infohash->first_peer_t = peer->first_t;
 
    if(peer->left == 0) {
        infohash->seeds ++;
        if(peer->last_t > infohash->last_seed_t)
            infohash->last_seed_t = peer->last_t;

        if(!infohash->first_seed_t)
            infohash->first_seed_t = peer->complete_t;
    }
 
    if(peer->uploaded > infohash->max_uploaded)
        infohash->max_uploaded = peer->uploaded;
 
    if(peer->downloaded > infohash->max_downloaded)
        infohash->max_downloaded = peer->downloaded;

    if(peer->left > infohash->max_left)
        infohash->max_left = peer->left;
  
    if(
        peer->left &&
        ((!infohash->min_left) || (peer->left < infohash->min_left))
    )
        infohash->min_left = peer->left;
 
    if(BTT_PEER_IS_SHIELD(peer))
        infohash->shields ++;
 
    return 0;
}
