#ifndef LIBBTPEER_TYPES_BTP_SESSION_H
#define LIBBTPEER_TYPES_BTP_SESSION_H

#include <time.h>
#include <apr.h>
#include <apr_pools.h>
#include <apr_network_io.h>
#include <libbtutil/const.h>
#include <libbtpeer/types/btp_file_pool.h>
#include <libbtpeer/types/btp_torrent.h>

#define BTP_SESSION_MAX_FILES 50
#define BTP_SESSION_MAX_TORRENTS 100
#define BTP_SESSION_MAX_PEERS 1000
#define BTP_SESSION_RUN_MAX_TORRENTS 10

#define BTP_SESSION_FLAG_OWN_SOCKET     0x01
#define BTP_SESSION_FLAG_DEBUG          0x02

typedef struct btp_session_config_s {
    int             f;
    int             max_files;
    int             max_torrents;
    int             max_peers;
    char            dest[BT_PATH_LEN];
    char            ip[BT_SHORT_STRING];
    apr_port_t      port;
} btp_session_config;

typedef struct btp_session_s {
    time_t              create_t;
    apr_pool_t*         p;
    btp_file_pool*      fp;
    bt_llist*           tl;
    apr_socket_t*       s;
    btp_session_config  c;
} btp_session;

extern btp_session_config new_btp_session_config;

extern btp_session* btp_session_create(apr_pool_t* p, btp_session_config c);
extern apr_status_t btp_session_socket_init(btp_session* s);
extern apr_status_t btp_session_have_torrent(
    btp_session* s, const char* dest, const char* name
);
extern apr_status_t btp_session_add_torrent(btp_session* s, btp_torrent* t);
extern apr_status_t btp_session_run_torrents(btp_session* s);

#endif /* LIBBTPEER_TYPES_BTP_SESSION_H */
