<? include("header.phpi") ?>

   <h2>Documentation</h2>

   <h3>Configuration</h3>

  <UL>
   <LI><A HREF="httpd.conf.txt"><B>httpd.conf example</B></A></LI>
   <LI>
    <A HREF="#directives"><B>Apache Configuration Directives</B></A>
    <UL>
     <LI><A HREF="#Tracker">Tracker</A></LI>
     <LI><A HREF="#TrackerHome">TrackerHome</A></LI>
     <LI><A HREF="#TrackerFlags">TrackerFlags</A></LI>
     <LI><A HREF="#TrackerStyleSheet">TrackerStyleSheet</A></LI>
     <LI><A HREF="#TrackerDetailURL">TrackerDetailURL</A></LI>
     <LI><A HREF="#TrackerRootInclude">TrackerRootInclude</A></LI>
     <LI><A HREF="#TrackerReturnPeers">TrackerReturnPeers</A></LI>
     <LI><A HREF="#TrackerReturnMax">TrackerReturnMax</A></LI>
     <LI><A HREF="#TrackerReturnInterval">TrackerReturnInterval</A></LI>
     <LI><A HREF="#TrackerReturnPeerFactor">TrackerReturnPeerFactor</A></LI>
     <LI><A HREF="#TrackerHashWatermark">TrackerHashWatermark</A></LI>
     <LI><A HREF="#TrackerHashMinAge">TrackerHashMinAge</A></LI>
     <LI><A HREF="#TrackerHashMaxAge">TrackerHashMaxAge</A></LI>     
    </UL>
   </LI>
   <LI>
    <A HREF="#handlers"><B>Content Handlers</B></A>
    <UL>
     <LI><A HREF="#modbt-announce">modbt-announce</A></LI>
     <LI><A HREF="#modbt-scrape">modbt-scrape</A></LI>
     <LI><A HREF="#modbt-root">modbt-root</A></LI>
     <LI><A HREF="#modbt-register">modbt-register</A></LI>
     <LI><A HREF="#modbt-details">modbt-details</A></LI>
    </UL>
   </LI>
  </UL>

  <A NAME="example"><H3>httpd.conf example</H3></A>

  <P>
   The "<A HREF="httpd.conf.txt">etc/httpd.conf</A>" file in the <B>mod_bt</B> distribution
   provides a functioning example.
   At the very least, you will have to make a directory for <B>mod_bt</B>'s data files to
   live and specify that to apache as "TrackerHome", as well as setting up your
   content-handlers at their appropriate URLs.
  </P>
  
  <A NAME="directives"><H3>Apache Configuration Directives</H3></A>
  
  <P>
   The following directives may be used in an httpd.conf file to configure the tracker:
  </P>
  
  <UL>
   <LI>
    <A NAME="Tracker"><B>Tracker</B></A>
    <P>
     Flag; Set to "On" to enable the BitTorrent tracker system, or "Off"
     to disable it. (Default: Off)
    </P>
   </LI>
   <LI>
    <A NAME="TrackerHome"><B>TrackerHome</B></A>
    <P>
     Directory that mod_bt should use to store its data files.
     This directory must exist, be writable by the webserver,
     and ideally shouldn't be used for anything else. (Default: /tmp/tracker)
    </P>
   <LI>
    <A NAME="TrackerFlags"><B>TrackerFlags</B></A>
    <P>
      Set boolean tracker options - Prefix with a "-" to turn off, "+" (or nothing) to turn on
     <UL>
      <LI><EM>RequireReg</EM> - Infohash <A HREF="#modbt-register">Registration</A> Required (Default: Off)</LI>
      <LI><EM>AllowScrapeFull</EM> -	Full <A HREF="#modbt-scrape">Scrape</A> Allowed (Default: On)</LI>
      <LI><EM>AllowScrapeVerbose</EM> - Verbose <A HREF="#modbt-scrape">Scrape</A> Allowed (Default: On)</LI>
      <LI><EM>AllowScrapeXML</EM> - XML <A HREF="#modbt-scrape">Scrape</A> Allowed (Default: On)</LI>
      <LI><EM>AllowScrapeGeneral</EM> - General <A HREF="#modbt-scrape">Scrape</A> Allowed (Default: On)</LI>
     </UL>
    </P>
   </LI>
   <LI>
    <A NAME="TrackerStyleSheet"><B>TrackerStyleSheet</B></A>
    <P>
     Stylesheet URL to use for generated HTML pages (Default: /mod_bt.css)
    </P>
   </LI>
   <LI>
    <A NAME="TrackerDetailURL"><B>TrackerDetailURL</B></A>
    <P>
     URL to link infohashes to from the HTML info page. The URL is handled in one of three differnt ways, depending on the last character in it:
    <UL>
     <LI><EM>Link to actual file:</EM> If the URL ends with a "/" (slash), a link is only generated if the infohash has a filename, and the infohash's filename is appended to the URL.</LI>
     <LI><EM>Link to .torrent:</EM> If the URL ends with a "." (dot), a link is only generated if the infohash has a filename, and the dot is replaced with the infohash's filename, followed by ".torrent"</LI>
     <LI><EM>Link to statistics:</EM> If the URL ends with anything else, "?info_hash=", followed by the (uri-escaped) 20-byte infohash string, is appended to the URL. (See <A HREF="#modbt-details">modbt-details</A> handler below)</LI>
    </UL><BR>
    (Default: an empty string, which causes no links to be generated.)
    </P>
   </LI>
   <LI>
    <A NAME="TrackerRootInclude"><B>TrackerRootInclude</B></A>
    <P>
     URL to include into the root HTML info page. (Default: None).
     An <CODE>&lt;!--#include virtual="..." --&gt;</CODE> line will be generated
     after the tracker info, but before the infohash listing, with this value if specified.
    </P>
    
    <P>Example:</P>
    
    <BLOCKQUOTE><PRE>
		TrackerRootInclude	/motd.inc

		&lt;LocationMatch "^/$"&gt;
			SetHandler modbt-root
			Options +Includes
			SetOutputFilter INCLUDES
		&lt;/LocationMatch&gt;
	</PRE></BLOCKQUOTE>
   <LI>
    <A NAME="TrackerReturnPeers"><B>TrackerReturnPeers</B></A>
    <P>
     Default number of peers to return on an /announce request (Default: 50)
    </P>
   </LI>
   <LI>
    <A NAME="TrackerReturnMax"><B>TrackerReturnMax</B></A>
    <P>Maximum number of peers to return on an /announce request (Default: 500)</P>
   </LI>
   <LI>
    <A NAME="TrackerReturnInterval"><B>TrackerReturnInterval</B></A>
    <P>Number of seconds to tell peers to wait before using /announce again (Default: 600)</P>
   </LI>
   <LI>
    <A NAME="TrackerReturnPeerFactor"><B>TrackerReturnPeerFactor</B></A>

    <P>
     This value is used to increase peers' return intervals as more peers are added to an infohash.    
     The following formula is used to calculate what interval to return to a peer:
    </P>
     
    <P><B><CODE>peer.return_interval = ((tracker.return_peer_factor / infohash.peers) + 1) * tracker.return_interval</CODE></B></P>

    <P>
     So, with a tracker <CODE>TrackerReturnInterval</CODE> of 500 seconds, and a <CODE>TrackerReturnPeerFactor</CODE> of 20,

     <UL>
      <LI>An infohash with 10 peers would tell it's peers to return every 500 seconds,</LI>
      <LI>an infohash with 22 peers would tell it's peers to return every 1000 seconds,</LI>
      <LI>An infohash with 1000 peers would tell it's peers to return every 500000 seconds,</LI>
      <LI>etc.</LI>
     </UL>

     <P>
      The default <CODE>TrackerReturnPeerFactor</CODE> setting is 1000. Setting it below 100 would probably cause problems
      on very popular torrents.
     </P>
   </LI>
   <LI>
    <A NAME="TrackerHashWatermark"><B>TrackerHashWatermark</B></A>
    <P>
     If there are less than this many hashes, only dead hashes are deleted; if there are more, inactive ones are deleted too (Default: 500)
    </P>
   </LI>
   <LI>
    <A NAME="TrackerHashMinAge"><B>TrackerHashMinAge</B></A>
    <P>
     How many seconds of inactivity until a hash is considered inactive (Default: 1800)
    </P>
   </LI>
   <LI>
    <A NAME="TrackerHashMaxAge"><B>TrackerHashMaxAge</B></A>
    <P>
     How many seconds of inactivity until a hash is considered dead (Default: 3600)
    </P>
   </LI>
  </UL>
  
  <A NAME="handlers"><H3>Content Handlers</H3></A>
  
  <A NAME="modbt-announce"><H4>modbt-announce</H4></A>
  
  <P><EM>Handler for BitTorrent peer announce requests.</EM></P>
  
  <P>Extensions:</P>
  
  <UL>
   <LI>
    <CODE>shield=1</CODE> - When set, peer is considered "shielded".
    <P>
     When a shielded peer is a seed, it is only served to other peers if there are no unshielded seeds available.
     This flag should be used for "core" seeds only, to protect their bandwidth when there are other sources
     of the data available.
     Using <A HREF="http://httpd.apache.org/docs-2.0/mod/mod_rewrite.html">mod_rewrite</A>, you can both
     protect access to the "shield" option, and cause it to be automatically set on peers that should be
     shielded without their software having to be modified. Here is an example:
    </P>
    <BLOCKQUOTE><PRE>
	&lt;IfModule mod_rewrite.c&gt;
		RewriteEngine	On

		# Don't allow people to set shield mode themselves
		RewriteCond		%{QUERY_STRING}	^.*shield=1
		RewriteRule		(.*)	-	[F]

		# Auto-Activate shield mode on peers that are known to be good seeders
		RewriteCond		%{QUERY_STRING}	!^.*shield=1
		RewriteCond		%{REMOTE_ADDR} ^10.20.30.40 [OR]
		RewriteCond		%{REMOTE_ADDR} ^20.30.40.50
		RewriteRule		(.*)	/announce?shield=1	[PT,L,QSA,NE,NS]
	&lt;/IfModule&gt;
    </PRE></BLOCKQUOTE>
   </LI>
  </UL>
  
  <A NAME="modbt-scrape"><H4>modbt-scrape</H4></A>
  
  <P><EM>Handler for BitTorrent scrape requests</EM></P>
  
  <P>Extensions:</P>
  
  <P><B>Only one of "xml=1", "verbose=1", or "html=1" may be specified.</B></P>
  
  <UL>
   <LI>
    <CODE>info_hash=...[&info_hash=....[...]]</CODE> - 
    Multiple "info_hash" parameters may be passed to /scrape, in which case only the details for the hashes specified will
    be displayed.
   </LI>
   <LI>
    <CODE>xml=1</CODE> -
    Return results in an XML-like format rather than bencoded. The XML format contains a lot of additional information about
    the hash that is not supplied in the bencode, such as the last time we heard from a peer, total hits to /announce, etc.
   </LI>
   <LI>
    <CODE>verbose=1</CODE> -
    Return the file's name and size in the bencode in addition to the standard "completed/downloaded/incomplete" statistics.
   </LI>
   <LI>
    <CODE>html=1</CODE> -
    Return an HTML information page about the hashes rather than a bencode.
   </LI>
   <LI>
    <CODE>full=1</CODE> -
    Display information about all hashes, not ones that have been active recently.
   </LI>
  </UL>
  
  <A NAME="modbt-root"><H4>modbt-root</H4></A>
  
  <P><EM>Return an HTML information page about the hashes.</EM> (Equivalent to calling the "modbt-scrape" handler with "html=1" appended to the URL arguments supplied by the user.)</P>
  
  <A NAME="modbt-register"><H4>modbt-register</H4></A>
  
  <P><EM>Handler for Infohash registration.</EM></P>
  
  <P>When called with no arguments, a HTML page is displayed allowing the user to fill out the arguments required to register a hash.</P>
  
  <P>This URL is more for use by administration scripts than actual users, but has an HTML interface to facilitate manual use as well.</P>
  
  <P>Arguments:</P>
  
  <UL>
   <LI><CODE>filesize=...</CODE> - Size of the file this torrent refers to, in bytes.</LI>
   <LI><CODE>filename=...</CODE> - Name of the file this torrent refers to.</LI>
   <LI><CODE>info_hash=...</CODE> - Binary representation of the info_hash for this torrent.</LI>
   <LI><CODE>info_hash_str=...</CODE> - (For user input) hexadecimal representation of the info_hash for this torrent, as displayed by the HTML info pages.</LI>
  </UL>
  
  <UL>
   <LI>"filesize" and "filename" must always be specified before "info_hash" or "info_hash_str".</LI>
   <LI>Multiple "info_hash" or "info_hash_str" parameters may be specified.</LI>
   <LI>
    When an "info_hash" or "info_hash_str" parameter is encountered, the hash is registered using the 
    "filesize" and "filename" parameters specified closest to the left of the "info_hash" parameter.
   </LI>
  </UL>

  <A NAME="modbt-details"><H4>modbt-details</H4></A>
  
  <P><EM>Handler for Infohash details.</EM></P>
  
  <P>
   The modbt-details handler generates an HTML page giving some information about an infohash, as well as an HTML listing of all of the peers currently
   considered to be part of the infohash. This handler can be bandwidth expensive on very popular torrents.
  </P>
  
  <P>
   Arguments:
  </P>
  
  <UL>
   <LI><CODE>info_hash=...</CODE> - The infohash that you wish to display details for.</LI>
  </UL>

  <P>
   Example:
  </P>
  
  <BLOCKQUOTE><PRE>
	TrackerDetailURL /details
	&lt;Location "/details"&gt;
		SetHandler	modbt-details
	&lt;/Location&gt;
  </PRE></BLOCKQUOTE>



<? include("footer.phpi") ?>
