      SUBROUTINE M_PCHK(XPT,YPT,NPT,XPLO,XPHI,YPLO,YPHI)
C
C     Checks if any of the lines in arrays XPT,YPT will go over the
C     boundaries XPLO,XPHI,YPLO,YPHI and changes the points so that
C     they remain inside
C     Note that XPT, YPT and NPT can change
C
      PARAMETER (MPT=100)
      REAL XPT(NPT),YPT(NPT)
      REAL XXPT(MPT),YYPT(MPT)
C
      NNPT = 0
C
C     Check the x co-ordinates first
C
      DO 1000 I=1,NPT
          IF((XPT(I)-XPLO).LT.-1.0E-4 .OR. (XPT(I)-XPHI).GT.1.0E-4) THEN
              IF(XPT(I).LT.XPLO) THEN
                  XLIM = XPLO
              ELSE
                  XLIM = XPHI
              ENDIF
C
              DO 500 JJ=1,2
                  IF(JJ.EQ.1) THEN
                      IF(I.EQ.1) GOTO 500
                      N1 = I - 1
                      N2 = I
                  ELSE
                      IF(I.EQ.NPT) GOTO 500
                      N1 = I
                      N2 = I + 1
                  ENDIF
                  NNPT = NNPT + 1
                  XXPT(NNPT) = XLIM
                  IF(ABS(XPT(N2) - XPT(N1)) .LT. 1.0E-06) THEN
                      YYPT(NNPT) = YPT(I)
                  ELSE
                      AM = (YPT(N2) - YPT(N1)) / (XPT(N2) - XPT(N1))
                      C  = YPT(N2) - AM*XPT(N2)
                      YYPT(NNPT) = AM*XLIM + C
                  ENDIF
500           CONTINUE
          ELSE
              NNPT = NNPT + 1
              XXPT(NNPT) = XPT(I)
              YYPT(NNPT) = YPT(I)
          ENDIF
          IF(NNPT.GE.MPT-1) THEN
              CALL M_EMSG('M_PCHK'
     +         ,'Ran out of space checking if points are ' //
     +          'inside boundaries')
              GOTO 3000
          ENDIF
1000  CONTINUE
C
      IF(NNPT.GT.0) THEN
          CALL UCOPY_r(XXPT,XPT,NNPT)
          CALL UCOPY_r(YYPT,YPT,NNPT)
      ENDIF
      NPT = NNPT
C
C     Now check the y co-ordinates
C
      NNPT = 0
      DO 2000 I=1,NPT
          IF((YPT(I)-YPLO).LT.-1.0E-4 .OR. (YPT(I)-YPHI).GT.1.0E-4) THEN
              IF(YPT(I).LT.YPLO) THEN
                  YLIM = YPLO
              ELSE
                  YLIM = YPHI
              ENDIF
C
              DO 1500 JJ=1,2
                  IF(JJ.EQ.1) THEN
                      IF(I.EQ.1) GOTO 1500
                      N1 = I - 1
                      N2 = I
                  ELSE
                      IF(I.EQ.NPT) GOTO 1500
                      N1 = I
                      N2 = I + 1
                  ENDIF
                  IF(ABS(YPT(N2) - YPT(N1)) .LT. 1.0E-06) THEN
                      XXT = XPT(I)
                  ELSE
                      AM = (XPT(N2) - XPT(N1)) / (YPT(N2) - YPT(N1))
                      C  = XPT(N2) - AM*YPT(N2)
                      XXT = AM*YLIM + C
                  ENDIF
C
C                 Only add the point if it is inside the X boundaries
C
                  IF(XXT-XPLO.GE.-1.0E-04 .AND. XXT-XPHI.LE.1.0E-04)THEN
                      NNPT = NNPT + 1
                      YYPT(NNPT) = YLIM
                      XXPT(NNPT) = XXT
                  ENDIF
1500           CONTINUE
          ELSE
              NNPT = NNPT + 1
              XXPT(NNPT) = XPT(I)
              YYPT(NNPT) = YPT(I)
          ENDIF
          IF(NNPT.GE.MPT-1) THEN
              CALL M_EMSG('M_PCHK'
     +         ,'Ran out of space checking if points are ' //
     +          'inside boundaries')
              GOTO 3000
          ENDIF
2000  CONTINUE
C
3000  CONTINUE
      IF(NNPT.GT.0) THEN
          CALL UCOPY_r(XXPT,XPT,NNPT)
          CALL UCOPY_r(YYPT,YPT,NNPT)
      ENDIF
      NPT = NNPT
C
      END
