      SUBROUTINE MN_HNW(IDA,IDB,NDIM,NWRD,NHD,NPTRH,NPTRD,NWHEAD
     1 ,NBPPT,NTMODE)
C
C     IDA,IDB IS THE HISTOGRAM ID WHICH I WANT TO STORE
C     NDIM IS THE NUMBER OF DIMENSIONS
C     NHD IS THE STORAGE POSITION
C     NPTRH IS THE POINTER TO THE HEADER
C     NPTRD IS THE POINTER TO THE DATA
C     NWHEAD IS THE NUMBER OF HEADER WORDS
C     NBPPT IS THE NUMBER OF BITS PER WORD
C           THE DEFAULT IS 32 FOR ALL PLOTS EXCEPT IF
C           NDIM > 2 WHEN IT IS 16
C           TRUE SCATTER PLOTS ARE ALWAYS 32 WHATEVER YOU TRY TO SET
C     NTMODE is the time mode (0 means not time)
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mnlun.inc"
C
      IF(NBPPT.LE.0) THEN
          IF(NDIM.GT.2) THEN
              NBPPT = 16
          ELSE
              NBPPT = 32
          ENDIF
      ENDIF
      IF(NDIM.LT.0) NBPPT = 32
C
C     HEADER SPACE IS 11 WORDS + BINS AND LIMITS + BITS PER POINT
C     + UNDERFLOW AND OVERFLOWS IF IT IS A BINNED HISTOGRAM
C     + MEAN AND SIGMA IF IT IS A BINNED HISTOGRAM, A SERIES OF
C       POINTS OR A SCATTER PLOT
C     + DATE AND TIME
C     + DATE,TIME and TIME MODE if requested
C
      NHD = 0
C
      IF(IABS(NDIM).EQ.0 .OR. IABS(NDIM).GT.MDIMMX) THEN
          WRITE(TXTERR,11000) IDA,IDB,NDIM
11000     FORMAT(' Histogram',I7,I4,' has wrong dimension',I6)
          CALL MN_ERR('MN_HNW',TXTERR)
          GOTO 9000
      ENDIF
C
      NWHEAD = 11 + IABS(NDIM)*3 + 1
C
C     ONLY KEEP TRACK OF UNDERFLOWS AND OVERFLOWS FOR UP TO
C     3-DIMENSIONAL PLOTS
C
      IF(ndim.gt.-3 .and. ndim.le.3)
     + NWHEAD = NWHEAD + 3**IABS(NDIM)
C
C     Leave space for the mean and sigma for binned histograms
C     series of points and scatter plots
C
      IF(NDIM.GT.-3) NWHEAD = NWHEAD + 2*IABS(NDIM)
C
C     Add date and time to the header
C
      NWHEAD = NWHEAD + 2
C
C     Add the starting date and time for the plot and the time mode
C
      IF(NTMODE.NE.0) NWHEAD = NWHEAD + 3
C
C     SEE IF I HAVE ENOUGH SPACE LEFT
C
      NW = NDPTE
      IF(NWRD.GT.0) THEN
          NWNEED = (NWRD*NBPPT-1)/32 + 1
          IF(NW+NWNEED+NWHEAD.GT.NHSTWD .OR. NDHIS.GE.MHSTMX) THEN
              CALL M_EMSG('MN_HNW'
     +         ,'I have run out of space for creating new histograms')
              CALL MN_ERR('MN_HNW'
     +         ,'Issue the command SQUEEZE to get unused space back')
              GOTO 9000
          ENDIF
      ENDIF
C
      NHD = NDHIS + 1
C
      NPTRH = NW + 1
      NPTRD = NPTRH + NWHEAD
C
C     Initialize all the header info for the new plot
C
      IDIDA(NHD)   = 0
      IDIDB(NHD)   = 0
      IDPTRH(NHD)  = 0
      IDPTRD(NHD)  = 0
      TDTIT(NHD)   = ' '
      TDFIL(NHD)   = ' '
      TDDIR(NHD)   = ' '
      TDNAM(1,NHD) = ' '
C
 9000 CONTINUE
      RETURN
      END
