      SUBROUTINE MN_HBF(IDELIM,MMODE)
C
C     FETCHES HBOOK VERSION 3 HISTOGRAMS AND VERSION 4 HISTOGRAMS
C
      implicit none
*
#include "mnpar.inc"
#include "mndat.inc"
#include "mnflg.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      integer idelim,mmode
*
      CHARACTER*1 CHTYPE
      CHARACTER*80 CHTITL
      LOGICAL HEXIST
      LOGICAL QZERO,QRNGE
      INTEGER IDLSTA1(100),IDLSTA2(100),IDLSTB(100),IDLSTC(100)
      INTEGER IDALL(2*MHSTMX)
      integer ntype,nmlast,nmode,ierr,icycle,njunk,ndhis0
     + ,nidl,ida1,ida2,idb1,idb2,nnid,id,ida,idb,idh,nhtot
     + ,nl
*
      integer  inttyq
      external inttyq
C
      DATA NMLAST/0/
C
      NMODE = IABS(MMODE)
C
      IF(MMODE.GT.0 .AND. IDELIM.EQ.0) THEN
          NJUNK = INTTYQ(.TRUE.,IDELIM)
          CALL RESTYQ
      ENDIF
C
      NDHIS0 = NDHIS
C
      IF(FIL_HB.EQ.' ' .OR. MMODE.LT.0 .OR.
     1   (NMODE.NE.NMLAST) .OR.
     1   (IDELIM.GT.0 .AND.
     +    IDELIM.NE.ICHAR(':') .AND. IDELIM.NE.ICHAR('&'))) THEN
          IF(NMLAST.EQ.4 .AND. FIL_HB.NE.' ') then
              call m_hclean(1)
          endif
          NTYPE = 4
          IF(NMODE.EQ.3) NTYPE = 1
          CALL MN_FIL(NTYPE,LUNHIN,FIL_HB,IDELIM,IERR)
          IF(IERR.NE.0) GOTO 9000
CICB          IF(NMODE.EQ.4) CALL HRFILE(LUNHIN,'MN_HBIN',' ')
      ENDIF
      NMLAST = NMODE
      IF(MMODE.LT.0) RETURN
C
C     Change the directory if needed
C
      IF(NMODE.EQ.3) THEN
          CALL HCDIR('//PAWC',' ')
      ELSE
          CALL M_SDIR(0,IERR)
          IF(IERR.NE.0) GOTO 9000
      ENDIF
C
      NIDL = 0
      QZERO = .FALSE.
      qrnge = .false.
 2000 CONTINUE
C
C     Set the cycle number and the secondary id
C
      ICYCLE = 99999
      IDB    = NDIDB
C
      CALL WAITYQ('Give histogram number(s): ')
      CALL MN_HRN(IDA1,IDA2,IDB1,IDB2,IDELIM,NNID)
      IF(NNID.LE.0) GOTO 8000
      IF(NNID.GT.1) THEN
          CALL M_EMSG('MN_HBF','WARNING: Mn_Fit interprets' //
     +     ' a secondary id as the cycle number')
          CALL M_EMSG('MN_HBF','This will be added to the curent' //
     +     ' secondary id')
          IF(IDB1.NE.IDB2) THEN
              CALL M_EMSG('MN_HBF','It therefore does not make sense' //
     +         ' to give a range of secondary ids')
              IDB2 = IDB1
          ENDIF
*ICB          CALL M_EMSG('MN_HBF','HBOOK does not know about' //
*ICB     1     ' secondary identifiers')
*ICB          CALL M_EMSG('MN_HBF','It will be ignored')
          ICYCLE = IDB1
          IF(NDIDB + ICYCLE .GT. 980) THEN
              TXTERR = 'Cycle requested + secondary identifier' //
     +         ' too large'
              CALL M_EMSG('MN_HBF',TXTERR)
              TXTERR = 'Secondary identifier set to 980'
              CALL M_EMSG('MN_HBF',TXTERR)
          ENDIF
          IDB    = MIN(NDIDB + IDB1,980)
      ENDIF
C
      IF(NIDL.GE.100) THEN
          CALL M_EMSG('MN_HBF','Ran out of space to store plot' //
     1     ' numbers to get')
          CALL M_EMSG('MN_HBF','Issue FETCH command again to get' //
     +     ' more plots.')
          GOTO 2200
      ENDIF
C
      if(.not.qzero) QZERO = IDA1.EQ.0
      if(.not.qrnge) QRNGE = IDA2.GT.IDA1
      NIDL = NIDL + 1
      IDLSTA1(NIDL) = IDA1
      IDLSTA2(NIDL) = IDA2
      IDLSTB(NIDL)  = IDB
      IDLSTC(NIDL)  = ICYCLE
      IF(IDELIM.GE.0) GOTO 2000
 2200 CONTINUE
      IF(NIDL.LE.0) GOTO 8000
C
      IF(NMODE.EQ.3) THEN
          IF(.NOT.QZERO .AND. QRNGE) THEN
              CALL MN_ERR('MN_HBF'
     +         ,'You cannot fetch a range of histograms' //
     +          ' with the HB3_FETCH command')
              GOTO 8000
          ENDIF
      ENDIF
C
C     Loop over all the histograms and make HBOOK into Mn_Fit ones
C
      IF(QZERO) THEN
          CALL HDELET(0)
          IF(NMODE.EQ.3) THEN
              CALL HFETCH(0,LUNHIN)
          ELSE
              CALL HRIN(0,ICYCLE,0)
          ENDIF
          CALL HIDALL(IDALL,NHTOT)
          NHTOT = MIN0(NHTOT,MHSTMX)
          DO 5000 NL=1,NHTOT
              ID  = IDALL(NL)
              IDH = ID
              IDA = ID
C
C             Now make the HBOOK histogram into a Mn_Fit histogram
C
              CALL M_HBMN(IDA,IDA,IDB,NMODE)
 5000     CONTINUE
C
C     Loop over the histograms in the current directory and fetch the ones
C     that are wanted
C
      ELSEIF(QRNGE) THEN
          ID = 0
 6000     CONTINUE
          CALL HLNEXT(ID,CHTYPE,CHTITL,'12N')
          IF(ID.EQ.0) GOTO 6200
          DO 6100 NL=1,NIDL
              IDA1   = IDLSTA1(NL)
              IDA2   = IDLSTA2(NL)
              IDB    = IDLSTB(NL)
              ICYCLE = IDLSTC(NL)
              IF(IDA1.EQ.0 .OR.
     1           (ID.GE.IDA1 .AND. ID.LE.IDA2)) THEN
                  IDH = ID
                  IF(HEXIST(IDH)) CALL HDELET(IDH)
                  CALL HRIN(IDH,ICYCLE,0)
                  IDA = IDH
C
C                 Now make the HBOOK histogram into a Mn_Fit histogram
C
                  CALL M_HBMN(IDA,IDA,IDB,NMODE)
                  GOTO 6000
              ENDIF
 6100     CONTINUE
          GOTO 6000
 6200     CONTINUE
      ELSE
          DO 7000 NL=1,NIDL
              ID     = IDLSTA1(NL)
              IDB    = IDLSTB(NL)
              ICYCLE = IDLSTC(NL)
              IF(HEXIST(ID)) CALL HDELET(ID)
              IF(NMODE.EQ.3) THEN
                  IDH = ID
                  CALL HFETCH(IDH,LUNHIN)
                  IDA = ID
              ELSE
                  IDH = ID
                  IF(HEXIST(IDH)) CALL HDELET(IDH)
                  CALL HRIN(IDH,ICYCLE,0)
                  IDA = ID
              ENDIF
              IF(.NOT.HEXIST(IDH)) THEN
                  WRITE(TXTERR,'(''Histogram'',I8
     1             ,'' does not exist'')') IDA
                  CALL M_EMSG('MN_HBF',TXTERR)
                  GOTO 7000
              ENDIF
C
C             Now make the HBOOK histogram into a Mn_Fit histogram
C
              CALL M_HBMN(IDA,IDA,IDB,NMODE)
7000      CONTINUE
      ENDIF
C
8000  CONTINUE
C
C     CHECK THAT I GOT THE HISTOGRAMS I WANTED
C
      NNID = 2
      CALL MN_HNG('MN_HBF',NNID,NDHIS0,NIDL
     + ,IDLSTA1,IDLSTA2,IDLSTB,IDLSTB)
C
9000  CONTINUE
C
      RETURN
      END
