      REAL FUNCTION AM_EXP(NSUB,LSTYP,LSTP,LSTF,LSTV)
C
C     Evaluates an expression parsed by M_PRSE
C
      implicit none
*
#include "mnpar.inc"
#include "mndat.inc"
#include "mnfun.inc"
#include "mnflg.inc"
#include "mnprs.inc"
#include "mnprj.inc"
#include "mntpl.inc"
#include "mntim.inc"
#include "mnlun.inc"
C
      integer nsub,lstyp,lstp,lstf,lstv
      DIMENSION LSTYP(*),LSTP(*),LSTF(*),LSTV(10,*)
*
      REAL STACK(20)
      INTEGER ISTACK(20)
      EQUIVALENCE (STACK,ISTACK)
*
      integer istk,nerr,ifun,ipos,ireg,ipar,iset,ibin,ivar,ielm
     + ,ndate,ntime,itsec
      real val,val1,val2,dx,y0,y1,y2,y3,del,ddel,dddel,xmin,xmax
      DOUBLE PRECISION XMNFUN,XMNALL,WMNHER
      real amnp,amnx,amne,amndxn,amnden,amndxp,amndep,amnint
      real am_tdif
C
      CHARACTER*5 COMAND
C
      AM_EXP = 0.0
      NERR = 0
C
C     STACK POINTER
C
      ISTK = 0
C
      DO 3000 IPOS=1,NSUB
C
C         OPERATOR
C
          IF(LSTYP(IPOS) .EQ. -1) THEN
              IF(LSTP(IPOS) .LE. 5)ISTK = ISTK -1
              IF(ISTK .LE. 0) THEN
                  WRITE(LUNTTO,5000)
5000              FORMAT(' AM_EXP: Stack pointer went to 0. Quitting')
                  RETURN
              ENDIF

              VAL = STACK(ISTK)
C
C             "+"
C
              IF(LSTP(IPOS).EQ. 1) THEN
                  STACK(ISTK) = VAL + STACK(ISTK+1)
C
C             "-"
C
              ELSEIF(LSTP(IPOS).EQ. 2) THEN
                  STACK(ISTK) = VAL - STACK(ISTK+1)
C
C             "*"
C
              ELSEIF(LSTP(IPOS).EQ. 3) THEN
                  STACK(ISTK) = VAL * STACK(ISTK+1)
C
C             "/"
C
              ELSEIF(LSTP(IPOS).EQ. 4) THEN
                  IF(STACK(ISTK+1).NE.0.0) THEN
                      STACK(ISTK) = VAL / STACK(ISTK+1)
                  ELSE
                      CALL M_EMSG('AM_EXP','Trying to divide by zero')
                      STACK(ISTK) = 0.0
                  ENDIF
C
C             "^"
C
              ELSEIF(LSTP(IPOS).EQ. 5) THEN
                  IF(VAL.GT.0.0) THEN
                      STACK(ISTK) = VAL ** STACK(ISTK+1)
                  ELSEIF((NINT(STACK(ISTK+1)*1000.0) -
     +             NINT(STACK(ISTK+1))*1000).EQ.0)  THEN
                      STACK(ISTK) = VAL ** NINT(STACK(ISTK+1))
                  ELSE
                      CALL M_EMSG('AM_EXP','Trying to raise a' //
     +                 ' negative number to a real power')
                      STACK(ISTK) = 0.0
                  ENDIF
C
C             "SQRT"
C
              ELSEIF(LSTP(IPOS).EQ. 6) THEN
                  IF(VAL.GE.0.0) THEN
                      STACK(ISTK) = SQRT(VAL)
                  ELSE
                      CALL M_EMSG('AM_EXP'
     +                 ,'Trying to square root a negative number')
                      STACK(ISTK) = 0.0
                  ENDIF
C
C             "SIN"
C
              ELSEIF(LSTP(IPOS).EQ. 7) THEN
                  STACK(ISTK) =  SIN(VAL)
C
C             "COS"
C
              ELSEIF(LSTP(IPOS).EQ. 8) THEN
                  STACK(ISTK) =  COS(VAL)
C
C             "TAN"
C
              ELSEIF(LSTP(IPOS).EQ. 9) THEN
                  STACK(ISTK) =  TAN(VAL)
C
C             "ALOG"
C
              ELSEIF(LSTP(IPOS).EQ.10) THEN
                  if(val.gt.0.0) then
                      STACK(ISTK) = ALOG(VAL)
                  else
                      call m_emsg('AM_EXP'
     +                 ,'Trying to take the log of a number <= 0')
                  endif
C
C             "ALOG10"
C
              ELSEIF(LSTP(IPOS).EQ.11) THEN
                  if(val.gt.0.0) then
                      STACK(ISTK) = ALOG10(VAL)
                  else
                      call m_emsg('AM_EXP'
     +                 ,'Trying to take the log of a number <= 0')
                  endif
C
C             "EXP"
C
              ELSEIF(LSTP(IPOS).EQ.12) THEN
                  STACK(ISTK) =  EXP(VAL)
C
C             "ASIN"
C
              ELSEIF(LSTP(IPOS).EQ.13) THEN
                  if(val.ge.-1.0 .and. val.le.+1.0) then
                      STACK(ISTK) = ASIN(VAL)
                  else
                      call m_emsg('AM_EXP'
     +                 ,'Trying to take asin of a number > 1')
                  endif
C
C             "ACOS"
C
              ELSEIF(LSTP(IPOS).EQ.14) THEN
                  if(val.ge.-1.0 .and. val.le.+1.0) then
                      STACK(ISTK) = ACOS(VAL)
                  else
                      call m_emsg('AM_EXP'
     +                 ,'Trying to take acos of a number > 1')
                  endif
C
C             "ATAN"
C
              ELSEIF(LSTP(IPOS).EQ.15) THEN
                  STACK(ISTK) = ATAN(VAL)
C
C             "ABS"
C
              ELSEIF(LSTP(IPOS).EQ.16) THEN
                  STACK(ISTK) = ABS(VAL)
C
C             "INT"
C
              ELSEIF(LSTP(IPOS).EQ.17) THEN
                  STACK(ISTK) = FLOAT(INT(VAL))
C
C             "NINT"
C
              ELSEIF(LSTP(IPOS).EQ.18) THEN
                  STACK(ISTK) = FLOAT(NINT(VAL))
C
C             "MIN"
C
              ELSEIF(LSTP(IPOS).EQ.19) THEN
                  ISTK = ISTK - 1
                  STACK(ISTK) = MIN(VAL,STACK(ISTK))
C
C             "MAX"
C
              ELSEIF(LSTP(IPOS).EQ.20) THEN
                  ISTK = ISTK - 1
                  STACK(ISTK) = MAX(VAL,STACK(ISTK))
C
C             "MOD"
C
              ELSEIF(LSTP(IPOS).EQ.21) THEN
                  ISTK = ISTK - 1
                  STACK(ISTK) = MOD(NINT(STACK(ISTK)),NINT(VAL))
C
C             "SIGN"
C
              ELSEIF(LSTP(IPOS).EQ.22) THEN
                  ISTK = ISTK - 1
                  STACK(ISTK) = SIGN(STACK(ISTK),VAL)
C
C             "Date" yymmdd
C
              elseif(lstp(ipos).eq.23) then
                  ndate = nint(val)
                  ntime = 0
                  call m_pkts(ndate,ntime,itsec)
                  stack(istk) = am_tdif(0,itsec,timnam(nmtime)(1:1))
C
C             "Time" hhmmss
C
              elseif(lstp(ipos).eq.24) then
                  ndate = 800101
                  ntime = nint(val)
                  call m_pkts(ndate,ntime,itsec)
                  stack(istk) = am_tdif(0,itsec,timnam(nmtime)(1:1))
C
C             "Time_min" hhmm
C
              elseif(lstp(ipos).eq.25) then
                  ndate = 800101
                  ntime = nint(val) * 100
                  call m_pkts(ndate,ntime,itsec)
                  stack(istk) = am_tdif(0,itsec,timnam(nmtime)(1:1))
C
C             "Date_tim" yymmdd + hhmmss
C
              elseif(lstp(ipos).eq.26) then
                  istk = istk - 1
                  ndate = nint(stack(istk))
                  ntime = nint(val)
                  call m_pkts(ndate,ntime,itsec)
                  stack(istk) = am_tdif(0,itsec,timnam(nmtime)(1:1))
C
C             "Date_min" yymmdd + hhmm
C
              elseif(lstp(ipos).eq.27) then
                  istk = istk - 1
                  ndate = nint(stack(istk))
                  ntime = 100*nint(val)
                  call m_pkts(ndate,ntime,itsec)
                  stack(istk) = am_tdif(0,itsec,timnam(nmtime)(1:1))
C
C             "FPOS"
C
              ELSEIF(LSTP(IPOS).EQ.28) THEN
                  IFUN = LSTF(IPOS)
                  VAL2 = 0.0
                  IF(IFUN .EQ. 0) THEN
                      STACK(ISTK) = XMNALL(VAL,VAL2,0,WMNHER)
                  ELSE
                      STACK(ISTK) = XMNFUN(VAL,VAL2,IFUN,0
     1                 ,FPAR(1,IFUN),WMNHER)
                  ENDIF
C
C             "FNEG"
C
              ELSEIF(LSTP(IPOS).EQ.29) THEN
                  IFUN = LSTF(IPOS)
                  VAL1 = .9999999 * VAL - 1.E-6 * FNSTEP
                  VAL2 = 0.0
                  IF(IFUN .EQ. 0) THEN
                      STACK(ISTK) = XMNALL(VAL1,VAL2,0,WMNHER)
                  ELSE
                      STACK(ISTK) = XMNFUN(VAL1,VAL2,IFUN,0
     1                 ,FPAR(1,IFUN),WMNHER)
                  ENDIF
C
C             "DFPOS"
C
              ELSEIF(LSTP(IPOS).EQ.30) THEN
                  IFUN = LSTF(IPOS)
                  DX = FNSTEP
                  VAL2 = 0.0
                  IF(IFUN .EQ. 0) THEN
                      Y2 = XMNALL(VAL+2.0*DX,VAL2,0,WMNHER)
                      Y1 = XMNALL(VAL+1.0*DX,VAL2,0,WMNHER)
                      Y0 = XMNALL(VAL,VAL2,0,WMNHER)
                  ELSE
                      Y2 = XMNFUN(VAL+2.0*DX,VAL2,IFUN,0
     1                 ,FPAR(1,IFUN),WMNHER)
                      Y1 = XMNFUN(VAL+1.0*DX,VAL2,IFUN,0
     1                 ,FPAR(1,IFUN),WMNHER)
                      Y0 = XMNFUN(VAL,VAL2,IFUN,0
     +                 ,FPAR(1,IFUN),WMNHER)
                  ENDIF
                  DEL = (Y1 - Y0)
                  DDEL = (Y2 - Y1) - DEL
                  STACK(ISTK) = (DEL - .5*DDEL) / (2.*DX)
C
C             "DDFPOS"
C
              ELSEIF(LSTP(IPOS).EQ.31) THEN
                  IFUN = LSTF(IPOS)
                  DX = FNSTEP
                  VAL2 = 0.0
                  IF(IFUN .EQ. 0) THEN
                      Y3 = XMNALL(VAL+3.0*DX,VAL2,0,WMNHER)
                      Y2 = XMNALL(VAL+2.0*DX,VAL2,0,WMNHER)
                      Y1 = XMNALL(VAL+1.0*DX,VAL2,0,WMNHER)
                      Y0 = XMNALL(VAL,VAL2,0,WMNHER)
                  ELSE
                      Y3 = XMNFUN(VAL+3.0*DX,VAL2,IFUN,0
     1                 ,FPAR(1,IFUN),WMNHER)
                      Y2 = XMNFUN(VAL+2.0*DX,VAL2,IFUN,0
     1                 ,FPAR(1,IFUN),WMNHER)
                      Y1 = XMNFUN(VAL+1.0*DX,VAL2,IFUN,0
     1                 ,FPAR(1,IFUN),WMNHER)
                      Y0 = XMNFUN(VAL,VAL2,IFUN,0
     +                 ,FPAR(1,IFUN),WMNHER)
                  ENDIF
                  DDEL  = (Y2 - Y1) - (Y1 - Y0)
                  DDDEL = (Y3 - Y2) - (Y2 - Y1) - DDEL
                  STACK(ISTK) = (DDEL - DDDEL/3.) / DX**2
C
C             "DFNEG"
C
              ELSEIF(LSTP(IPOS).EQ.32) THEN
                  IFUN = LSTF(IPOS)
                  DX = FNSTEP
                  VAL1 = .9999999 * VAL - 1.E-6 * DX
                  VAL2 = 0.0
                  IF(IFUN .EQ. 0) THEN
                      Y2 = XMNALL(VAL1-2.0*DX,VAL2,0,WMNHER)
                      Y1 = XMNALL(VAL1-1.0*DX,VAL2,0,WMNHER)
                      Y0 = XMNALL(VAL1,VAL2,0,WMNHER)
                  ELSE
                      Y2 = XMNFUN(VAL1-2.0*DX,VAL2,IFUN,0
     +                 ,FPAR(1,IFUN),WMNHER)
                      Y1 = XMNFUN(VAL1-1.0*DX,VAL2,IFUN,0
     +                 ,FPAR(1,IFUN),WMNHER)
                      Y0 = XMNFUN(VAL1,VAL2,IFUN,0
     +                 ,FPAR(1,IFUN),WMNHER)
                  ENDIF
                  DEL = (Y0 - Y1)
                  DDEL = DEL - (Y1 - Y2)
                  STACK(ISTK) = (DEL + .5*DDEL) / (2.*DX)
C
C             "DDFNEG"
C
              ELSEIF(LSTP(IPOS).EQ.33) THEN
                  IFUN = LSTF(IPOS)
                  DX = FNSTEP
                  VAL1 = .9999999 * VAL - 1.E-6 * DX
                  VAL2 = 0.0
                  IF(IFUN .EQ. 0) THEN
                      Y3 = XMNALL(VAL1-3.0*DX,VAL2,0,WMNHER)
                      Y2 = XMNALL(VAL1-2.0*DX,VAL2,0,WMNHER)
                      Y1 = XMNALL(VAL1-1.0*DX,VAL2,0,WMNHER)
                      Y0 = XMNALL(VAL1,VAL2,0,WMNHER)
                  ELSE
                      Y3 = XMNFUN(VAL1-3.0*DX,VAL2,IFUN,0
     1                 ,FPAR(1,IFUN),WMNHER)
                      Y2 = XMNFUN(VAL1-2.0*DX,VAL2,IFUN,0
     1                 ,FPAR(1,IFUN),WMNHER)
                      Y1 = XMNFUN(VAL1-1.0*DX,VAL2,IFUN,0
     1                 ,FPAR(1,IFUN),WMNHER)
                      Y0 = XMNFUN(VAL1,VAL2,IFUN,0
     +                 ,FPAR(1,IFUN),WMNHER)
                  ENDIF
                  DDEL  = (Y0 - Y1) - (Y1 - Y2)
                  DDDEL = DDEL - ((Y1 - Y2) - (Y2 - Y3))
                  STACK(ISTK) = (DDEL + DDDEL/3.) / DX**2
C
C             "FINT"  .... COMPUTE INTEGRAL BETWEEN 2 LIMITS
C
              ELSEIF(LSTP(IPOS).EQ.34) THEN
                  IFUN = LSTF(IPOS)
                  XMIN = STACK(ISTK-1)
                  XMAX = VAL
                  ISTK = ISTK - 1
                  STACK(ISTK) = AMNINT(IFUN,0,XMIN,XMAX,NERR)
              ENDIF
C
C         SOME KIND OF OPERAND
C
          ELSE
              IF(LSTYP(IPOS).GT.0) COMAND = CLCNAM(LSTYP(IPOS))
C
C             FLOATING POINT CONSTANT
C
              IF(LSTYP(IPOS).EQ.0) THEN
                  ISTK =ISTK + 1
                  ISTACK(ISTK) = LSTP(IPOS)
C
C             Register
C
              ELSEIF (COMAND .EQ. 'R' .OR. COMAND.EQ.'IR') THEN
                  ISTK = ISTK + 1
                  STACK(ISTK) = 0.
                  IREG = LSTP(IPOS)
                  STACK(ISTK) = REGIS(IREG)
C
C             Parameter
C
              ELSEIF (COMAND .EQ. 'P' .OR. COMAND.EQ.'ERR' .OR.
     1                COMAND.EQ.'ERP' .OR. COMAND.EQ.'ERN' .OR.
     1                COMAND.EQ.'LOLIM' .OR. COMAND.EQ.'HILIM') THEN
                  ISTK = ISTK + 1
                  STACK(ISTK) = 0.
                  IFUN = LSTF(IPOS)
                  IPAR = LSTP(IPOS)
                  IF(COMAND.EQ.'P') THEN
                      STACK(ISTK) = FPAR(IPAR,IFUN)
                  ELSEIF(COMAND.EQ.'ERR') THEN
                      STACK(ISTK) = DFPAR(IPAR,IFUN)
                  ELSEIF(COMAND.EQ.'ERN') THEN
                      STACK(ISTK) = DNFPAR(IPAR,IFUN)
                  ELSEIF(COMAND.EQ.'ERP') THEN
                      STACK(ISTK) = DPFPAR(IPAR,IFUN)
                  ELSEIF(COMAND.EQ.'LOLIM') THEN
                      STACK(ISTK) = FPARLO(IPAR,IFUN)
                  ELSEIF(COMAND.EQ.'HILIM') THEN
                      STACK(ISTK) = FPARHI(IPAR,IFUN)
                  ENDIF
C
C             X Data value
C
              ELSE IF (COMAND.EQ.'X'   .OR. COMAND.EQ.'Y'   .OR.
     +                 COMAND.EQ.'DX'  .OR. COMAND.EQ.'DY'  .OR.
     +                 COMAND.EQ.'DNX' .OR. COMAND.EQ.'DNY' .OR.
     +                 COMAND.EQ.'DPX' .OR. COMAND.EQ.'DPY') THEN
                  ISTK = ISTK + 1
                  STACK(ISTK) = 0.
                  ISET = LSTF(IPOS)
                  IBIN = LSTP(IPOS)
                  IVAR = LSTV(1,IPOS)
                  IELM = MAX0(1,LSTV(2,IPOS))
                  IF(IVAR.GT.0) THEN
                      STACK(ISTK) = AMNP(IBIN,ISET,IVAR,IELM,NERR)
                  ELSEIF(COMAND.EQ.'X') THEN
                      STACK(ISTK) = AMNX(IBIN,ISET,NERR)
                  ELSEIF(COMAND.EQ.'Y') THEN
                      STACK(ISTK) = AMNE(IBIN,ISET,NERR)
                  ELSEIF(COMAND.EQ.'DX') THEN
                      STACK(ISTK) = AMNDXN(IBIN,ISET,NERR)
                  ELSEIF(COMAND.EQ.'DY') THEN
                      STACK(ISTK) = AMNDEN(IBIN,ISET,NERR)
                  ELSEIF(COMAND.EQ.'DNX') THEN
                      STACK(ISTK) = AMNDXN(IBIN,ISET,NERR)
                  ELSEIF(COMAND.EQ.'DNY') THEN
                      STACK(ISTK) = AMNDEN(IBIN,ISET,NERR)
                  ELSEIF(COMAND.EQ.'DPX') THEN
                      STACK(ISTK) = AMNDXP(IBIN,ISET,NERR)
                  ELSEIF(COMAND.EQ.'DPY') THEN
                      STACK(ISTK) = AMNDEP(IBIN,ISET,NERR)
                  ENDIF
              ENDIF
          ENDIF
C
3000  CONTINUE
C
      IF(ISTK .NE. 1) THEN
          WRITE(LUNTTO,5001)ISTK
5001      FORMAT(' AM_EXP: Stack pointer =',I3,'. Should be 1')
      ENDIF
      AM_EXP = STACK(ISTK)
C
      END
