      SUBROUTINE M_HCOP(IDELIM)
C
C------------------------------------------------------------------------------
C     Copies or renames histograms, both Mn_Fit and HBOOK
C------------------------------------------------------------------------------
C
      implicit none
*
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      integer idelim
*
      character title*80
      LOGICAL QZERO,QMNHEX,HEXIST
      integer ida1,idb1,ida2,idb2,idh1,idh2
     + ,nh,nh2,nnid,nloop,nptrh2,nptrd2
     + ,nwtot,nwhead,nwh2,ierr,ii,kind(32)
     + ,nbinx,nbiny,nwt,locate,ioerr
      real xlo,xhi,ylo,yhi
C
      CALL WAITYQ('Give input, output histogram numbers: ')
      CALL MN_HNO(IDA1,IDB1,IDELIM,NNID)
      IF(NNID.LE.0) GOTO 9000
      IF(IDA1.LT.0) GOTO 9000
      CALL WAITYP('Give output histogram number: ')
      CALL MN_HNO(IDA2,IDB2,IDELIM,NNID)
      IF(IDA2.LT.0) GOTO 9000
      IF(NNID.LE.0) GOTO 9000
C
      IF(COMND1.EQ.'HCOPY' .OR. COMND1.EQ.'HRENAME') THEN
          IF(IDA1.LE.0 .OR. IDA2.LE.0) THEN
              WRITE(TXTERR,'('' Input or output histogram''
     1             ,'' number is not valid:'',2I7)') IDA1,IDA2
              CALL MN_ERR('M_HCOP',TXTERR)
              GOTO 9000
          ENDIF
      ENDIF
C
      QZERO = .FALSE.
      NLOOP = 1
      IF(IDA1.EQ.0 .AND. IDA2.EQ.0) THEN
          QZERO = .TRUE.
          NLOOP = NDHIS
      ENDIF
      DO 4830 II=1,NLOOP
          IF(QZERO) THEN
              IF(IDPTRH(II).LE.0 .OR. IDPTRD(II).LE.0)
     1             GOTO 4830
              IDA1 = IDIDA(II)
              IF(IDB1.NE.IDIDB(II)) GOTO 4830
              IDA2 = IDA1
          ENDIF
          CALL MN_HGT(IDA1,IDB1,NH)
          IF(NH.LE.0) THEN
              WRITE(TXTERR,'(''Histogram'',I7,I4
     1             ,'' does not exist'')') IDA1,IDB1
              CALL MN_ERR('M_HCOP',TXTERR)
              GOTO 4830
          ENDIF
          NWTOT  = NINT(RDAT(NPTRH))
          NWHEAD = NINT(RDAT(NPTRH+1))
C
C         Ntuples which are not in memory cannot be renamed or copied
C
          IF(NWDAT.LE.0 .AND. IDA1.NE.IDA2) THEN
              WRITE(TXTERR,'(''You cannot rename or copy''
     +             ,'' the primary id for Ntuple'',I7)') IDA1
              CALL M_EMSG('M_HCOP',TXTERR)
              CALL M_EMSG('M_HCOP','It is not stored in memory')
              GOTO 4830
          ENDIF
C
          IF(COMND1.EQ.'COPY') THEN
              CALL MN_HNW(IDA2,IDB2,NDIM,NWDAT
     1             ,NH2,NPTRH2,NPTRD2,NWH2,NBPPT,NTMODE)
              IF(NH2.LE.0) GOTO 4831
C
C             Copy the header and data separately to allow for
C             change in the header length
C             Zero any words of header not copied
C
              CALL UCOPY_r(RDAT(NPTRH),RDAT(NPTRH2),NWHEAD)
              CALL UCOPY_r(RDAT(NPTRD),RDAT(NPTRD2),NWDAT)
              IF(NWHEAD.LT.NWH2) THEN
                  CALL VZERO_r(RDAT(NPTRH2+NWHEAD+1),NWH2-NWHEAD)
                  NWTOT = NWH2 + NWDAT
                  RDAT(NPTRH2)   = NWTOT
                  RDAT(NPTRH2+1) = NWH2
              ENDIF
              RDAT(NPTRH2+3) = IDA2
              RDAT(NPTRH2+4) = IDB2
              CALL MN_PTU(NH2,NWTOT,IDA2,IDB2,NPTRH2,NPTRD2
     1             ,TDTIT(NH),TDFIL(NH),TDDIR(NH),TDNAM(1,NH))
          ELSEIF(COMND1.EQ.'RENAME') THEN
              IF(QMNHEX(IDA2,IDB2,NH2)) THEN
                  WRITE(TXTERR,'(''Histogram'',I7,I4
     1                 ,'' already exists''
     2                 ,'' and will be overwritten'')') IDA2,IDB2
                  CALL M_EMSG('M_HCOP',TXTERR)
                  IDPTRH(NH2) = -IABS(IDPTRH(NH2))
                  IDPTRD(NH2) = -IABS(IDPTRD(NH2))
              ENDIF
              IDIDA(NH) = IDA2
              IDIDB(NH) = IDB2
              RDAT(NPTRH+3) = IDA2
              RDAT(NPTRH+4) = IDB2
          ENDIF
C
C             COPY OR RENAME HBOOK HISTOGRAM
C
          IF(COMND1.EQ.'COPY' .OR. COMND1.EQ.'RENAME') THEN
cicb                  IDH1 = IDB1*1000 + IDA1
cicb                  IDH2 = IDB2*1000 + IDA2
              IDH1 = IDA1
              IDH2 = IDA2
          ELSEIF(COMND1.EQ.'HCOPY' .OR. COMND1.EQ.'HRENAME') THEN
              IDH1 = IDA1
              IDH2 = IDA2
          ENDIF
*
*         Initialize the HBOOK file if this is an HBOOK histogram
*
          if(tdfil(nh)(1:1).ne.'*' .and. tddir(nh).ne.' ') then
              call m_intp(ida1,idb1,nh,ierr)
              if(ierr.ne.0) then
                  WRITE(TXTERR,'(''Error initializing'',I7
     1             ,'' copy of HBOOK histogram'')') IDH1
                  CALL M_EMSG('M_HCOP',TXTERR)
                  goto 4830
              endif
          elseif(comnd1.eq.'HCOPY' .or. comnd1.eq.'HRENAME') then
              write(txterr,'(''Histogram '',I7,I4
     +         ,'' is not an HBOOK histogram'')',iostat=ioerr)
     +         ida1,idb1
              call m_emsg('M_HCOP',txterr)
              goto 4830
          endif
*
*         Copy the HBOOK histogram only if it matches the Mn_Fit one
*
          IF(HEXIST(IDH1) .AND. IDH1.NE.IDH2) THEN
              IF(HEXIST(IDH2)) CALL HDELET(IDH2)
*
              if(ndim.lt.0) then
                  WRITE(TXTERR,'(''HBOOK Ntuple'',I7
     1             ,'' will not be copied or renamed'')') IDH1
                  CALL M_EMSG('M_HCOP',TXTERR)
                  goto 4830
              elseif(ndim.gt.2) then
                  WRITE(TXTERR,'(''Mn_Fit histogram is > 2-D.''
     +            ,''  HBOOK histogram'',I7
     1             ,'' will not be copied or renamed'')') IDH1
                  CALL M_EMSG('M_HCOP',TXTERR)
                  goto 4830
*
*             Histogram is a projection. HBOOK copy does not exist
*
              elseif(tdfil(nh)(1:1).eq.'*') then
                  goto 4830
              endif
*
*             Check that the HBOOK histogram is the correct one
*             Do not try to copy Ntuples
*
              call hkind(idh1,kind,' ')
              if(kind(1).gt.0 .and. kind(1).ne.4) then
                  call hgive(idh1,title,nbinx,xlo,xhi,nbiny,ylo,yhi
     +             ,nwt,locate)
                  if(idbin(1).ne.nbinx .or.
     +               (ndim.eq.2 .and. idbin(2).ne.nbiny)) then
                      WRITE(TXTERR,'(''HBOOK histogram'',I7
     1                 ,'' does not match Mn_Fit histogram'')') IDH1
                      CALL M_EMSG('M_HCOP',TXTERR)
                      WRITE(TXTERR
     +                 ,'(''It will not be copied or renamed'')')
                      CALL M_EMSG('M_HCOP',TXTERR)
                      goto 4830
                  endif
*
                  CALL HCOPY(IDH1,IDH2,' ')
                  IF(COMND1.EQ.'RENAME' .OR. COMND1.EQ.'HRENAME')
     1             CALL HDELET(IDH1)
              elseif(kind(1).eq.4) then
                  write(txtmes,'('' HBOOK histogram'',I7
     +             ,'' is an Ntuple.''
     +             ,'' It will not be copied or renamed'')')
*ICB                  call m_emsg('M_HCOP',txterr)
              endif
          ELSEIF(COMND1.EQ.'HCOPY' .OR. COMND1.EQ.'HRENAME') THEN
              WRITE(TXTERR,'('' Histogram'',I7,'' does not exist''
     +         ,'' in the current HBOOK directory'')') IDH1
              CALL M_EMSG('M_HCOP',TXTERR)
          ENDIF
 4830 CONTINUE
 4831 CONTINUE
C
 9000 CONTINUE
      END
