#if ( defined(VMS) )
      SUBROUTINE M_START_
#endif
#if ( !defined(VMS) )
      SUBROUTINE M_START
#endif
C
C-----------------------------------------------------------------------
C
C     Starts up Mn_Fit
C
C     Called by MN_FIT for now
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
#include "mnpar.inc"
#include "mnfit.inc"
#include "mnfun.inc"
#include "mnflg.inc"
#include "mncmd.inc"
#include "mnhpj.inc"
#include "mntyq.inc"
#include "mnprj.inc"
#include "mngrn.inc"
#include "mnlun.inc"
#include "mnchar.inc"
C
      REAL HLIM
      COMMON/PAWC/HLIM(MHBKWD)
C
      REAL RDAT
      COMMON/MNDAT/RDAT(MHSTWD)
C
      CHARACTER*80 TLOGON
      CHARACTER*40 vers,date
      integer lvers, ldate
C
      INTEGER IZEBRA,IDEP,ILEV,LENT,LNBLNK,NDEV,NMODE,IDELIM
C
#if ( defined(VMS) )
      integer mlist
      parameter (mlist = 10)
      CHARACTER*80 TXT1
      INTEGER ISTAT,LEN,LIB$GET_FOREIGN
      INTEGER ICMD,ICMTYP,icmlst,nmatch,IERR,ilist(mlist)
#endif

C
      EXTERNAL MN_EXI
      EXTERNAL MN_BRK
      EXTERNAL LNBLNK
C
C     Get the translations of mn_fit_dir etc.
C
      CALL M_HOME
C
C     Top level Mn_Fit initializations including units
C
      CALL MN_INT
      CALL M_INIT(0)
C
C     Lock the units I use
C
      CALL CLEO_INILUN
      CALL CLEO_LOKLUN(LUNTTI,'MN_FIT')
      CALL CLEO_LOKLUN(LUNTTO,'MN_FIT')
      CALL CLEO_LOKLUN(LUNLPT,'MN_FIT')
      CALL CLEO_LOKLUN(LUNTMP,'MN_FIT')
      CALL CLEO_LOKLUN(LUNPUN,'MN_FIT')
C
      CALL TYPINI
      CALL TYQINI
C
C     Backslash and tab
C
      TAB = CHAR(9)
      BSL = CHAR(92)
C
C     Get the Mn_Fit version number
C
      vers = '$Name: v5_05 $'
      date = 'Date: 2005/03/18 15:28'
      lvers = lnblnk(vers)
      ldate = max(lnblnk(date),7)
      if (lvers.eq.9) vers = '*Name: vdev *'
      lvers = lnblnk(vers)
      WRITE(LUNTTO,'(1X,78(''*'')
     + ,/,T15,'' Welcome to MN_FIT Version '',A,2X,A)')
     + vers(8:lvers-2),date(7:ldate)
C
C     GET THE LATEST VERSION NUMBER AND GET THE NEWS
C
      CALL MN_VRS
C      CALL MN_NWS
C
      WRITE(LUNTTO,'(
     +  /,'' Enter HELP to get a list of commands''
     + ,/,'' Mn_Fit homepage:''
     +   ,'' http://www-zeus.physik.uni-bonn.de/~brock/mn_fit.html''
     + ,/,'' In case of problems contact Ian C. Brock,''
     + ,/,'' Email: brock@physik.uni-bonn.de, Tel: ++49 228 733616''
     + ,/,1X,78(''*''))')
C
C     Open the database - if $L3_DB option is selected
C
      CALL M_DBINIT(IZEBRA)
C
C     INITIALIZE HBOOK STORAGE SPACE
C
      IF(IZEBRA.EQ.0) THEN
          CALL HLIMIT(MHBKWD)
      ELSE
          CALL HLIMIT(-MHBKWD)
      ENDIF
      CALL HOUTPU(LUNTTO)
      CALL HERMES(LUNTTO)
C
C     INITIALIZE HIGZ
C
      CALL IGINIT(MHGZWD)
      CALL IGZSET('G')
C
C     Initialize COMIS and set up address for routines and common blocks
C
      CALL MN_CSI
C
C     Initialize all the commands and set up the list of characters
C     allowed in commands and the default delimiter
C
      CALL MN_INC
      CALL ICMSYM(TSPSYM)
      TSDSCN = ','
      LENT = LNBLNK(TSDSCN)
      CALL SDLSCN(TSDSCN(1:LENT))
C
C     Initialize stuff for functions including
C     Upsilon resonance masses for LUND
C
      CALL MN_INF
      CALL MN_INL
C
C     Turn on echoing, off auto-logging of commands and on aliasing
C     Turn off adding extra characters for the manual
C     Turn on aborting of files when there is an error
C
      QECHO   = .TRUE.
      QALOG   = .FALSE.
      QALIAS  = .TRUE.
      QMANUAL = .FALSE.
      QABORT  = .TRUE.
C
C     Get the list of screen and hardcopy devices
C
      CALL TVDEV
C
C     You can pass the graphics device as an argument on the Vax
C
      NDEV = 0
#if ( defined(VMS) )
*
      istat = lib$get_foreign(txt1,,lent,)
      if(lent.gt.0) then
          write(6,'('' Foreign material: '',a)') txt1(:lent)
          call quotyp(txt1(:lent))
          icmd = icmtyp(.true.,idelim,tpsof)
          nmatch = icmlst(mlist,ilist)
          if(icmd.gt.0) then
              ndev = icmd
          elseif(icmd.eq.0 .and. nmatch.gt.0 .and.
     +     tpsof(ilist(1)).eq.'DISPLAY') then
              ndev = 10 + mdisp0
          endif
          call zertyp('.FALSE.')
      endif
#endif
#if ( defined(L3_CPC) )
*
C     For the CPC version, set up the communication with the monitor
C     process
*
      CALL M_CPCINI(IERR)
      IF(IERR.NE.0) GOTO 9000
C
C     Let monitor control know the Mn_Fit version number
C
      WRITE(TXTMES,'(''Running Mn_Fit Version'',A,2X,A)')
     + VERS,DATE
      CALL SEND_MES('R',TXTMES)
#endif

C
C     Get the screen device
C
      CALL TVBGN(NDEV)
C
C     Initialize the parameters needed for special displays
C     implemented for L3
C
      CALL MN_DSI
C
C     Set Mn_Fit default values
C
      CALL MN_DFL
C
C     Get units I want to use
C
      CALL CLEO_GETLUN(LUNHIN,'MN_FIT')
      CALL CLEO_GETLUN(LUNAIN,'MN_FIT')
      CALL CLEO_GETLUN(LUNDIN,'MN_FIT')
      CALL CLEO_GETLUN(LUNMIN,'MN_FIT')
      CALL CLEO_GETLUN(LUNSIN,'MN_FIT')
      lunrin = 0
*ICB      CALL CLEO_GETLUN(LUNYIN,'MN_FIT')
      CALL CLEO_GETLUN(LUNFIN,'MN_FIT')
      FIL_HB   = ' '
      FIL_AV   = ' '
      FIL_DT   = ' '
      FIL_MN   = ' '
      FIL_SC   = ' '
      FIL_root = ' '
      FIL_FI   = ' '
      NRCLHB   = 1024
      DIR_HB   = ' '
      DIR_HC   = '//PAWC'
*
*     Set the directory paths
*
      DIR_WD = ' '
#if ( defined(UNIX) )
      npath = 2
      tpath(1) = '$HOME/mnf/'
      tpath(2) = '$MN_FIT/help/'
#endif
#if ( !defined(UNIX) )
      npath = 1
      tpath(1) = 'mn_fit_help:'
#endif

C
      FIL_DP = ' '
C
C     Zero stuff for fitting
C
      NHFIT  = 0
      NDFIT  = 0
      CALL VZERO_i(IXEXCL,MFITMX)
      CALL VZERO_i(IYEXCL,MFITMX)
      CALL VZERO_i(IXINCL,MFITMX)
      CALL VZERO_i(IYINCL,MFITMX)
C
C     Set default options/parameters for fitting
C
      CALL M_FDFL
C
C     QDSKIP is flag for if we are skipping commands inside a DO loop
      QDSKIP = .FALSE.
C
      QHBPRT = .FALSE.
      QSHIST = .FALSE.
      QSORTH = .FALSE.
      QSNORM = .FALSE.
      QSBACK = .FALSE.
C
C     QPROJ indicates we are doing a projection and can use Ntuple variable
C     names when parsing expressions
      QPROJ = .FALSE.
C
C     QIF indicates we are in an IF block.  QCOND indicates whether the IF
C     conditional statement was true or false.  IIFLV is the present level of
C     IF construct nesting.
C
      DO 1500 IDEP=1,MTDEP
          QIF(IDEP) = .FALSE.
          IIFLV(IDEP)  = 0
          DO 1450  ILEV = 1, MXIFLV
              QCOND(ILEV,IDEP) = .FALSE.
              QCONDI(ILEV,IDEP) = .FALSE.
 1450     CONTINUE
 1500 CONTINUE
cif      IFIIFL = 0
C
C     Zero stuff for internal commands
C
      NOPR = 0
      CALL TZERO(OPRNAM,MOPR)
      CALL VZERO_i(IOPRP1,MOPR)
      CALL VZERO_i(IOPRP2,MOPR)
C
C     Zero stuff for DO loops
C
      CALL VZERO_i(NFORDP,MTDEP)
C
C     Zero stuff for aliases
C
      nalias = 0
      call tzero(talias,malias)
C
C     Execute the login com file
C     First get the filename
C
      CALL MN_LGI(TLOGON)
      IF(TLOGON.NE.' ') THEN
          CALL QUOTYQ(TLOGON)
          NMODE  = -1
          IDELIM = 0
          CALL TYQOPN(NMODE,IDELIM)
      ENDIF
C
C     Setup the KUIP break handler
C
      CALL KUEXIT(MN_EXI)
      CALL KUBREK(MN_BRK)
C
 9000 CONTINUE
      END
