#if ( defined(VMS) ) && ( defined(L3_CPC) )
      SUBROUTINE M_CPCINI(IERR)
C
C     Initializes the communication between Mn_Fit and Monitor program
C
      EXTERNAL ASTR_CMD
C
#include "mncpc.inc"
#include "mnlun.inc"
*
      INTEGER SYS$WAITFR
      CHARACTER*7 CPUNODE
      INTEGER JSTAT(4)
      CHARACTER*20 ECHK_MNFIT_CACHE
C
      IERR = 0
C
C     Find out which node I am running on
C
      ISTAT = LIB$SYS_TRNLOG('SYS$NODE',,CPUNODE)
      WRITE(LUNTTO,'('' M_CPCINI: Mn_Fit running on node: '',A)')
     + CPUNODE
      MNFIT_NODE_NAME = CPUNODE(2:7)
*
*     Book the process watcher infocache
*
      ECHK_MNFIT_CACHE = 'ECHK_MNFIT_' // MNFIT_NODE_NAME
      LENT = LENOCC(ECHK_MNFIT_CACHE)
      WRITE(LUNTTO
     + ,'('' M_CPCINI: Booking process watcher cache: '',A)')
     + ECHK_MNFIT_CACHE(1:LENT)
      CALL IC_BOOK(ECHK_MNFIT_CACHE(1:LENT),JSTAT,'L',IERR)
      JSTAT(1) = -1
      CALL IC_STATUS(ECHK_MNFIT_CACHE(1:LENT),JSTAT,' ',IERR)
*
*     Define the filenames
*
      MNFIT_CMD_CLUSCOM_NAME = 'MNCPC_CMD_'//MNFIT_NODE_NAME
      MNFIT_CMD_CLUSCOM_FILE = 'L3DAQ$DAT:[SCRATCH]MN_CPC_' //
     + MNFIT_NODE_NAME // '.CMD'
      MNFIT_CMD_IC_NAME      = 'MNFIT_CMD_'//MNFIT_NODE_NAME
      MNFIT_MES_CLUSCOM_NAME = 'MNCPC_MES_'//MNFIT_NODE_NAME
      MNFIT_MES_CLUSCOM_FILE = 'L3DAQ$DAT:[SCRATCH]MN_CPC_' //
     + MNFIT_NODE_NAME // '.MES'
      MNFIT_MES_IC_NAME      = 'MNFIT_MES_'//MNFIT_NODE_NAME
*
*     Get an event flag number for the infocache
*
      CALL LIB$GET_EF(ICR)
      CALL SYS$CLREF(%VAL(ICR))
*
*     Book the command cluscom and infocache
*
      CALL CC_SETUP(MNFIT_CMD_CLUSCOM_NAME,MNFIT_CMD_CLUSCOM_FILE
     + ,IF_CMD,IL_CMD,' ',IERR)
      IF(IERR.NE.0) THEN
          WRITE(LUNTTO,1020) IERR,MNFIT_CMD_CLUSCOM_NAME
1020      FORMAT(' *** M_CPCINI: CC_SETUP error',I10,' in ',A)
          GOTO 777
      ENDIF
*
      CALL IC_BOOK(MNFIT_CMD_IC_NAME, ICMD, 'M', IERR)
      IF(IERR.NE.0) THEN
          WRITE(LUNTTO,1000) IERR,MNFIT_CMD_IC_NAME
1000      FORMAT(' *** M_CPCINI: IC_BOOK error ',I10,' in ',A)
          GOTO 777
      ENDIF
*
      CALL IC_ASSOCIATE(MNFIT_CMD_IC_NAME, ICMD, ASTR_CMD, ' ',IERR)
      IF(IERR.NE.0) THEN
          WRITE(LUNTTO,1010) IERR,MNFIT_CMD_IC_NAME
1010      FORMAT(' *** M_CPCINI: IC_ASSOCIATE error ',I10,' in ',A)
          GOTO 777
      ENDIF
*
*     Create CLUSCOM section
*
      CALL CC_SETUP(MNFIT_MES_CLUSCOM_NAME,MNFIT_MES_CLUSCOM_FILE
     + ,IF_MES,IL_MES,' ',IERR)
      IF (IERR.NE.0) THEN
          WRITE(LUNTTO,1040) IERR,MNFIT_MES_CLUSCOM_NAME
1040      FORMAT(' *** M_CPCINI: CC_SETUP error',I10,' in ',A)
      ENDIF
*
*     Book INFOCACHE
*
      CALL IC_BOOK(MNFIT_MES_IC_NAME, IMES, 'C', IERR)
      IF(IERR.NE.0) THEN
          WRITE(LUNTTO,1030) IERR,MNFIT_MES_IC_NAME
1030      FORMAT(' *** M_CPCINI: IC_BOOK error ',I10,' in ',A)
          GOTO 777
      ENDIF
*
*     Wait 5 secs for everything to settle down before telling EFMONCO
*     that Mn_Fit is ready
*
      CALL LIB$WAIT(5.0)
*
777   CONTINUE
*
      END

#endif  /*  End of "vms_l3_cpc" Conditions  */
