      SUBROUTINE TVDEV
C
C     Sets up all the known devices for the various packages
C
      implicit none
*
C
#include "mngrn.inc"
C
      integer i
*
#if ( defined(VMS) ) && ( defined(HIGZ) )
      INCLUDE '($SSDEF)'
C
      INTEGER MHARDI
      PARAMETER (MHARDI=9)
C
      LOGICAL      ITYPVI(MAXPVI)
      CHARACTER* 3 PVIDEV(MAXPVI)
      CHARACTER* 20 DRIVER
      CHARACTER* 20 CONFIG
      CHARACTER*10 HARDEV(MHARDI)
      CHARACTER*60 PVINAM(MAXPVI),PVITMP,CFGNAM
      INTEGER      LENDEV(MHARDI)
C
      DATA         HARDEV /
     *          'PRINT','PLOT','LASER', 'TALARIS','POSTSCRIPT',
     *          'LN03', 'HP',  'IMAGEN','RASTERIZER'        /
C
#endif

C
#if ( defined(X11) )
      TGVERS = 'X11'
#endif
#if ( defined(PLTSUB) )
      TGVERS = 'PLTSUB'
#endif

C
      CALL TZERO(TPDEV,MPTOT)
      CALL TZERO(TPSOF,MPTOT)
      CALL TZERO(TPHRD,MPTOT)
      CALL VZERO_r(SZMAX,2*MPTOT)
      CALL VZERO_r(OFSET,2*MPTOT)
      CALL VZERO_i(IPLPOS,2*MPTOT)
      CALL VZERO_l(QPVERT,MPTOT)
C
      TPDEV(1)  = 'None'
      TPNAM(1)  = 'No output, but Mn_Fit goes through the motions!'
      IPUNIT(1) = 0
C
#if ( defined(HIGZ) ) && ( defined(X11) )
C
C     X11 Devices
C
      MPDEV = 20
      MPSOF = 14
      MPHRD = 6
      CALL VZERO_i(IPUNIT,MPTOT)
C
      TPDEV(2)  = 'Falco'
      TPNAM(2)  = 'Falco Terminal'
      IPUNIT(2) = 7878
C
      TPDEV(3)  = 'Xterm'
      TPNAM(3)  = 'Xterm Window'
      IPUNIT(3) = 7879
C
C     X Windows displays as specified in HIGZ_WINDOW.DAT
C
      DO I=1,10
          TPDEV(I+MDISP0) = 'DISPLAY'
          WRITE(TPNAM(I+MDISP0),'(''X Windows Display '',I2)') I
          IPUNIT(I+MDISP0) = I
      ENDDO
      CALL M_XFILE(1)
C
      TPDEV(14) = 'Unknown'
      TPNAM(14) = 'Use device number'
      IPUNIT(14)= 0
C
      TPDEV(15) = 'Postscript'
      TPNAM(15) = 'Postscript file (portrait)'
      IPUNIT(15)= -111
      SZMAX(1,15) = 19.6
      SZMAX(2,15) = 27.7
C
      TPDEV(16) = 'LPostscript'
      TPNAM(16) = 'Postscript file (landscape)'
      IPUNIT(16)= -112
      SZMAX(1,16) = 27.7
      SZMAX(2,16) = 19.6
C
      TPDEV(17) = 'EPostscript'
      TPNAM(17) = 'Encapsulated Postscript file'
      IPUNIT(17)= -113
C
      TPDEV(18) = 'CPostscript'
      TPNAM(18) = 'Colour Postscript file'
      IPUNIT(18)= -114
      SZMAX(1,18) = 19.6
      SZMAX(2,18) = 22.9
C
      TPDEV(19) = 'CLPostscript'
      TPNAM(19) = 'Colour Postscript file (landscape)'
      IPUNIT(19)= -115
      SZMAX(1,19) = 22.9
      SZMAX(2,19) = 19.6
C
      TPDEV(20) = 'Unknown'
      TPNAM(20) = 'Use device number'
      IPUNIT(20)= 0
C
#endif
#if ( defined(PLTSUB) )
C
      MPDEV = 17
      MPSOF = 10
      MPHRD = 7
C
      TPDEV( 2) = 'Grinnel'
      TPNAM( 2) = 'Grinnel screen'
      IPUNIT( 2) = "200000
      SZMAX(1, 2) = 25.4
      SZMAX(2, 2) = 25.4
C
      TPDEV( 3) = 'Tektronix'
      TPNAM( 3) = 'Tektronix 4014 terminal'
      IPUNIT( 3) = "4
      SZMAX(1, 3) = 25.4
      SZMAX(2, 3) = 20.3
C
      TPDEV( 4) = 'T10'
      TPNAM( 4) = 'Tektronix 4014 10 bit device'
      IPUNIT( 4) = "2
      SZMAX(1, 4) = 25.4
      SZMAX(2, 4) = 20.3
C
      TPDEV( 5) = 'T12'
      TPNAM( 5) = 'Tektronix 4014 12 bit device'
      IPUNIT( 5) = "4
      SZMAX(1, 5) = 25.4
      SZMAX(2, 5) = 20.3
C
      TPDEV( 6) = 'Vaxstation'
      TPNAM( 6) = 'UIS Vaxstation'
      IPUNIT( 6) = "20000000
      SZMAX(1, 6) = 25.4
      SZMAX(2, 6) = 20.3
C
      TPDEV( 7) = 'Decwindows'
      TPNAM( 7) = 'Decwindows device'
      IPUNIT( 7) = "100000000
      SZMAX(1, 7) = 26.0
      SZMAX(2, 7) = 20.3
C
      TPDEV( 8) = 'Versaterm'
      TPNAM( 8) = 'Versaterm terminal'
      IPUNIT( 8) = "4
      SZMAX(1, 8) = 25.4
      SZMAX(2, 8) = 20.3
C
      TPDEV( 9) = 'VT240'
      TPNAM( 9) = 'VT240 terminal'
      IPUNIT( 9) = "4
      SZMAX(1, 9) = 25.4
      SZMAX(2, 9) = 20.3
C
      TPDEV(10) = 'Falco'
      TPNAM(10) = 'Falco graphics terminal'
      IPUNIT(10) = "4
      SZMAX(1,10) = 25.4
      SZMAX(2,10) = 20.3
C
      TPDEV(11) = 'Talaris'
      TPNAM(11) = 'Talaris laser printer'
      IPUNIT(11) = "20000
      SZMAX(1,11) = 26.7
      SZMAX(2,11) = 20.5
      QPVERT(11) = .TRUE.
C
      TPDEV(12) = 'Tektronix'
      TPNAM(12) = 'Tektronix 4014 file'
      IPUNIT(12) = "400
      SZMAX(1,12) = 26.7
      SZMAX(2,12) = 20.5
      QPVERT(12) = .TRUE.
C
      TPDEV(13) = 'Postscript'
      TPNAM(13) = 'Postscript file (portrait)'
      IPUNIT(13) = "40000
      SZMAX(1,13) = 26.7
      SZMAX(2,13) = 20.5
      OFSET(1,13) = 0.5
      OFSET(2,13) = 0.0
      QPVERT(13) = .TRUE.
C
      TPDEV(14) = 'Imagen'
      TPNAM(14) = 'Imagen printer'
      IPUNIT(14) = "400000
      SZMAX(1,14) = 21.0
      SZMAX(2,14) = 20.0
      QPVERT(14) = .TRUE.
C
      TPDEV(15) = 'Versatec'
      TPNAM(15) = 'Versatec printer'
      IPUNIT(15) = "10000
      SZMAX(1,15) = 26.7
      SZMAX(2,15) = 20.5
      QPVERT(15) = .TRUE.
C
      TPDEV(16) = 'LN03'
      TPNAM(16) = 'LN03 plus printer (Tektronix option)'
      IPUNIT(16) = "400
      SZMAX(1,16) = 26.7
      SZMAX(2,16) = 20.5
      QPVERT(16) = .TRUE.
C
      TPDEV(17) = 'Unknown'
      TPNAM(17) = 'Use device number'
      IPUNIT(17) = 0
      SZMAX(1,17) = 26.7
      SZMAX(2,17) = 20.5
      QPVERT(17) = .TRUE.
#endif

C
      CALL TCOPY(TPDEV,TPSOF,MPSOF)
      CALL TCOPY(TPDEV(MPSOF+1),TPHRD,MPHRD)
*
*ICB      do i=1,mpdev
*ICB        write(6,'('' TVDEV: Device'',I3,'', Command: '',A,
*ICB     +   /,4X,''Name: '',A)') i,tpdev(i),tpnam(i)
*ICB        write(6,'(4X,''Unit:'',I6,'', Sizes:'',2F8.1)')
*ICB     +   ipunit(i),szmax(1,i),szmax(2,i)
*ICB      enddo
C
      END
