/* DO NOT EDIT *************************************************
 * THIS FILE AUTOMATICALLY GENERATED BY THE es_generator.py SCRIPT
 * API specification file:   main/APIspec.xml
 * GLES version:             GLES2.0
 * date:                     2012-10-24 22:35:01
 */


#include "GLES2/gl2.h"
#include "GLES2/gl2ext.h"
#include "main/mfeatures.h"
#include "main/compiler.h"
#include "main/api_exec.h"

#if FEATURE_ES2

#ifndef GLAPIENTRYP
#define GLAPIENTRYP GL_APIENTRYP
#endif


/* These types are needed for the Mesa veneer, but are not defined in
 * the standard GLES headers.
 */
typedef double GLdouble;
typedef double GLclampd;

/* Mesa error handling requires these */
extern void *_mesa_get_current_context(void);
extern void _mesa_error(void *ctx, GLenum error, const char *fmtString, ... );

/*************************************************************
 * Generated functions begin here
 */

extern void GL_APIENTRY _mesa_ActiveTextureARB(GLenum texture);
static void GL_APIENTRY _es_ActiveTexture(GLenum texture)
{
    switch(texture) {
        case GL_TEXTURE0:
        case GL_TEXTURE1:
        case GL_TEXTURE2:
        case GL_TEXTURE3:
        case GL_TEXTURE4:
        case GL_TEXTURE5:
        case GL_TEXTURE6:
        case GL_TEXTURE7:
        case GL_TEXTURE8:
        case GL_TEXTURE9:
        case GL_TEXTURE10:
        case GL_TEXTURE11:
        case GL_TEXTURE12:
        case GL_TEXTURE13:
        case GL_TEXTURE14:
        case GL_TEXTURE15:
        case GL_TEXTURE16:
        case GL_TEXTURE17:
        case GL_TEXTURE18:
        case GL_TEXTURE19:
        case GL_TEXTURE20:
        case GL_TEXTURE21:
        case GL_TEXTURE22:
        case GL_TEXTURE23:
        case GL_TEXTURE24:
        case GL_TEXTURE25:
        case GL_TEXTURE26:
        case GL_TEXTURE27:
        case GL_TEXTURE28:
        case GL_TEXTURE29:
        case GL_TEXTURE30:
        case GL_TEXTURE31:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glActiveTexture(texture=0x%x)", texture);
            return;
    }

    _mesa_ActiveTextureARB(texture);
}

extern void GL_APIENTRY _mesa_AttachShader(GLuint program, GLuint shader);
#define _es_AttachShader _mesa_AttachShader

extern void GL_APIENTRY _mesa_BindAttribLocationARB(GLuint program, GLuint index, const char * name);
#define _es_BindAttribLocation _mesa_BindAttribLocationARB

extern void GL_APIENTRY _mesa_BindBufferARB(GLenum target, GLuint buffer);
static void GL_APIENTRY _es_BindBuffer(GLenum target, GLuint buffer)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBindBuffer(target=0x%x)", target);
            return;
    }

    _mesa_BindBufferARB(target, buffer);
}

extern void GL_APIENTRY _mesa_BindFramebufferEXT(GLenum target, GLuint framebuffer);
#define _es_BindFramebuffer _mesa_BindFramebufferEXT

extern void GL_APIENTRY _mesa_BindRenderbufferEXT(GLenum target, GLuint renderbuffer);
#define _es_BindRenderbuffer _mesa_BindRenderbufferEXT

extern void GL_APIENTRY _mesa_BindTexture(GLenum target, GLuint texture);
static void GL_APIENTRY _es_BindTexture(GLenum target, GLuint texture)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP:
        case GL_TEXTURE_3D_OES:
        case GL_TEXTURE_EXTERNAL_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBindTexture(target=0x%x)", target);
            return;
    }

    _mesa_BindTexture(target, texture);
}

extern void GL_APIENTRY _mesa_BlendColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
#define _es_BlendColor _mesa_BlendColor

extern void GL_APIENTRY _mesa_BlendEquation(GLenum mode);
static void GL_APIENTRY _es_BlendEquation(GLenum mode)
{
    switch(mode) {
        case GL_FUNC_ADD:
        case GL_FUNC_SUBTRACT:
        case GL_FUNC_REVERSE_SUBTRACT:
        case GL_MIN_EXT:
        case GL_MAX_EXT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendEquation(mode=0x%x)", mode);
            return;
    }

    _mesa_BlendEquation(mode);
}

extern void GL_APIENTRY _mesa_BlendEquationSeparateEXT(GLenum modeRGB, GLenum modeAlpha);
static void GL_APIENTRY _es_BlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha)
{
    switch(modeRGB) {
        case GL_FUNC_ADD:
        case GL_FUNC_SUBTRACT:
        case GL_FUNC_REVERSE_SUBTRACT:
        case GL_MIN_EXT:
        case GL_MAX_EXT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendEquationSeparate(modeRGB=0x%x)", modeRGB);
            return;
    }
    switch(modeAlpha) {
        case GL_FUNC_ADD:
        case GL_FUNC_SUBTRACT:
        case GL_FUNC_REVERSE_SUBTRACT:
        case GL_MIN_EXT:
        case GL_MAX_EXT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendEquationSeparate(modeAlpha=0x%x)", modeAlpha);
            return;
    }

    _mesa_BlendEquationSeparateEXT(modeRGB, modeAlpha);
}

extern void GL_APIENTRY _mesa_BlendFunc(GLenum sfactor, GLenum dfactor);
static void GL_APIENTRY _es_BlendFunc(GLenum sfactor, GLenum dfactor)
{
    switch(sfactor) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_ALPHA:
        case GL_DST_COLOR:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_SRC_ALPHA_SATURATE:
        case GL_CONSTANT_COLOR:
        case GL_CONSTANT_ALPHA:
        case GL_ONE_MINUS_CONSTANT_COLOR:
        case GL_ONE_MINUS_CONSTANT_ALPHA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFunc(sfactor=0x%x)", sfactor);
            return;
    }
    switch(dfactor) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_ALPHA:
        case GL_DST_COLOR:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_CONSTANT_COLOR:
        case GL_CONSTANT_ALPHA:
        case GL_ONE_MINUS_CONSTANT_COLOR:
        case GL_ONE_MINUS_CONSTANT_ALPHA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFunc(dfactor=0x%x)", dfactor);
            return;
    }

    _mesa_BlendFunc(sfactor, dfactor);
}

extern void GL_APIENTRY _mesa_BlendFuncSeparateEXT(GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);
static void GL_APIENTRY _es_BlendFuncSeparate(GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)
{
    switch(srcRGB) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_ALPHA:
        case GL_DST_COLOR:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_SRC_ALPHA_SATURATE:
        case GL_CONSTANT_COLOR:
        case GL_ONE_MINUS_CONSTANT_COLOR:
        case GL_CONSTANT_ALPHA:
        case GL_ONE_MINUS_CONSTANT_ALPHA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFuncSeparate(srcRGB=0x%x)", srcRGB);
            return;
    }
    switch(dstRGB) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_ALPHA:
        case GL_DST_COLOR:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_CONSTANT_COLOR:
        case GL_ONE_MINUS_CONSTANT_COLOR:
        case GL_CONSTANT_ALPHA:
        case GL_ONE_MINUS_CONSTANT_ALPHA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFuncSeparate(dstRGB=0x%x)", dstRGB);
            return;
    }
    switch(srcAlpha) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_ALPHA:
        case GL_DST_COLOR:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_SRC_ALPHA_SATURATE:
        case GL_CONSTANT_COLOR:
        case GL_ONE_MINUS_CONSTANT_COLOR:
        case GL_CONSTANT_ALPHA:
        case GL_ONE_MINUS_CONSTANT_ALPHA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFuncSeparate(srcAlpha=0x%x)", srcAlpha);
            return;
    }
    switch(dstAlpha) {
        case GL_ZERO:
        case GL_ONE:
        case GL_SRC_COLOR:
        case GL_ONE_MINUS_SRC_COLOR:
        case GL_SRC_ALPHA:
        case GL_ONE_MINUS_SRC_ALPHA:
        case GL_DST_ALPHA:
        case GL_ONE_MINUS_DST_ALPHA:
        case GL_DST_COLOR:
        case GL_ONE_MINUS_DST_COLOR:
        case GL_CONSTANT_COLOR:
        case GL_ONE_MINUS_CONSTANT_COLOR:
        case GL_CONSTANT_ALPHA:
        case GL_ONE_MINUS_CONSTANT_ALPHA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBlendFuncSeparate(dstAlpha=0x%x)", dstAlpha);
            return;
    }

    _mesa_BlendFuncSeparateEXT(srcRGB, dstRGB, srcAlpha, dstAlpha);
}

extern void GL_APIENTRY _mesa_BufferDataARB(GLenum target, GLsizeiptr size, const GLvoid * data, GLenum usage);
static void GL_APIENTRY _es_BufferData(GLenum target, GLsizeiptr size, const GLvoid *data, GLenum usage)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBufferData(target=0x%x)", target);
            return;
    }
    switch(usage) {
        case GL_STATIC_DRAW:
        case GL_DYNAMIC_DRAW:
        case GL_STREAM_DRAW:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBufferData(usage=0x%x)", usage);
            return;
    }

    _mesa_BufferDataARB(target, size, data, usage);
}

extern void GL_APIENTRY _mesa_BufferSubDataARB(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid * data);
static void GL_APIENTRY _es_BufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid *data)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glBufferSubData(target=0x%x)", target);
            return;
    }

    _mesa_BufferSubDataARB(target, offset, size, data);
}

extern GLenum GL_APIENTRY _mesa_CheckFramebufferStatusEXT(GLenum target);
#define _es_CheckFramebufferStatus _mesa_CheckFramebufferStatusEXT

extern void GL_APIENTRY _mesa_Clear(GLbitfield mask);
static void GL_APIENTRY _es_Clear(GLbitfield mask)
{
    switch(mask) {
        case 0:
        case (GL_COLOR_BUFFER_BIT):
        case (GL_DEPTH_BUFFER_BIT):
        case (GL_STENCIL_BUFFER_BIT):
        case (GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT):
        case (GL_COLOR_BUFFER_BIT|GL_STENCIL_BUFFER_BIT):
        case (GL_DEPTH_BUFFER_BIT|GL_STENCIL_BUFFER_BIT):
        case (GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT|GL_STENCIL_BUFFER_BIT):
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glClear(mask=0x%x)", mask);
            return;
    }

    _mesa_Clear(mask);
}

extern void GL_APIENTRY _mesa_ClearColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
#define _es_ClearColor _mesa_ClearColor

extern void GL_APIENTRY _mesa_ClearDepthf(GLclampf depth);
#define _es_ClearDepthf _mesa_ClearDepthf

extern void GL_APIENTRY _mesa_ClearStencil(GLint s);
#define _es_ClearStencil _mesa_ClearStencil

extern void GL_APIENTRY _mesa_ColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
#define _es_ColorMask _mesa_ColorMask

extern void GL_APIENTRY _mesa_CompileShaderARB(GLuint shader);
#define _es_CompileShader _mesa_CompileShaderARB

extern void GL_APIENTRY _mesa_CompressedTexImage2DARB(GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid * data);
static void GL_APIENTRY _es_CompressedTexImage2D(GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCompressedTexImage2D(target=0x%x)", target);
            return;
    }
    switch(internalFormat) {
        case GL_ETC1_RGB8_OES:
        case GL_PALETTE4_RGB8_OES:
        case GL_PALETTE4_RGBA8_OES:
        case GL_PALETTE4_R5_G6_B5_OES:
        case GL_PALETTE4_RGBA4_OES:
        case GL_PALETTE4_RGB5_A1_OES:
        case GL_PALETTE8_RGB8_OES:
        case GL_PALETTE8_RGBA8_OES:
        case GL_PALETTE8_R5_G6_B5_OES:
        case GL_PALETTE8_RGBA4_OES:
        case GL_PALETTE8_RGB5_A1_OES:
        case GL_COMPRESSED_RGB_S3TC_DXT1_EXT:
        case GL_COMPRESSED_RGBA_S3TC_DXT1_EXT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCompressedTexImage2D(internalFormat=0x%x)", internalFormat);
            return;
    }
    switch(border) {
        case 0:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glCompressedTexImage2D(border=%d)", border);
            return;
    }

    _mesa_CompressedTexImage2DARB(target, level, internalFormat, width, height, border, imageSize, data);
}

extern void GL_APIENTRY _mesa_CompressedTexImage3DARB(GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imagesize, const GLvoid * data);
static void GL_APIENTRY _es_CompressedTexImage3DOES(GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imagesize, const GLvoid *data)
{
    switch(target) {
        case GL_TEXTURE_3D_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCompressedTexImage3DOES(target=0x%x)", target);
            return;
    }

    _mesa_CompressedTexImage3DARB(target, level, internalFormat, width, height, depth, border, imagesize, data);
}

extern void GL_APIENTRY _mesa_CompressedTexSubImage2DARB(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid * data);
static void GL_APIENTRY _es_CompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCompressedTexSubImage2D(target=0x%x)", target);
            return;
    }
    switch(format) {
        case GL_COMPRESSED_RGB_S3TC_DXT1_EXT:
        case GL_COMPRESSED_RGBA_S3TC_DXT1_EXT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCompressedTexSubImage2D(format=0x%x)", format);
            return;
    }

    _mesa_CompressedTexSubImage2DARB(target, level, xoffset, yoffset, width, height, format, imageSize, data);
}

extern void GL_APIENTRY _mesa_CompressedTexSubImage3DARB(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imagesize, const GLvoid * data);
static void GL_APIENTRY _es_CompressedTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imagesize, const GLvoid *data)
{
    switch(target) {
        case GL_TEXTURE_3D_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCompressedTexSubImage3DOES(target=0x%x)", target);
            return;
    }

    _mesa_CompressedTexSubImage3DARB(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imagesize, data);
}

extern void GL_APIENTRY _mesa_CopyTexImage2D(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
static void GL_APIENTRY _es_CopyTexImage2D(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCopyTexImage2D(target=0x%x)", target);
            return;
    }
    switch(internalFormat) {
        case GL_ALPHA:
        case GL_RGB:
        case GL_RGBA:
        case GL_LUMINANCE:
        case GL_LUMINANCE_ALPHA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glCopyTexImage2D(internalFormat=0x%x)", internalFormat);
            return;
    }

    _mesa_CopyTexImage2D(target, level, internalFormat, x, y, width, height, border);
}

extern void GL_APIENTRY _mesa_CopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
static void GL_APIENTRY _es_CopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCopyTexSubImage2D(target=0x%x)", target);
            return;
    }

    _mesa_CopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
}

extern void GL_APIENTRY _mesa_CopyTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
static void GL_APIENTRY _es_CopyTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
    switch(target) {
        case GL_TEXTURE_3D_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCopyTexSubImage3DOES(target=0x%x)", target);
            return;
    }

    _mesa_CopyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height);
}

extern GLuint GL_APIENTRY _mesa_CreateProgram(void);
#define _es_CreateProgram _mesa_CreateProgram

extern GLuint GL_APIENTRY _mesa_CreateShader(GLenum type);
static GLuint GL_APIENTRY _es_CreateShader(GLenum type)
{
    switch(type) {
        case GL_VERTEX_SHADER:
        case GL_FRAGMENT_SHADER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCreateShader(type=0x%x)", type);
            return (GLuint) 0;
    }

    return _mesa_CreateShader(type);
}

extern void GL_APIENTRY _mesa_CullFace(GLenum mode);
static void GL_APIENTRY _es_CullFace(GLenum mode)
{
    switch(mode) {
        case GL_FRONT:
        case GL_BACK:
        case GL_FRONT_AND_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glCullFace(mode=0x%x)", mode);
            return;
    }

    _mesa_CullFace(mode);
}

extern void GL_APIENTRY _mesa_DeleteBuffersARB(GLsizei n, const GLuint * buffer);
#define _es_DeleteBuffers _mesa_DeleteBuffersARB

extern void GL_APIENTRY _mesa_DeleteFramebuffersEXT(GLsizei n, const GLuint * framebuffers);
#define _es_DeleteFramebuffers _mesa_DeleteFramebuffersEXT

extern void GL_APIENTRY _mesa_DeleteProgram(GLuint program);
#define _es_DeleteProgram _mesa_DeleteProgram

extern void GL_APIENTRY _mesa_DeleteRenderbuffersEXT(GLsizei n, const GLuint * renderbuffers);
#define _es_DeleteRenderbuffers _mesa_DeleteRenderbuffersEXT

extern void GL_APIENTRY _mesa_DeleteShader(GLuint shader);
#define _es_DeleteShader _mesa_DeleteShader

extern void GL_APIENTRY _mesa_DeleteTextures(GLsizei n, const GLuint * textures);
#define _es_DeleteTextures _mesa_DeleteTextures

extern void GL_APIENTRY _mesa_DepthFunc(GLenum func);
static void GL_APIENTRY _es_DepthFunc(GLenum func)
{
    switch(func) {
        case GL_NEVER:
        case GL_LESS:
        case GL_EQUAL:
        case GL_LEQUAL:
        case GL_GREATER:
        case GL_NOTEQUAL:
        case GL_GEQUAL:
        case GL_ALWAYS:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glDepthFunc(func=0x%x)", func);
            return;
    }

    _mesa_DepthFunc(func);
}

extern void GL_APIENTRY _mesa_DepthMask(GLboolean flag);
#define _es_DepthMask _mesa_DepthMask

extern void GL_APIENTRY _mesa_DepthRangef(GLclampf zNear, GLclampf zFar);
#define _es_DepthRangef _mesa_DepthRangef

extern void GL_APIENTRY _mesa_DetachShader(GLuint program, GLuint shader);
#define _es_DetachShader _mesa_DetachShader

extern void GL_APIENTRY _mesa_Disable(GLenum cap);
static void GL_APIENTRY _es_Disable(GLenum cap)
{
    switch(cap) {
        case GL_CULL_FACE:
        case GL_SCISSOR_TEST:
        case GL_POLYGON_OFFSET_FILL:
        case GL_SAMPLE_ALPHA_TO_COVERAGE:
        case GL_SAMPLE_COVERAGE:
        case GL_STENCIL_TEST:
        case GL_DEPTH_TEST:
        case GL_DITHER:
        case GL_BLEND:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glDisable(cap=0x%x)", cap);
            return;
    }

    _mesa_Disable(cap);
}

extern void GL_APIENTRY _mesa_DisableVertexAttribArrayARB(GLuint index);
#define _es_DisableVertexAttribArray _mesa_DisableVertexAttribArrayARB

extern void GL_APIENTRY _mesa_DrawArrays(GLenum mode, GLint first, GLsizei count);
static void GL_APIENTRY _es_DrawArrays(GLenum mode, GLint first, GLsizei count)
{
    switch(mode) {
        case GL_POINTS:
        case GL_LINES:
        case GL_LINE_LOOP:
        case GL_LINE_STRIP:
        case GL_TRIANGLES:
        case GL_TRIANGLE_STRIP:
        case GL_TRIANGLE_FAN:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glDrawArrays(mode=0x%x)", mode);
            return;
    }

    _mesa_DrawArrays(mode, first, count);
}

extern void GL_APIENTRY _mesa_DrawBuffersARB(GLsizei n, const GLenum * bufs);
#define _es_DrawBuffersNV _mesa_DrawBuffersARB

extern void GL_APIENTRY _mesa_DrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices);
static void GL_APIENTRY _es_DrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices)
{
    switch(mode) {
        case GL_POINTS:
        case GL_LINES:
        case GL_LINE_LOOP:
        case GL_LINE_STRIP:
        case GL_TRIANGLES:
        case GL_TRIANGLE_STRIP:
        case GL_TRIANGLE_FAN:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glDrawElements(mode=0x%x)", mode);
            return;
    }
    switch(type) {
        case GL_UNSIGNED_BYTE:
        case GL_UNSIGNED_SHORT:
        case GL_UNSIGNED_INT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glDrawElements(type=0x%x)", type);
            return;
    }

    _mesa_DrawElements(mode, count, type, indices);
}

extern void GL_APIENTRY _mesa_EGLImageTargetRenderbufferStorageOES(GLenum target, GLeglImageOES image);
#define _es_EGLImageTargetRenderbufferStorageOES _mesa_EGLImageTargetRenderbufferStorageOES

extern void GL_APIENTRY _mesa_EGLImageTargetTexture2DOES(GLenum target, GLeglImageOES image);
static void GL_APIENTRY _es_EGLImageTargetTexture2DOES(GLenum target, GLeglImageOES image)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_EXTERNAL_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glEGLImageTargetTexture2DOES(target=0x%x)", target);
            return;
    }

    _mesa_EGLImageTargetTexture2DOES(target, image);
}

extern void GL_APIENTRY _mesa_Enable(GLenum cap);
static void GL_APIENTRY _es_Enable(GLenum cap)
{
    switch(cap) {
        case GL_CULL_FACE:
        case GL_SCISSOR_TEST:
        case GL_POLYGON_OFFSET_FILL:
        case GL_SAMPLE_ALPHA_TO_COVERAGE:
        case GL_SAMPLE_COVERAGE:
        case GL_STENCIL_TEST:
        case GL_DEPTH_TEST:
        case GL_DITHER:
        case GL_BLEND:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glEnable(cap=0x%x)", cap);
            return;
    }

    _mesa_Enable(cap);
}

extern void GL_APIENTRY _mesa_EnableVertexAttribArrayARB(GLuint index);
#define _es_EnableVertexAttribArray _mesa_EnableVertexAttribArrayARB

extern void GL_APIENTRY _mesa_Finish(void);
#define _es_Finish _mesa_Finish

extern void GL_APIENTRY _mesa_Flush(void);
#define _es_Flush _mesa_Flush

extern void GL_APIENTRY _mesa_FramebufferRenderbufferEXT(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
#define _es_FramebufferRenderbuffer _mesa_FramebufferRenderbufferEXT

extern void GL_APIENTRY _mesa_FramebufferTexture2DEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
static void GL_APIENTRY _es_FramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
    switch(textarget) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glFramebufferTexture2D(textarget=0x%x)", textarget);
            return;
    }

    _mesa_FramebufferTexture2DEXT(target, attachment, textarget, texture, level);
}

extern void GL_APIENTRY _mesa_FramebufferTexture3DEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
static void GL_APIENTRY _es_FramebufferTexture3DOES(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)
{
    switch(textarget) {
        case GL_TEXTURE_3D_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glFramebufferTexture3DOES(textarget=0x%x)", textarget);
            return;
    }

    _mesa_FramebufferTexture3DEXT(target, attachment, textarget, texture, level, zoffset);
}

extern void GL_APIENTRY _mesa_FrontFace(GLenum mode);
static void GL_APIENTRY _es_FrontFace(GLenum mode)
{
    switch(mode) {
        case GL_CW:
        case GL_CCW:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glFrontFace(mode=0x%x)", mode);
            return;
    }

    _mesa_FrontFace(mode);
}

extern void GL_APIENTRY _mesa_GenBuffersARB(GLsizei n, GLuint * buffer);
#define _es_GenBuffers _mesa_GenBuffersARB

extern void GL_APIENTRY _mesa_GenFramebuffersEXT(GLsizei n, GLuint * ids);
#define _es_GenFramebuffers _mesa_GenFramebuffersEXT

extern void GL_APIENTRY _mesa_GenRenderbuffersEXT(GLsizei n, GLuint * renderbuffers);
#define _es_GenRenderbuffers _mesa_GenRenderbuffersEXT

extern void GL_APIENTRY _mesa_GenTextures(GLsizei n, GLuint * textures);
#define _es_GenTextures _mesa_GenTextures

extern void GL_APIENTRY _mesa_GenerateMipmapEXT(GLenum target);
static void GL_APIENTRY _es_GenerateMipmap(GLenum target)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP:
        case GL_TEXTURE_3D_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGenerateMipmap(target=0x%x)", target);
            return;
    }

    _mesa_GenerateMipmapEXT(target);
}

extern void GL_APIENTRY _mesa_GetActiveAttribARB(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name);
#define _es_GetActiveAttrib _mesa_GetActiveAttribARB

extern void GL_APIENTRY _mesa_GetActiveUniformARB(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLint * size, GLenum * type, GLchar * name);
#define _es_GetActiveUniform _mesa_GetActiveUniformARB

extern void GL_APIENTRY _mesa_GetAttachedShaders(GLuint program, GLsizei maxCount, GLsizei * count, GLuint * shaders);
#define _es_GetAttachedShaders _mesa_GetAttachedShaders

extern GLint GL_APIENTRY _mesa_GetAttribLocationARB(GLuint program, const char * name);
#define _es_GetAttribLocation _mesa_GetAttribLocationARB

extern void GL_APIENTRY _mesa_GetBooleanv(GLenum pname, GLboolean * params);
#define _es_GetBooleanv _mesa_GetBooleanv

extern void GL_APIENTRY _mesa_GetBufferParameterivARB(GLenum target, GLenum pname, GLint * params);
static void GL_APIENTRY _es_GetBufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetBufferParameteriv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_BUFFER_SIZE:
        case GL_BUFFER_USAGE:
        case GL_BUFFER_ACCESS_OES:
        case GL_BUFFER_MAPPED_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetBufferParameteriv(pname=0x%x)", pname);
            return;
    }

    _mesa_GetBufferParameterivARB(target, pname, params);
}

extern void GL_APIENTRY _mesa_GetBufferPointervARB(GLenum target, GLenum pname, GLvoid ** params);
static void GL_APIENTRY _es_GetBufferPointervOES(GLenum target, GLenum pname, GLvoid **params)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetBufferPointervOES(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_BUFFER_MAP_POINTER_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetBufferPointervOES(pname=0x%x)", pname);
            return;
    }

    _mesa_GetBufferPointervARB(target, pname, params);
}

extern GLenum GL_APIENTRY _mesa_GetError(void);
#define _es_GetError _mesa_GetError

extern void GL_APIENTRY _mesa_GetFloatv(GLenum pname, GLfloat * params);
#define _es_GetFloatv _mesa_GetFloatv

extern void GL_APIENTRY _mesa_GetFramebufferAttachmentParameterivEXT(GLenum target, GLenum attachment, GLenum pname, GLint * params);
static void GL_APIENTRY _es_GetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint *params)
{
    switch(pname) {
        case GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: /* size 1 */
        case GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: /* size 1 */
        case GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: /* size 1 */
        case GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: /* size 1 */
        case GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_OES: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetFramebufferAttachmentParameteriv(pname=0x%x)", pname);
            return;
    }

    _mesa_GetFramebufferAttachmentParameterivEXT(target, attachment, pname, params);
}

extern void GL_APIENTRY _mesa_GetIntegerv(GLenum pname, GLint * params);
#define _es_GetIntegerv _mesa_GetIntegerv

extern void GL_APIENTRY _mesa_GetProgramInfoLog(GLuint program, GLsizei bufSize, GLsizei * length, GLchar * infoLog);
#define _es_GetProgramInfoLog _mesa_GetProgramInfoLog

extern void GL_APIENTRY _mesa_GetProgramiv(GLuint program, GLenum pname, GLint * params);
static void GL_APIENTRY _es_GetProgramiv(GLuint program, GLenum pname, GLint *params)
{
    switch(pname) {
        case GL_DELETE_STATUS:
        case GL_LINK_STATUS:
        case GL_VALIDATE_STATUS:
        case GL_INFO_LOG_LENGTH:
        case GL_ATTACHED_SHADERS:
        case GL_ACTIVE_ATTRIBUTES:
        case GL_ACTIVE_ATTRIBUTE_MAX_LENGTH:
        case GL_ACTIVE_UNIFORMS:
        case GL_ACTIVE_UNIFORM_MAX_LENGTH:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetProgramiv(pname=0x%x)", pname);
            return;
    }

    _mesa_GetProgramiv(program, pname, params);
}

extern void GL_APIENTRY _mesa_GetRenderbufferParameterivEXT(GLenum target, GLenum pname, GLint * params);
static void GL_APIENTRY _es_GetRenderbufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    switch(pname) {
        case GL_RENDERBUFFER_WIDTH: /* size 1 */
        case GL_RENDERBUFFER_HEIGHT: /* size 1 */
        case GL_RENDERBUFFER_INTERNAL_FORMAT: /* size 1 */
        case GL_RENDERBUFFER_RED_SIZE: /* size 1 */
        case GL_RENDERBUFFER_GREEN_SIZE: /* size 1 */
        case GL_RENDERBUFFER_BLUE_SIZE: /* size 1 */
        case GL_RENDERBUFFER_ALPHA_SIZE: /* size 1 */
        case GL_RENDERBUFFER_DEPTH_SIZE: /* size 1 */
        case GL_RENDERBUFFER_STENCIL_SIZE: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetRenderbufferParameteriv(pname=0x%x)", pname);
            return;
    }

    _mesa_GetRenderbufferParameterivEXT(target, pname, params);
}

extern void GL_APIENTRY _mesa_GetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * infoLog);
#define _es_GetShaderInfoLog _mesa_GetShaderInfoLog

extern void GL_APIENTRY _mesa_GetShaderPrecisionFormat(GLenum shadertype, GLenum precisiontype, GLint * range, GLint * precision);
static void GL_APIENTRY _es_GetShaderPrecisionFormat(GLenum shadertype, GLenum precisiontype, GLint *range, GLint *precision)
{
    switch(shadertype) {
        case GL_VERTEX_SHADER:
        case GL_FRAGMENT_SHADER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetShaderPrecisionFormat(shadertype=0x%x)", shadertype);
            return;
    }
    switch(precisiontype) {
        case GL_LOW_FLOAT:
        case GL_MEDIUM_FLOAT:
        case GL_HIGH_FLOAT:
        case GL_LOW_INT:
        case GL_MEDIUM_INT:
        case GL_HIGH_INT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetShaderPrecisionFormat(precisiontype=0x%x)", precisiontype);
            return;
    }

    _mesa_GetShaderPrecisionFormat(shadertype, precisiontype, range, precision);
}

extern void GL_APIENTRY _mesa_GetShaderSourceARB(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * source);
#define _es_GetShaderSource _mesa_GetShaderSourceARB

extern void GL_APIENTRY _mesa_GetShaderiv(GLuint shader, GLenum pname, GLint * params);
static void GL_APIENTRY _es_GetShaderiv(GLuint shader, GLenum pname, GLint *params)
{
    switch(pname) {
        case GL_SHADER_TYPE:
        case GL_COMPILE_STATUS:
        case GL_DELETE_STATUS:
        case GL_INFO_LOG_LENGTH:
        case GL_SHADER_SOURCE_LENGTH:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetShaderiv(pname=0x%x)", pname);
            return;
    }

    _mesa_GetShaderiv(shader, pname, params);
}

extern const GLubyte * GL_APIENTRY _mesa_GetString(GLenum name);
static const GLubyte * GL_APIENTRY _es_GetString(GLenum name)
{
    switch(name) {
        case GL_VENDOR:
        case GL_RENDERER:
        case GL_VERSION:
        case GL_EXTENSIONS:
        case GL_SHADING_LANGUAGE_VERSION:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetString(name=0x%x)", name);
            return (const GLubyte *) 0;
    }

    return _mesa_GetString(name);
}

extern void GL_APIENTRY _mesa_GetTexParameterfv(GLenum target, GLenum pname, GLfloat * params);
static void GL_APIENTRY _es_GetTexParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP:
        case GL_TEXTURE_3D_OES:
        case GL_TEXTURE_EXTERNAL_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexParameterfv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S: /* size 1 */
        case GL_TEXTURE_WRAP_T: /* size 1 */
        case GL_TEXTURE_WRAP_R_OES: /* size 1 */
        case GL_TEXTURE_MIN_FILTER: /* size 1 */
        case GL_TEXTURE_MAG_FILTER: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexParameterfv(pname=0x%x)", pname);
            return;
    }

    _mesa_GetTexParameterfv(target, pname, params);
}

extern void GL_APIENTRY _mesa_GetTexParameteriv(GLenum target, GLenum pname, GLint * params);
static void GL_APIENTRY _es_GetTexParameteriv(GLenum target, GLenum pname, GLint *params)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP:
        case GL_TEXTURE_3D_OES:
        case GL_TEXTURE_EXTERNAL_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexParameteriv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S: /* size 1 */
        case GL_TEXTURE_WRAP_T: /* size 1 */
        case GL_TEXTURE_WRAP_R_OES: /* size 1 */
        case GL_TEXTURE_MIN_FILTER: /* size 1 */
        case GL_TEXTURE_MAG_FILTER: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetTexParameteriv(pname=0x%x)", pname);
            return;
    }

    _mesa_GetTexParameteriv(target, pname, params);
}

extern GLint GL_APIENTRY _mesa_GetUniformLocationARB(GLuint program, const char * name);
#define _es_GetUniformLocation _mesa_GetUniformLocationARB

extern void GL_APIENTRY _mesa_GetUniformfvARB(GLuint program, GLint location, GLfloat * params);
#define _es_GetUniformfv _mesa_GetUniformfvARB

extern void GL_APIENTRY _mesa_GetUniformivARB(GLuint program, GLint location, GLint * params);
#define _es_GetUniformiv _mesa_GetUniformivARB

extern void GL_APIENTRY _mesa_GetVertexAttribPointervARB(GLuint index, GLenum pname, GLvoid ** pointer);
static void GL_APIENTRY _es_GetVertexAttribPointerv(GLuint index, GLenum pname, GLvoid **pointer)
{
    switch(pname) {
        case GL_VERTEX_ATTRIB_ARRAY_POINTER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetVertexAttribPointerv(pname=0x%x)", pname);
            return;
    }

    _mesa_GetVertexAttribPointervARB(index, pname, pointer);
}

extern void GL_APIENTRY _mesa_GetVertexAttribfvARB(GLuint index, GLenum pname, GLfloat * params);
static void GL_APIENTRY _es_GetVertexAttribfv(GLuint index, GLenum pname, GLfloat *params)
{
    switch(pname) {
        case GL_VERTEX_ATTRIB_ARRAY_ENABLED: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_SIZE: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_STRIDE: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_TYPE: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_NORMALIZED: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: /* size 1 */
        case GL_CURRENT_VERTEX_ATTRIB: /* size 16? */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetVertexAttribfv(pname=0x%x)", pname);
            return;
    }

    _mesa_GetVertexAttribfvARB(index, pname, params);
}

extern void GL_APIENTRY _mesa_GetVertexAttribivARB(GLuint index, GLenum pname, GLint * params);
static void GL_APIENTRY _es_GetVertexAttribiv(GLuint index, GLenum pname, GLint *params)
{
    switch(pname) {
        case GL_VERTEX_ATTRIB_ARRAY_ENABLED: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_SIZE: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_STRIDE: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_TYPE: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_NORMALIZED: /* size 1 */
        case GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: /* size 1 */
        case GL_CURRENT_VERTEX_ATTRIB: /* size 16? */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glGetVertexAttribiv(pname=0x%x)", pname);
            return;
    }

    _mesa_GetVertexAttribivARB(index, pname, params);
}

extern void GL_APIENTRY _mesa_Hint(GLenum target, GLenum mode);
static void GL_APIENTRY _es_Hint(GLenum target, GLenum mode)
{
    switch(target) {
        case GL_FRAGMENT_SHADER_DERIVATIVE_HINT_OES:
        case GL_GENERATE_MIPMAP_HINT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glHint(target=0x%x)", target);
            return;
    }
    switch(mode) {
        case GL_FASTEST:
        case GL_NICEST:
        case GL_DONT_CARE:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glHint(mode=0x%x)", mode);
            return;
    }

    _mesa_Hint(target, mode);
}

extern GLboolean GL_APIENTRY _mesa_IsBufferARB(GLuint buffer);
#define _es_IsBuffer _mesa_IsBufferARB

extern GLboolean GL_APIENTRY _mesa_IsEnabled(GLenum cap);
static GLboolean GL_APIENTRY _es_IsEnabled(GLenum cap)
{
    switch(cap) {
        case GL_CULL_FACE:
        case GL_SCISSOR_TEST:
        case GL_POLYGON_OFFSET_FILL:
        case GL_SAMPLE_ALPHA_TO_COVERAGE:
        case GL_SAMPLE_COVERAGE:
        case GL_STENCIL_TEST:
        case GL_DEPTH_TEST:
        case GL_DITHER:
        case GL_BLEND:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glIsEnabled(cap=0x%x)", cap);
            return GL_FALSE;
    }

    return _mesa_IsEnabled(cap);
}

extern GLboolean GL_APIENTRY _mesa_IsFramebufferEXT(GLuint framebuffer);
#define _es_IsFramebuffer _mesa_IsFramebufferEXT

extern GLboolean GL_APIENTRY _mesa_IsProgram(GLuint program);
#define _es_IsProgram _mesa_IsProgram

extern GLboolean GL_APIENTRY _mesa_IsRenderbufferEXT(GLuint renderbuffer);
#define _es_IsRenderbuffer _mesa_IsRenderbufferEXT

extern GLboolean GL_APIENTRY _mesa_IsShader(GLuint shader);
#define _es_IsShader _mesa_IsShader

extern GLboolean GL_APIENTRY _mesa_IsTexture(GLuint texture);
#define _es_IsTexture _mesa_IsTexture

extern void GL_APIENTRY _mesa_LineWidth(GLfloat width);
#define _es_LineWidth _mesa_LineWidth

extern void GL_APIENTRY _mesa_LinkProgramARB(GLuint program);
#define _es_LinkProgram _mesa_LinkProgramARB

extern void * GL_APIENTRY _mesa_MapBufferARB(GLenum target, GLenum access);
static void * GL_APIENTRY _es_MapBufferOES(GLenum target, GLenum access)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMapBufferOES(target=0x%x)", target);
            return (void *) 0;
    }
    switch(access) {
        case GL_WRITE_ONLY_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMapBufferOES(access=0x%x)", access);
            return (void *) 0;
    }

    return _mesa_MapBufferARB(target, access);
}

extern void GL_APIENTRY _mesa_MultiDrawArraysEXT(GLenum mode, const GLint * first, const GLsizei * count, GLsizei primcount);
static void GL_APIENTRY _es_MultiDrawArraysEXT(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount)
{
    switch(mode) {
        case GL_POINTS:
        case GL_LINES:
        case GL_LINE_LOOP:
        case GL_LINE_STRIP:
        case GL_TRIANGLES:
        case GL_TRIANGLE_STRIP:
        case GL_TRIANGLE_FAN:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMultiDrawArraysEXT(mode=0x%x)", mode);
            return;
    }

    _mesa_MultiDrawArraysEXT(mode, first, count, primcount);
}

extern void GL_APIENTRY _mesa_MultiDrawElementsEXT(GLenum mode, const GLsizei * count, GLenum type, const GLvoid ** indices, GLsizei primcount);
static void GL_APIENTRY _es_MultiDrawElementsEXT(GLenum mode, const GLsizei *count, GLenum type, const GLvoid **indices, GLsizei primcount)
{
    switch(mode) {
        case GL_POINTS:
        case GL_LINES:
        case GL_LINE_LOOP:
        case GL_LINE_STRIP:
        case GL_TRIANGLES:
        case GL_TRIANGLE_STRIP:
        case GL_TRIANGLE_FAN:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMultiDrawElementsEXT(mode=0x%x)", mode);
            return;
    }
    switch(type) {
        case GL_UNSIGNED_BYTE:
        case GL_UNSIGNED_SHORT:
        case GL_UNSIGNED_INT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glMultiDrawElementsEXT(type=0x%x)", type);
            return;
    }

    _mesa_MultiDrawElementsEXT(mode, count, type, indices, primcount);
}

extern void GL_APIENTRY _mesa_PixelStorei(GLenum pname, GLint param);
static void GL_APIENTRY _es_PixelStorei(GLenum pname, GLint param)
{
    switch(pname) {
        case GL_PACK_ALIGNMENT:
        case GL_UNPACK_ALIGNMENT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glPixelStorei(pname=0x%x)", pname);
            return;
    }
    switch(param) {
        case 1:
        case 2:
        case 4:
        case 8:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glPixelStorei(param=%d)", param);
            return;
    }

    _mesa_PixelStorei(pname, param);
}

extern void GL_APIENTRY _mesa_PolygonOffset(GLfloat factor, GLfloat units);
#define _es_PolygonOffset _mesa_PolygonOffset

extern void GL_APIENTRY _mesa_ReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid * pixels);
static void GL_APIENTRY _es_ReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels)
{
    switch(format) {
        case GL_ALPHA:
            if (type != GL_UNSIGNED_BYTE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glReadPixels(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGB:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_5_6_5) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glReadPixels(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGBA:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_4_4_4_4 && type != GL_UNSIGNED_SHORT_5_5_5_1) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glReadPixels(format=0x%x)", format);
                return;
            }
            break;
        case GL_LUMINANCE:
        case GL_LUMINANCE_ALPHA:
            if (type != GL_UNSIGNED_BYTE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glReadPixels(format=0x%x)", format);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glReadPixels(format=0x%x)", format);
            return;
    }

    _mesa_ReadPixels(x, y, width, height, format, type, pixels);
}

extern void GL_APIENTRY _mesa_ReleaseShaderCompiler(void);
#define _es_ReleaseShaderCompiler _mesa_ReleaseShaderCompiler

/* this function is special and is defined elsewhere */
extern void GL_APIENTRY _es_RenderbufferStorageEXT(GLenum target, GLenum internalFormat, GLsizei width, GLsizei height);
static void GL_APIENTRY _check_RenderbufferStorage(GLenum target, GLenum internalFormat, GLsizei width, GLsizei height)
{
    switch(internalFormat) {
        case GL_DEPTH_COMPONENT16:
        case GL_RGBA4:
        case GL_RGB5_A1:
        case GL_RGB565:
        case GL_STENCIL_INDEX8:
        case GL_DEPTH_COMPONENT24_OES:
        case GL_DEPTH_COMPONENT32_OES:
        case GL_RGB8_OES:
        case GL_RGBA8_OES:
        case GL_STENCIL_INDEX1_OES:
        case GL_STENCIL_INDEX4_OES:
        case GL_DEPTH24_STENCIL8_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glRenderbufferStorage(internalFormat=0x%x)", internalFormat);
            return;
    }

    _es_RenderbufferStorageEXT(target, internalFormat, width, height);
}

extern void GL_APIENTRY _mesa_SampleCoverageARB(GLclampf value, GLboolean invert);
#define _es_SampleCoverage _mesa_SampleCoverageARB

extern void GL_APIENTRY _mesa_Scissor(GLint x, GLint y, GLsizei width, GLsizei height);
#define _es_Scissor _mesa_Scissor

extern void GL_APIENTRY _mesa_ShaderBinary(GLsizei n, const GLuint * shaders, GLenum binaryformat, const GLvoid * binary, GLsizei length);
#define _es_ShaderBinary _mesa_ShaderBinary

extern void GL_APIENTRY _mesa_ShaderSourceARB(GLuint shader, GLsizei count, const GLchar ** string, const int * length);
#define _es_ShaderSource _mesa_ShaderSourceARB

extern void GL_APIENTRY _mesa_StencilFunc(GLenum func, GLint ref, GLuint mask);
static void GL_APIENTRY _es_StencilFunc(GLenum func, GLint ref, GLuint mask)
{
    switch(func) {
        case GL_NEVER:
        case GL_LESS:
        case GL_LEQUAL:
        case GL_GREATER:
        case GL_GEQUAL:
        case GL_EQUAL:
        case GL_NOTEQUAL:
        case GL_ALWAYS:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilFunc(func=0x%x)", func);
            return;
    }

    _mesa_StencilFunc(func, ref, mask);
}

extern void GL_APIENTRY _mesa_StencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask);
static void GL_APIENTRY _es_StencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask)
{
    switch(face) {
        case GL_FRONT:
        case GL_BACK:
        case GL_FRONT_AND_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilFuncSeparate(face=0x%x)", face);
            return;
    }
    switch(func) {
        case GL_NEVER:
        case GL_LESS:
        case GL_LEQUAL:
        case GL_GREATER:
        case GL_GEQUAL:
        case GL_EQUAL:
        case GL_NOTEQUAL:
        case GL_ALWAYS:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilFuncSeparate(func=0x%x)", func);
            return;
    }

    _mesa_StencilFuncSeparate(face, func, ref, mask);
}

extern void GL_APIENTRY _mesa_StencilMask(GLuint mask);
#define _es_StencilMask _mesa_StencilMask

extern void GL_APIENTRY _mesa_StencilMaskSeparate(GLenum face, GLuint mask);
static void GL_APIENTRY _es_StencilMaskSeparate(GLenum face, GLuint mask)
{
    switch(face) {
        case GL_FRONT:
        case GL_BACK:
        case GL_FRONT_AND_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilMaskSeparate(face=0x%x)", face);
            return;
    }

    _mesa_StencilMaskSeparate(face, mask);
}

extern void GL_APIENTRY _mesa_StencilOp(GLenum fail, GLenum zfail, GLenum zpass);
static void GL_APIENTRY _es_StencilOp(GLenum fail, GLenum zfail, GLenum zpass)
{
    switch(fail) {
        case GL_KEEP:
        case GL_ZERO:
        case GL_REPLACE:
        case GL_INCR:
        case GL_DECR:
        case GL_INVERT:
        case GL_INCR_WRAP:
        case GL_DECR_WRAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilOp(fail=0x%x)", fail);
            return;
    }
    switch(zfail) {
        case GL_KEEP:
        case GL_ZERO:
        case GL_REPLACE:
        case GL_INCR:
        case GL_DECR:
        case GL_INVERT:
        case GL_INCR_WRAP:
        case GL_DECR_WRAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilOp(zfail=0x%x)", zfail);
            return;
    }
    switch(zpass) {
        case GL_KEEP:
        case GL_ZERO:
        case GL_REPLACE:
        case GL_INCR:
        case GL_DECR:
        case GL_INVERT:
        case GL_INCR_WRAP:
        case GL_DECR_WRAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilOp(zpass=0x%x)", zpass);
            return;
    }

    _mesa_StencilOp(fail, zfail, zpass);
}

extern void GL_APIENTRY _mesa_StencilOpSeparate(GLenum face, GLenum fail, GLenum zfail, GLenum zpass);
static void GL_APIENTRY _es_StencilOpSeparate(GLenum face, GLenum fail, GLenum zfail, GLenum zpass)
{
    switch(face) {
        case GL_FRONT:
        case GL_BACK:
        case GL_FRONT_AND_BACK:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilOpSeparate(face=0x%x)", face);
            return;
    }
    switch(fail) {
        case GL_KEEP:
        case GL_ZERO:
        case GL_REPLACE:
        case GL_INCR:
        case GL_DECR:
        case GL_INVERT:
        case GL_INCR_WRAP:
        case GL_DECR_WRAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilOpSeparate(fail=0x%x)", fail);
            return;
    }
    switch(zfail) {
        case GL_KEEP:
        case GL_ZERO:
        case GL_REPLACE:
        case GL_INCR:
        case GL_DECR:
        case GL_INVERT:
        case GL_INCR_WRAP:
        case GL_DECR_WRAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilOpSeparate(zfail=0x%x)", zfail);
            return;
    }
    switch(zpass) {
        case GL_KEEP:
        case GL_ZERO:
        case GL_REPLACE:
        case GL_INCR:
        case GL_DECR:
        case GL_INVERT:
        case GL_INCR_WRAP:
        case GL_DECR_WRAP:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glStencilOpSeparate(zpass=0x%x)", zpass);
            return;
    }

    _mesa_StencilOpSeparate(face, fail, zfail, zpass);
}

extern void GL_APIENTRY _mesa_TexImage2D(GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid * pixels);
static void GL_APIENTRY _es_TexImage2D(GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexImage2D(target=0x%x)", target);
            return;
    }
    switch(internalFormat) {
        case GL_ALPHA:
            if (format != GL_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexImage2D(internalFormat=0x%x)", internalFormat);
                return;
            }
            break;
        case GL_RGB:
            if (format != GL_RGB) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexImage2D(internalFormat=0x%x)", internalFormat);
                return;
            }
            break;
        case GL_RGBA:
            if (format != GL_RGBA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexImage2D(internalFormat=0x%x)", internalFormat);
                return;
            }
            break;
        case GL_LUMINANCE:
            if (format != GL_LUMINANCE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexImage2D(internalFormat=0x%x)", internalFormat);
                return;
            }
            break;
        case GL_LUMINANCE_ALPHA:
            if (format != GL_LUMINANCE_ALPHA) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexImage2D(internalFormat=0x%x)", internalFormat);
                return;
            }
            break;
        case GL_DEPTH_COMPONENT:
            if (format != GL_DEPTH_COMPONENT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexImage2D(internalFormat=0x%x)", internalFormat);
                return;
            }
            break;
        case GL_DEPTH_STENCIL_OES:
            if (format != GL_DEPTH_STENCIL_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexImage2D(internalFormat=0x%x)", internalFormat);
                return;
            }
            break;
        case GL_BGRA_EXT:
            if (format != GL_BGRA_EXT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexImage2D(internalFormat=0x%x)", internalFormat);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glTexImage2D(internalFormat=%d)", internalFormat);
            return;
    }
    switch(format) {
        case GL_ALPHA:
            if (type != GL_UNSIGNED_BYTE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGB:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_5_6_5) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGBA:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_4_4_4_4 && type != GL_UNSIGNED_SHORT_5_5_5_1 && type != GL_UNSIGNED_INT_2_10_10_10_REV_EXT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_LUMINANCE:
        case GL_LUMINANCE_ALPHA:
            if (type != GL_UNSIGNED_BYTE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_DEPTH_COMPONENT:
            if (type != GL_UNSIGNED_SHORT && type != GL_UNSIGNED_INT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_DEPTH_STENCIL_OES:
            if (type != GL_UNSIGNED_INT_24_8_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_BGRA_EXT:
            if (type != GL_UNSIGNED_BYTE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexImage2D(format=0x%x)", format);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexImage2D(format=0x%x)", format);
            return;
    }

    _mesa_TexImage2D(target, level, internalFormat, width, height, border, format, type, pixels);
}

extern void GL_APIENTRY _mesa_TexImage3D(GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid * pixels);
static void GL_APIENTRY _es_TexImage3DOES(GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
    switch(target) {
        case GL_TEXTURE_3D_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexImage3DOES(target=0x%x)", target);
            return;
    }
    switch(internalFormat) {
        case GL_ALPHA:
        case GL_RGB:
        case GL_RGBA:
        case GL_LUMINANCE:
        case GL_LUMINANCE_ALPHA:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexImage3DOES(internalFormat=0x%x)", internalFormat);
            return;
    }
    switch(format) {
        case GL_ALPHA:
            if (type != GL_UNSIGNED_BYTE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexImage3DOES(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGB:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_5_6_5) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexImage3DOES(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGBA:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_4_4_4_4 && type != GL_UNSIGNED_SHORT_5_5_5_1 && type != GL_UNSIGNED_INT_2_10_10_10_REV_EXT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexImage3DOES(format=0x%x)", format);
                return;
            }
            break;
        case GL_LUMINANCE:
        case GL_LUMINANCE_ALPHA:
            if (type != GL_UNSIGNED_BYTE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexImage3DOES(format=0x%x)", format);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexImage3DOES(format=0x%x)", format);
            return;
    }

    _mesa_TexImage3D(target, level, internalFormat, width, height, depth, border, format, type, pixels);
}

extern void GL_APIENTRY _mesa_TexParameterf(GLenum target, GLenum pname, GLfloat param);
static void GL_APIENTRY _es_TexParameterf(GLenum target, GLenum pname, GLfloat param)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP:
        case GL_TEXTURE_3D_OES:
        case GL_TEXTURE_EXTERNAL_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterf(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S:
        case GL_TEXTURE_WRAP_T:
        case GL_TEXTURE_WRAP_R_OES:
            if (param != GL_CLAMP_TO_EDGE && param != GL_REPEAT && param != GL_MIRRORED_REPEAT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MIN_FILTER:
            if (param != GL_NEAREST && param != GL_LINEAR && param != GL_NEAREST_MIPMAP_NEAREST && param != GL_NEAREST_MIPMAP_LINEAR && param != GL_LINEAR_MIPMAP_NEAREST && param != GL_LINEAR_MIPMAP_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAG_FILTER:
            if (param != GL_NEAREST && param != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterf(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAX_ANISOTROPY_EXT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterf(pname=0x%x)", pname);
            return;
    }

    _mesa_TexParameterf(target, pname, param);
}

extern void GL_APIENTRY _mesa_TexParameterfv(GLenum target, GLenum pname, const GLfloat * params);
static void GL_APIENTRY _es_TexParameterfv(GLenum target, GLenum pname, const GLfloat *params)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP:
        case GL_TEXTURE_3D_OES:
        case GL_TEXTURE_EXTERNAL_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterfv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S: /* size 1 */
        case GL_TEXTURE_WRAP_T: /* size 1 */
        case GL_TEXTURE_WRAP_R_OES: /* size 1 */
            if (params[0] != GL_CLAMP_TO_EDGE && params[0] != GL_REPEAT && params[0] != GL_MIRRORED_REPEAT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MIN_FILTER: /* size 1 */
            if (params[0] != GL_NEAREST && params[0] != GL_LINEAR && params[0] != GL_NEAREST_MIPMAP_NEAREST && params[0] != GL_NEAREST_MIPMAP_LINEAR && params[0] != GL_LINEAR_MIPMAP_NEAREST && params[0] != GL_LINEAR_MIPMAP_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAG_FILTER: /* size 1 */
            if (params[0] != GL_NEAREST && params[0] != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterfv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAX_ANISOTROPY_EXT: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameterfv(pname=0x%x)", pname);
            return;
    }

    _mesa_TexParameterfv(target, pname, params);
}

extern void GL_APIENTRY _mesa_TexParameteri(GLenum target, GLenum pname, GLint param);
static void GL_APIENTRY _es_TexParameteri(GLenum target, GLenum pname, GLint param)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP:
        case GL_TEXTURE_3D_OES:
        case GL_TEXTURE_EXTERNAL_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteri(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S:
        case GL_TEXTURE_WRAP_T:
        case GL_TEXTURE_WRAP_R_OES:
            if (param != GL_CLAMP_TO_EDGE && param != GL_REPEAT && param != GL_MIRRORED_REPEAT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteri(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MIN_FILTER:
            if (param != GL_NEAREST && param != GL_LINEAR && param != GL_NEAREST_MIPMAP_NEAREST && param != GL_NEAREST_MIPMAP_LINEAR && param != GL_LINEAR_MIPMAP_NEAREST && param != GL_LINEAR_MIPMAP_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteri(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAG_FILTER:
            if (param != GL_NEAREST && param != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteri(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAX_ANISOTROPY_EXT:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteri(pname=0x%x)", pname);
            return;
    }

    _mesa_TexParameteri(target, pname, param);
}

extern void GL_APIENTRY _mesa_TexParameteriv(GLenum target, GLenum pname, const GLint * params);
static void GL_APIENTRY _es_TexParameteriv(GLenum target, GLenum pname, const GLint *params)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP:
        case GL_TEXTURE_3D_OES:
        case GL_TEXTURE_EXTERNAL_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteriv(target=0x%x)", target);
            return;
    }
    switch(pname) {
        case GL_TEXTURE_WRAP_S: /* size 1 */
        case GL_TEXTURE_WRAP_T: /* size 1 */
        case GL_TEXTURE_WRAP_R_OES: /* size 1 */
            if (params[0] != GL_CLAMP_TO_EDGE && params[0] != GL_REPEAT && params[0] != GL_MIRRORED_REPEAT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteriv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MIN_FILTER: /* size 1 */
            if (params[0] != GL_NEAREST && params[0] != GL_LINEAR && params[0] != GL_NEAREST_MIPMAP_NEAREST && params[0] != GL_NEAREST_MIPMAP_LINEAR && params[0] != GL_LINEAR_MIPMAP_NEAREST && params[0] != GL_LINEAR_MIPMAP_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteriv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAG_FILTER: /* size 1 */
            if (params[0] != GL_NEAREST && params[0] != GL_LINEAR) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteriv(pname=0x%x)", pname);
                return;
            }
            break;
        case GL_TEXTURE_MAX_ANISOTROPY_EXT: /* size 1 */
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexParameteriv(pname=0x%x)", pname);
            return;
    }

    _mesa_TexParameteriv(target, pname, params);
}

extern void GL_APIENTRY _mesa_TexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels);
static void GL_APIENTRY _es_TexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
    switch(target) {
        case GL_TEXTURE_2D:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_X:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Y:
        case GL_TEXTURE_CUBE_MAP_POSITIVE_Z:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_X:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Y:
        case GL_TEXTURE_CUBE_MAP_NEGATIVE_Z:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexSubImage2D(target=0x%x)", target);
            return;
    }
    switch(format) {
        case GL_ALPHA:
            if (type != GL_UNSIGNED_BYTE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexSubImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGB:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_5_6_5) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexSubImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGBA:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_4_4_4_4 && type != GL_UNSIGNED_SHORT_5_5_5_1 && type != GL_UNSIGNED_INT_2_10_10_10_REV_EXT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexSubImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_LUMINANCE:
        case GL_LUMINANCE_ALPHA:
            if (type != GL_UNSIGNED_BYTE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexSubImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_DEPTH_COMPONENT:
            if (type != GL_UNSIGNED_SHORT && type != GL_UNSIGNED_INT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexSubImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_DEPTH_STENCIL_OES:
            if (type != GL_UNSIGNED_INT_24_8_OES) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexSubImage2D(format=0x%x)", format);
                return;
            }
            break;
        case GL_BGRA_EXT:
            if (type != GL_UNSIGNED_BYTE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexSubImage2D(format=0x%x)", format);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexSubImage2D(format=0x%x)", format);
            return;
    }

    _mesa_TexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
}

extern void GL_APIENTRY _mesa_TexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid * pixels);
static void GL_APIENTRY _es_TexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels)
{
    switch(target) {
        case GL_TEXTURE_3D_OES:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glTexSubImage3DOES(target=0x%x)", target);
            return;
    }
    switch(format) {
        case GL_ALPHA:
            if (type != GL_UNSIGNED_BYTE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexSubImage3DOES(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGB:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_5_6_5) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexSubImage3DOES(format=0x%x)", format);
                return;
            }
            break;
        case GL_RGBA:
            if (type != GL_UNSIGNED_BYTE && type != GL_UNSIGNED_SHORT_4_4_4_4 && type != GL_UNSIGNED_SHORT_5_5_5_1 && type != GL_UNSIGNED_INT_2_10_10_10_REV_EXT) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexSubImage3DOES(format=0x%x)", format);
                return;
            }
            break;
        case GL_LUMINANCE:
        case GL_LUMINANCE_ALPHA:
            if (type != GL_UNSIGNED_BYTE) {
                _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexSubImage3DOES(format=0x%x)", format);
                return;
            }
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_OPERATION, "glTexSubImage3DOES(format=0x%x)", format);
            return;
    }

    _mesa_TexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
}

extern void GL_APIENTRY _mesa_Uniform1fARB(GLint location, GLfloat v0);
#define _es_Uniform1f _mesa_Uniform1fARB

extern void GL_APIENTRY _mesa_Uniform1fvARB(GLint location, GLsizei count, const GLfloat * values);
#define _es_Uniform1fv _mesa_Uniform1fvARB

extern void GL_APIENTRY _mesa_Uniform1iARB(GLint location, GLint v0);
#define _es_Uniform1i _mesa_Uniform1iARB

extern void GL_APIENTRY _mesa_Uniform1ivARB(GLint location, GLsizei count, const GLint * values);
#define _es_Uniform1iv _mesa_Uniform1ivARB

extern void GL_APIENTRY _mesa_Uniform2fARB(GLint location, GLfloat v0, GLfloat v1);
#define _es_Uniform2f _mesa_Uniform2fARB

extern void GL_APIENTRY _mesa_Uniform2fvARB(GLint location, GLsizei count, const GLfloat * values);
#define _es_Uniform2fv _mesa_Uniform2fvARB

extern void GL_APIENTRY _mesa_Uniform2iARB(GLint location, GLint v0, GLint v1);
#define _es_Uniform2i _mesa_Uniform2iARB

extern void GL_APIENTRY _mesa_Uniform2ivARB(GLint location, GLsizei count, const GLint * values);
#define _es_Uniform2iv _mesa_Uniform2ivARB

extern void GL_APIENTRY _mesa_Uniform3fARB(GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
#define _es_Uniform3f _mesa_Uniform3fARB

extern void GL_APIENTRY _mesa_Uniform3fvARB(GLint location, GLsizei count, const GLfloat * values);
#define _es_Uniform3fv _mesa_Uniform3fvARB

extern void GL_APIENTRY _mesa_Uniform3iARB(GLint location, GLint v0, GLint v1, GLint v2);
#define _es_Uniform3i _mesa_Uniform3iARB

extern void GL_APIENTRY _mesa_Uniform3ivARB(GLint location, GLsizei count, const GLint * values);
#define _es_Uniform3iv _mesa_Uniform3ivARB

extern void GL_APIENTRY _mesa_Uniform4fARB(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
#define _es_Uniform4f _mesa_Uniform4fARB

extern void GL_APIENTRY _mesa_Uniform4fvARB(GLint location, GLsizei count, const GLfloat * values);
#define _es_Uniform4fv _mesa_Uniform4fvARB

extern void GL_APIENTRY _mesa_Uniform4iARB(GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
#define _es_Uniform4i _mesa_Uniform4iARB

extern void GL_APIENTRY _mesa_Uniform4ivARB(GLint location, GLsizei count, const GLint * values);
#define _es_Uniform4iv _mesa_Uniform4ivARB

extern void GL_APIENTRY _mesa_UniformMatrix2fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
#define _es_UniformMatrix2fv _mesa_UniformMatrix2fvARB

extern void GL_APIENTRY _mesa_UniformMatrix3fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
#define _es_UniformMatrix3fv _mesa_UniformMatrix3fvARB

extern void GL_APIENTRY _mesa_UniformMatrix4fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value);
#define _es_UniformMatrix4fv _mesa_UniformMatrix4fvARB

extern GLboolean GL_APIENTRY _mesa_UnmapBufferARB(GLenum target);
static GLboolean GL_APIENTRY _es_UnmapBufferOES(GLenum target)
{
    switch(target) {
        case GL_ARRAY_BUFFER:
        case GL_ELEMENT_ARRAY_BUFFER:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_ENUM, "glUnmapBufferOES(target=0x%x)", target);
            return GL_FALSE;
    }

    return _mesa_UnmapBufferARB(target);
}

extern void GL_APIENTRY _mesa_UseProgramObjectARB(GLuint program);
#define _es_UseProgram _mesa_UseProgramObjectARB

extern void GL_APIENTRY _mesa_ValidateProgramARB(GLuint program);
#define _es_ValidateProgram _mesa_ValidateProgramARB

/* this function is special and is defined elsewhere */
extern void GL_APIENTRY _es_VertexAttrib1f(GLuint index, GLfloat x);
#define _check_VertexAttrib1f _es_VertexAttrib1f

/* this function is special and is defined elsewhere */
extern void GL_APIENTRY _es_VertexAttrib1fv(GLuint index, const GLfloat * v);
#define _check_VertexAttrib1fv _es_VertexAttrib1fv

/* this function is special and is defined elsewhere */
extern void GL_APIENTRY _es_VertexAttrib2f(GLuint index, GLfloat x, GLfloat y);
#define _check_VertexAttrib2f _es_VertexAttrib2f

/* this function is special and is defined elsewhere */
extern void GL_APIENTRY _es_VertexAttrib2fv(GLuint index, const GLfloat * v);
#define _check_VertexAttrib2fv _es_VertexAttrib2fv

/* this function is special and is defined elsewhere */
extern void GL_APIENTRY _es_VertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z);
#define _check_VertexAttrib3f _es_VertexAttrib3f

/* this function is special and is defined elsewhere */
extern void GL_APIENTRY _es_VertexAttrib3fv(GLuint index, const GLfloat * v);
#define _check_VertexAttrib3fv _es_VertexAttrib3fv

/* this function is special and is defined elsewhere */
extern void GL_APIENTRY _es_VertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
#define _check_VertexAttrib4f _es_VertexAttrib4f

/* this function is special and is defined elsewhere */
extern void GL_APIENTRY _es_VertexAttrib4fv(GLuint index, const GLfloat * v);
#define _check_VertexAttrib4fv _es_VertexAttrib4fv

extern void GL_APIENTRY _mesa_VertexAttribPointerARB(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid * pointer);
static void GL_APIENTRY _es_VertexAttribPointer(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer)
{
    switch(size) {
        case 1:
        case 2:
        case 3:
        case 4:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glVertexAttribPointer(size=%d)", size);
            return;
    }
    switch(type) {
        case GL_BYTE:
        case GL_UNSIGNED_BYTE:
        case GL_SHORT:
        case GL_UNSIGNED_SHORT:
        case GL_FLOAT:
        case GL_FIXED:
            break;
        default:
            _mesa_error(_mesa_get_current_context(), GL_INVALID_VALUE, "glVertexAttribPointer(type=0x%x)", type);
            return;
    }

    _mesa_VertexAttribPointerARB(index, size, type, normalized, stride, pointer);
}

extern void GL_APIENTRY _mesa_Viewport(GLint x, GLint y, GLsizei width, GLsizei height);
#define _es_Viewport _mesa_Viewport


#include "glapi/glapi.h"

#if FEATURE_remap_table

/* define esLocalRemapTable */
#include "main/api_exec_es2_dispatch.h"

#define need_MESA_remap_table
#include "main/api_exec_es2_remap_helper.h"

static void
init_remap_table(void)
{
   _glthread_DECLARE_STATIC_MUTEX(mutex);
   static GLboolean initialized = GL_FALSE;
   const struct gl_function_pool_remap *remap = MESA_remap_table_functions;
   int i;

   _glthread_LOCK_MUTEX(mutex);
   if (initialized) {
      _glthread_UNLOCK_MUTEX(mutex);
      return;
   }

   for (i = 0; i < esLocalRemapTable_size; i++) {
      GLint offset;
      const char *spec;

      /* sanity check */
      ASSERT(i == remap[i].remap_index);
      spec = _mesa_function_pool + remap[i].pool_index;

      offset = _mesa_map_function_spec(spec);
      esLocalRemapTable[i] = offset;
   }
   initialized = GL_TRUE;
   _glthread_UNLOCK_MUTEX(mutex);
}

#else /* FEATURE_remap_table */

#include "es2api/main/dispatch.h"

static INLINE void
init_remap_table(void)
{
}

#endif /* FEATURE_remap_table */

struct _glapi_table *
_mesa_create_exec_table_es2(void)
{
   struct _glapi_table *exec;

   exec = _mesa_alloc_dispatch_table(_gloffset_COUNT);
   if (exec == NULL)
      return NULL;

   init_remap_table();

    SET_ActiveTexture(exec, _es_ActiveTexture);
    SET_AttachShader(exec, _es_AttachShader);
    SET_BindAttribLocation(exec, _es_BindAttribLocation);
    SET_BindBuffer(exec, _es_BindBuffer);
    SET_BindFramebuffer(exec, _es_BindFramebuffer);
    SET_BindRenderbuffer(exec, _es_BindRenderbuffer);
    SET_BindTexture(exec, _es_BindTexture);
    SET_BlendColor(exec, _es_BlendColor);
    SET_BlendEquation(exec, _es_BlendEquation);
    SET_BlendEquationSeparate(exec, _es_BlendEquationSeparate);
    SET_BlendFunc(exec, _es_BlendFunc);
    SET_BlendFuncSeparate(exec, _es_BlendFuncSeparate);
    SET_BufferData(exec, _es_BufferData);
    SET_BufferSubData(exec, _es_BufferSubData);
    SET_CheckFramebufferStatus(exec, _es_CheckFramebufferStatus);
    SET_Clear(exec, _es_Clear);
    SET_ClearColor(exec, _es_ClearColor);
    SET_ClearDepthf(exec, _es_ClearDepthf);
    SET_ClearStencil(exec, _es_ClearStencil);
    SET_ColorMask(exec, _es_ColorMask);
    SET_CompileShader(exec, _es_CompileShader);
    SET_CompressedTexImage2D(exec, _es_CompressedTexImage2D);
    SET_CompressedTexImage3DOES(exec, _es_CompressedTexImage3DOES);
    SET_CompressedTexSubImage2D(exec, _es_CompressedTexSubImage2D);
    SET_CompressedTexSubImage3DOES(exec, _es_CompressedTexSubImage3DOES);
    SET_CopyTexImage2D(exec, _es_CopyTexImage2D);
    SET_CopyTexSubImage2D(exec, _es_CopyTexSubImage2D);
    SET_CopyTexSubImage3DOES(exec, _es_CopyTexSubImage3DOES);
    SET_CreateProgram(exec, _es_CreateProgram);
    SET_CreateShader(exec, _es_CreateShader);
    SET_CullFace(exec, _es_CullFace);
    SET_DeleteBuffers(exec, _es_DeleteBuffers);
    SET_DeleteFramebuffers(exec, _es_DeleteFramebuffers);
    SET_DeleteProgram(exec, _es_DeleteProgram);
    SET_DeleteRenderbuffers(exec, _es_DeleteRenderbuffers);
    SET_DeleteShader(exec, _es_DeleteShader);
    SET_DeleteTextures(exec, _es_DeleteTextures);
    SET_DepthFunc(exec, _es_DepthFunc);
    SET_DepthMask(exec, _es_DepthMask);
    SET_DepthRangef(exec, _es_DepthRangef);
    SET_DetachShader(exec, _es_DetachShader);
    SET_Disable(exec, _es_Disable);
    SET_DisableVertexAttribArray(exec, _es_DisableVertexAttribArray);
    SET_DrawArrays(exec, _es_DrawArrays);
    SET_DrawBuffersNV(exec, _es_DrawBuffersNV);
    SET_DrawElements(exec, _es_DrawElements);
    SET_EGLImageTargetRenderbufferStorageOES(exec, _es_EGLImageTargetRenderbufferStorageOES);
    SET_EGLImageTargetTexture2DOES(exec, _es_EGLImageTargetTexture2DOES);
    SET_Enable(exec, _es_Enable);
    SET_EnableVertexAttribArray(exec, _es_EnableVertexAttribArray);
    SET_Finish(exec, _es_Finish);
    SET_Flush(exec, _es_Flush);
    SET_FramebufferRenderbuffer(exec, _es_FramebufferRenderbuffer);
    SET_FramebufferTexture2D(exec, _es_FramebufferTexture2D);
    SET_FramebufferTexture3DOES(exec, _es_FramebufferTexture3DOES);
    SET_FrontFace(exec, _es_FrontFace);
    SET_GenBuffers(exec, _es_GenBuffers);
    SET_GenFramebuffers(exec, _es_GenFramebuffers);
    SET_GenRenderbuffers(exec, _es_GenRenderbuffers);
    SET_GenTextures(exec, _es_GenTextures);
    SET_GenerateMipmap(exec, _es_GenerateMipmap);
    SET_GetActiveAttrib(exec, _es_GetActiveAttrib);
    SET_GetActiveUniform(exec, _es_GetActiveUniform);
    SET_GetAttachedShaders(exec, _es_GetAttachedShaders);
    SET_GetAttribLocation(exec, _es_GetAttribLocation);
    SET_GetBooleanv(exec, _es_GetBooleanv);
    SET_GetBufferParameteriv(exec, _es_GetBufferParameteriv);
    SET_GetBufferPointervOES(exec, _es_GetBufferPointervOES);
    SET_GetError(exec, _es_GetError);
    SET_GetFloatv(exec, _es_GetFloatv);
    SET_GetFramebufferAttachmentParameteriv(exec, _es_GetFramebufferAttachmentParameteriv);
    SET_GetIntegerv(exec, _es_GetIntegerv);
    SET_GetProgramInfoLog(exec, _es_GetProgramInfoLog);
    SET_GetProgramiv(exec, _es_GetProgramiv);
    SET_GetRenderbufferParameteriv(exec, _es_GetRenderbufferParameteriv);
    SET_GetShaderInfoLog(exec, _es_GetShaderInfoLog);
    SET_GetShaderPrecisionFormat(exec, _es_GetShaderPrecisionFormat);
    SET_GetShaderSource(exec, _es_GetShaderSource);
    SET_GetShaderiv(exec, _es_GetShaderiv);
    SET_GetString(exec, _es_GetString);
    SET_GetTexParameterfv(exec, _es_GetTexParameterfv);
    SET_GetTexParameteriv(exec, _es_GetTexParameteriv);
    SET_GetUniformLocation(exec, _es_GetUniformLocation);
    SET_GetUniformfv(exec, _es_GetUniformfv);
    SET_GetUniformiv(exec, _es_GetUniformiv);
    SET_GetVertexAttribPointerv(exec, _es_GetVertexAttribPointerv);
    SET_GetVertexAttribfv(exec, _es_GetVertexAttribfv);
    SET_GetVertexAttribiv(exec, _es_GetVertexAttribiv);
    SET_Hint(exec, _es_Hint);
    SET_IsBuffer(exec, _es_IsBuffer);
    SET_IsEnabled(exec, _es_IsEnabled);
    SET_IsFramebuffer(exec, _es_IsFramebuffer);
    SET_IsProgram(exec, _es_IsProgram);
    SET_IsRenderbuffer(exec, _es_IsRenderbuffer);
    SET_IsShader(exec, _es_IsShader);
    SET_IsTexture(exec, _es_IsTexture);
    SET_LineWidth(exec, _es_LineWidth);
    SET_LinkProgram(exec, _es_LinkProgram);
    SET_MapBufferOES(exec, _es_MapBufferOES);
    SET_MultiDrawArraysEXT(exec, _es_MultiDrawArraysEXT);
    SET_MultiDrawElementsEXT(exec, _es_MultiDrawElementsEXT);
    SET_PixelStorei(exec, _es_PixelStorei);
    SET_PolygonOffset(exec, _es_PolygonOffset);
    SET_ReadPixels(exec, _es_ReadPixels);
    SET_ReleaseShaderCompiler(exec, _es_ReleaseShaderCompiler);
    SET_RenderbufferStorage(exec, _check_RenderbufferStorage);
    SET_SampleCoverage(exec, _es_SampleCoverage);
    SET_Scissor(exec, _es_Scissor);
    SET_ShaderBinary(exec, _es_ShaderBinary);
    SET_ShaderSource(exec, _es_ShaderSource);
    SET_StencilFunc(exec, _es_StencilFunc);
    SET_StencilFuncSeparate(exec, _es_StencilFuncSeparate);
    SET_StencilMask(exec, _es_StencilMask);
    SET_StencilMaskSeparate(exec, _es_StencilMaskSeparate);
    SET_StencilOp(exec, _es_StencilOp);
    SET_StencilOpSeparate(exec, _es_StencilOpSeparate);
    SET_TexImage2D(exec, _es_TexImage2D);
    SET_TexImage3DOES(exec, _es_TexImage3DOES);
    SET_TexParameterf(exec, _es_TexParameterf);
    SET_TexParameterfv(exec, _es_TexParameterfv);
    SET_TexParameteri(exec, _es_TexParameteri);
    SET_TexParameteriv(exec, _es_TexParameteriv);
    SET_TexSubImage2D(exec, _es_TexSubImage2D);
    SET_TexSubImage3DOES(exec, _es_TexSubImage3DOES);
    SET_Uniform1f(exec, _es_Uniform1f);
    SET_Uniform1fv(exec, _es_Uniform1fv);
    SET_Uniform1i(exec, _es_Uniform1i);
    SET_Uniform1iv(exec, _es_Uniform1iv);
    SET_Uniform2f(exec, _es_Uniform2f);
    SET_Uniform2fv(exec, _es_Uniform2fv);
    SET_Uniform2i(exec, _es_Uniform2i);
    SET_Uniform2iv(exec, _es_Uniform2iv);
    SET_Uniform3f(exec, _es_Uniform3f);
    SET_Uniform3fv(exec, _es_Uniform3fv);
    SET_Uniform3i(exec, _es_Uniform3i);
    SET_Uniform3iv(exec, _es_Uniform3iv);
    SET_Uniform4f(exec, _es_Uniform4f);
    SET_Uniform4fv(exec, _es_Uniform4fv);
    SET_Uniform4i(exec, _es_Uniform4i);
    SET_Uniform4iv(exec, _es_Uniform4iv);
    SET_UniformMatrix2fv(exec, _es_UniformMatrix2fv);
    SET_UniformMatrix3fv(exec, _es_UniformMatrix3fv);
    SET_UniformMatrix4fv(exec, _es_UniformMatrix4fv);
    SET_UnmapBufferOES(exec, _es_UnmapBufferOES);
    SET_UseProgram(exec, _es_UseProgram);
    SET_ValidateProgram(exec, _es_ValidateProgram);
    SET_VertexAttrib1f(exec, _check_VertexAttrib1f);
    SET_VertexAttrib1fv(exec, _check_VertexAttrib1fv);
    SET_VertexAttrib2f(exec, _check_VertexAttrib2f);
    SET_VertexAttrib2fv(exec, _check_VertexAttrib2fv);
    SET_VertexAttrib3f(exec, _check_VertexAttrib3f);
    SET_VertexAttrib3fv(exec, _check_VertexAttrib3fv);
    SET_VertexAttrib4f(exec, _check_VertexAttrib4f);
    SET_VertexAttrib4fv(exec, _check_VertexAttrib4fv);
    SET_VertexAttribPointer(exec, _es_VertexAttribPointer);
    SET_Viewport(exec, _es_Viewport);

   return exec;
}

#endif /* FEATURE_ES2 */
