#!/devtool/local/bin/perl
#
# Perform the tests on a chr-Based db-Installation
#
BEGIN {
    if ($^O !~ /MSWin32/i) {
		unshift @INC, "/devtool/local/bin";
		unshift @INC, "/devtool/TOOL/tool/bin";
		unshift @INC, "/devtool/TOOL/tool/lib/perl5";
		unshift @INC, "/devtool/TOOL/tool/lib";
		unshift @INC, "/SAP_DB/TESTDB/lib";
		unshift @INC, "/SAP_DB/TESTDB";
    }
}
$| = 1;

use testdbchr;
use IniFile;
use POSIX ":sys_wait_h";

my $newpid;
my $cfg = "";

use Getopt::Long;

print "\n\nchr_clean v0.1 (c)2004, SAP AG\n\n";

my %options = ();
if (! &GetOptions(  \%options,
            'h|help|?',
	    'no_objstat',            
	    'test_profile=s',
	    'dir=s',
	    'cfg=s'
            )) {
	print("Run testdb.pl -h for help\n");
	exit(1);
}

if ($options{'test_profile'} ne "weekend") {
        $options{'test_profile'} = "workday";
}


#
# Get the .cfg-File right
#

if ($options{'cfg'}) {
	if (!(-r $options{'cfg'})) {
		print "Could not read $cfg\nExiting\n";
		exit(1);
	}
	$cfg = $options{'cfg'};
}

my $tdb;

if ($options{'dir'}) {
	
	$options{'dir'} = ($options{'dir'} =~ /^0.*/ ? $options{'dir'} : "0$options{'dir'}");
	
	print "Checking for chr $options{'dir'}..";
	
	if (-e "/SAP_DB/chr/etc/$options{'dir'}") {
		print "..OK\n";
	} else {
		print "..does not exist. Skipping...\n";
		exit(0);
	}
	
	print "Reading configuration in /SAP_DB/chr/etc/$options{'dir'}..";
	
	my $etc_ref = IniFile::load("/SAP_DB/chr/etc/$options{'dir'}");
	unless($etc_ref) {
		print "..FAILED\n";
		exit(1);
	}
		
	print "OK\nChecking configuration parameters..";
	unless ($etc_ref->{'IDMAKE'} && $etc_ref->{'IDSESSION'}) {
		print "..FAILED\n\tIDMAKE = $etc_ref->{'IDMAKE'}\n\tIDSESSION = $etc_ref->{'IDSESSION'}\n";
		exit(0);
	}
	
	print "..OK\nCreating new testdbchr-Instance..\n";
	$tdb = testdbchr->new({	'ID' => $etc_ref->{'IDMAKE'},
				'profile' => $options{'test_profile'},
				'DIR' => $options{'dir'},
				'profile' => $options{'test_profile'},
				'no_objstat' => ($options{'no_objstat'} ? 1 : 0),
				'CFG' => $cfg },
				{'ID' => $etc_ref->{'IDSESSION'}});
	print "..OK\n";
	
	$tdb->verify_chr();
	$tdb->jump_in_chr();
	$tdb->preClean();

} else {
	print "$0 - Execute the Standard-Tests in a chr-Area. Syntax:\n$0 -dir <CHR_DIRECTORY>\n";
}

exit (0);


