/* This file is part of the KDE project

   Copyright (C) 2006 KovoKs <info@kovoks.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef DATALISTVIEW_H
#define DATALISTVIEW_H

#include "mailodybaselistview.h"

namespace Mailody {


/**
 * @class DataListView
 * This class is a KListView, which manages the width of the columns in
 * a specific way: the datacolumn gains as much space as needed
 * the other columns will have a fixed width and will always be visible.
 * In general that can hold an icon or something.
 * @author Tom Albers <tomalbers@kde.nl>
 */
class DataListView : public MailodyBaseListView
{
    Q_OBJECT

    public:
        /**
         * Constructor
         * @param parent the parent widget
         * @param datacolumn the column that needs the most space
         * @param columns the amount of columns, they will be added directly,
         * so set the name with setColumnText.
         */
        explicit DataListView(QWidget* parent, int datacolumn, int columns);

        /**
         * Set the size of the not datacolumns. By default it will be 35.
         */
        void setSize(int i) { m_size = i; };

    protected:
        /**
         * Reimplemented to function the specific way it bahves at this moment
         */
        void viewportResizeEvent ( QResizeEvent * );

        /**
         * Reimplemented so it deletes items when delete is pressed
         */
        void keyPressEvent( QKeyEvent * );

    private slots:
        void slotResize();
        void slotResizeDoIt();

    private:
        QTimer*                  m_clearTimer;
        int m_datacolumn;
        int m_columns;
        int m_size;
        void deleteItem();
};

}

#endif // DATALISTVIEW
