/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file ContourAttributes.cc
    \brief Implemtation of Contour Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Mar  5 17:12:43 2012
*/    

#include "ContourAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;

template <class P>
ContourAttributes<P>::ContourAttributes():
	legend_(MagTranslator<string, bool>().magics("legend")),
	floor_(ParameterManager::getDouble("contour_interpolation_floor")),
	ceiling_(ParameterManager::getDouble("contour_interpolation_ceiling")),
	setting_(MagTranslator<string, bool>().magics("contour_automatic_setting")),
	library_path_(ParameterManager::getString("contour_automatic_library_path"))
{

	MagTranslator<string, IsoPlot<P> > contour;
	setContour(contour.magics("contour"));

	MagTranslator<string, ContourMethod<P> > method;
	setMethod(method.magics("contour_method"));

	MagTranslator<string, HiLoBase<P> > hilo;
	setHilo(hilo.magics("contour_hilo"));

	MagTranslator<string, ValuePlotBase<P> > grid;
	setGrid(grid.magics("contour_grid_value_plot"));
} 


template <class P>
ContourAttributes<P>::~ContourAttributes()
{
}

template <class P>    
void ContourAttributes<P>::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "contour";

	setAttribute(prefix, "legend", legend_, params);
	setMember(prefix, "contour", contour_, params);
	setMember(prefix, "contour_method", method_, params);
	setAttribute(prefix, "contour_interpolation_floor", floor_, params);
	setAttribute(prefix, "contour_interpolation_ceiling", ceiling_, params);
	setAttribute(prefix, "contour_automatic_setting", setting_, params);
	setAttribute(prefix, "contour_automatic_library_path", library_path_, params);
	setMember(prefix, "contour_hilo", hilo_, params);
	setMember(prefix, "contour_grid_value_plot", grid_, params);
}
template <class P>
void ContourAttributes<P>::copy(const ContourAttributes& other)
{
	legend_ = other.legend_;
	setContour(other.contour_->clone());
	setMethod(other.method_->clone());
	floor_ = other.floor_;
	ceiling_ = other.ceiling_;
	setting_ = other.setting_;
	library_path_ = other.library_path_;
	setHilo(other.hilo_->clone());
	setGrid(other.grid_->clone());
} 

template <class P>
bool ContourAttributes<P>::accept(const string& node)
{	
	if ( magCompare(node, "contour")  )
		return true;

	if ( acceptNode(node, contour_) )
		return true;

	if ( acceptNode(node, method_) )
		return true;

	if ( acceptNode(node, hilo_) )
		return true;

	if ( acceptNode(node, grid_) )
		return true;
	return false;
}
template <class P>
void ContourAttributes<P>::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "contour") )
		set(node.attributes());
	else {
		setMember(node.name(), contour_, node);
		setMember(node.name(), method_, node);
		setMember(node.name(), hilo_, node);
		setMember(node.name(), grid_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), contour_, *(*elt)); 
		setMember((*elt)->name(), method_, *(*elt)); 
		setMember((*elt)->name(), hilo_, *(*elt)); 
		setMember((*elt)->name(), grid_, *(*elt)); 
	}
}
template <class P>
void ContourAttributes<P>::print(ostream& out)  const
{
	out << "ContourAttributes[";
	out << "legend = " << legend_;
	out << ", contour = " << *contour_;
	out << ", method = " << *method_;
	out << ", floor = " << floor_;
	out << ", ceiling = " << ceiling_;
	out << ", setting = " << setting_;
	out << ", library_path = " << library_path_;
	out << ", hilo = " << *hilo_;
	out << ", grid = " << *grid_;
	out << "]" << "\n";
}

template <class P>
void ContourAttributes<P>::toxml(ostream& out, const string& tag, int tabs)  const
{
     out <<  "\"contour\"";
	 out << ", \"legend\":";
	 niceprint(out,legend_);
	 out << ", \"contour\":";
	 contour_->toxml(out, 0);
	 out << ", \"contour_method\":";
	 method_->toxml(out, 0);
	 out << ", \"contour_interpolation_floor\":";
	 niceprint(out,floor_);
	 out << ", \"contour_interpolation_ceiling\":";
	 niceprint(out,ceiling_);
	 out << ", \"contour_automatic_setting\":";
	 niceprint(out,setting_);
	 out << ", \"contour_automatic_library_path\":";
	 niceprint(out,library_path_);
	 out << ", \"contour_hilo\":";
	 hilo_->toxml(out, 0);
	 out << ", \"contour_grid_value_plot\":";
	 grid_->toxml(out, 0);
}
static MagicsParameter<string> legend("legend", "off", "");
static MagicsParameter<string> contour("contour", "on", "");
static MagicsParameter<string> contour_method("contour_method", "automatic", "");
static MagicsParameter<double> contour_interpolation_floor("contour_interpolation_floor", -INT_MAX, "");
static MagicsParameter<double> contour_interpolation_ceiling("contour_interpolation_ceiling", INT_MAX, "");
static MagicsParameter<string> contour_automatic_setting("contour_automatic_setting", "off", "");
static MagicsParameter<string> contour_automatic_library_path("contour_automatic_library_path", "", "");
static MagicsParameter<string> contour_hilo("contour_hilo", "off", "");
static MagicsParameter<string> contour_grid_value_plot("contour_grid_value_plot", "off", "");
#include "UserPoint.h"
#include "IsoPlot.h"
#include "GeoPoint.h"
static SimpleObjectMaker<IsoPlot<GeoPoint>, IsoPlot<GeoPoint> > on_IsoPlot_GeoPoint("on");
static SimpleObjectMaker<IsoPlot<GeoPoint>, IsoPlot<GeoPoint> > isoline_IsoPlot_GeoPoint("isoline");
static SimpleObjectMaker<IsoPlot<UserPoint>, IsoPlot<UserPoint> > on_IsoPlot_UserPoint("on");
static SimpleObjectMaker<IsoPlot<UserPoint>, IsoPlot<UserPoint> > isoline_IsoPlot_UserPoint("isoline");
static SimpleObjectMaker<NoIsoPlot<GeoPoint>, IsoPlot<GeoPoint> > off_NoIsoPlot_GeoPoint("off");
static SimpleObjectMaker<NoIsoPlot<GeoPoint>, IsoPlot<GeoPoint> > noisoline_NoIsoPlot_GeoPoint("noisoline");
static SimpleObjectMaker<NoIsoPlot<UserPoint>, IsoPlot<UserPoint> > off_NoIsoPlot_UserPoint("off");
static SimpleObjectMaker<NoIsoPlot<UserPoint>, IsoPlot<UserPoint> > noisoline_NoIsoPlot_UserPoint("noisoline");
#include "Akima474Method.h"
#include "ContourMethod.h"
#include "UserPoint.h"
#include "AutomaticContourMethod.h"
#include "GeoPoint.h"
#include "Akima760Method.h"
static SimpleObjectMaker<AutomaticContourMethod<GeoPoint>, ContourMethod<GeoPoint> > automatic_AutomaticContourMethod_GeoPoint("automatic");
static SimpleObjectMaker<AutomaticContourMethod<UserPoint>, ContourMethod<UserPoint> > automatic_AutomaticContourMethod_UserPoint("automatic");
static SimpleObjectMaker<SampleContourMethod<GeoPoint>, ContourMethod<GeoPoint> > sample_SampleContourMethod_GeoPoint("sample");
static SimpleObjectMaker<SampleContourMethod<UserPoint>, ContourMethod<UserPoint> > sample_SampleContourMethod_UserPoint("sample");
static SimpleObjectMaker<ContourMethod<GeoPoint>, ContourMethod<GeoPoint> > linear_ContourMethod_GeoPoint("linear");
static SimpleObjectMaker<ContourMethod<UserPoint>, ContourMethod<UserPoint> > linear_ContourMethod_UserPoint("linear");
static SimpleObjectMaker<Akima760Method<GeoPoint>, ContourMethod<GeoPoint> > akima760_Akima760Method_GeoPoint("akima760");
static SimpleObjectMaker<Akima760Method<UserPoint>, ContourMethod<UserPoint> > akima760_Akima760Method_UserPoint("akima760");
static SimpleObjectMaker<Akima474Method<GeoPoint>, ContourMethod<GeoPoint> > akima474_Akima474Method_GeoPoint("akima474");
static SimpleObjectMaker<Akima474Method<UserPoint>, ContourMethod<UserPoint> > akima474_Akima474Method_UserPoint("akima474");
#include "UserPoint.h"
#include "HiLo.h"
#include "GeoPoint.h"
static SimpleObjectMaker<HiLo<GeoPoint>, HiLoBase<GeoPoint> > on_HiLo_GeoPoint("on");
static SimpleObjectMaker<HiLo<GeoPoint>, HiLoBase<GeoPoint> > hilo_HiLo_GeoPoint("hilo");
static SimpleObjectMaker<HiLo<UserPoint>, HiLoBase<UserPoint> > on_HiLo_UserPoint("on");
static SimpleObjectMaker<HiLo<UserPoint>, HiLoBase<UserPoint> > hilo_HiLo_UserPoint("hilo");
static SimpleObjectMaker<NoHiLo<GeoPoint>, HiLoBase<GeoPoint> > off_NoHiLo_GeoPoint("off");
static SimpleObjectMaker<NoHiLo<GeoPoint>, HiLoBase<GeoPoint> > nohilo_NoHiLo_GeoPoint("nohilo");
static SimpleObjectMaker<NoHiLo<UserPoint>, HiLoBase<UserPoint> > off_NoHiLo_UserPoint("off");
static SimpleObjectMaker<NoHiLo<UserPoint>, HiLoBase<UserPoint> > nohilo_NoHiLo_UserPoint("nohilo");
static SimpleObjectMaker<HighHiLo<GeoPoint>, HiLoBase<GeoPoint> > hi_HighHiLo_GeoPoint("hi");
static SimpleObjectMaker<HighHiLo<GeoPoint>, HiLoBase<GeoPoint> > high_HighHiLo_GeoPoint("high");
static SimpleObjectMaker<HighHiLo<UserPoint>, HiLoBase<UserPoint> > hi_HighHiLo_UserPoint("hi");
static SimpleObjectMaker<HighHiLo<UserPoint>, HiLoBase<UserPoint> > high_HighHiLo_UserPoint("high");
static SimpleObjectMaker<LowHiLo<GeoPoint>, HiLoBase<GeoPoint> > lo_LowHiLo_GeoPoint("lo");
static SimpleObjectMaker<LowHiLo<GeoPoint>, HiLoBase<GeoPoint> > low_LowHiLo_GeoPoint("low");
static SimpleObjectMaker<LowHiLo<UserPoint>, HiLoBase<UserPoint> > lo_LowHiLo_UserPoint("lo");
static SimpleObjectMaker<LowHiLo<UserPoint>, HiLoBase<UserPoint> > low_LowHiLo_UserPoint("low");
#include "UserPoint.h"
#include "ValuePlot.h"
#include "GeoPoint.h"
static SimpleObjectMaker<ValuePlot<GeoPoint>, ValuePlotBase<GeoPoint> > on_ValuePlot_GeoPoint("on");
static SimpleObjectMaker<ValuePlot<GeoPoint>, ValuePlotBase<GeoPoint> > gridvalues_ValuePlot_GeoPoint("gridvalues");
static SimpleObjectMaker<ValuePlot<UserPoint>, ValuePlotBase<UserPoint> > on_ValuePlot_UserPoint("on");
static SimpleObjectMaker<ValuePlot<UserPoint>, ValuePlotBase<UserPoint> > gridvalues_ValuePlot_UserPoint("gridvalues");
static SimpleObjectMaker<NoValuePlot<GeoPoint>, ValuePlotBase<GeoPoint> > off_NoValuePlot_GeoPoint("off");
static SimpleObjectMaker<NoValuePlot<GeoPoint>, ValuePlotBase<GeoPoint> > nogridvalues_NoValuePlot_GeoPoint("nogridvalues");
static SimpleObjectMaker<NoValuePlot<UserPoint>, ValuePlotBase<UserPoint> > off_NoValuePlot_UserPoint("off");
static SimpleObjectMaker<NoValuePlot<UserPoint>, ValuePlotBase<UserPoint> > nogridvalues_NoValuePlot_UserPoint("nogridvalues");
