/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisGridAttributes.cc
    \brief Implemtation of AxisGrid Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Mar  5 17:12:46 2012
*/    

#include "AxisGridAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


AxisGridAttributes::AxisGridAttributes():
	colour_(MagTranslator<string, Colour>().magics("axis_grid_colour")),
	thickness_(ParameterManager::getInt("axis_grid_thickness")),
	style_(MagTranslator<string, LineStyle>().magics("axis_grid_line_style")),
	reference_level_(ParameterManager::getDouble("axis_grid_reference_level")),
	reference_thickness_(ParameterManager::getInt("axis_grid_reference_thickness")),
	reference_style_(MagTranslator<string, LineStyle>().magics("axis_grid_reference_line_style")),
	reference_colour_(MagTranslator<string, Colour>().magics("axis_grid_reference_colour"))
{
} 



AxisGridAttributes::~AxisGridAttributes()
{
}

    
void AxisGridAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "axis_grid";
	prefix[1] = "axis";

	setAttribute(prefix, "axis_grid_colour", colour_, params);
	setAttribute(prefix, "axis_grid_thickness", thickness_, params);
	setAttribute(prefix, "axis_grid_line_style", style_, params);
	setAttribute(prefix, "axis_grid_reference_level", reference_level_, params);
	setAttribute(prefix, "axis_grid_reference_thickness", reference_thickness_, params);
	setAttribute(prefix, "axis_grid_reference_line_style", reference_style_, params);
	setAttribute(prefix, "axis_grid_reference_colour", reference_colour_, params);
}

void AxisGridAttributes::copy(const AxisGridAttributes& other)
{
	setColour(other.colour_->clone());
	thickness_ = other.thickness_;
	style_ = other.style_;
	reference_level_ = other.reference_level_;
	reference_thickness_ = other.reference_thickness_;
	reference_style_ = other.reference_style_;
	setReference_colour(other.reference_colour_->clone());
} 


bool AxisGridAttributes::accept(const string& node)
{	
	if ( magCompare(node, "grid")  )
		return true;
	return false;
}

void AxisGridAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "grid") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void AxisGridAttributes::print(ostream& out)  const
{
	out << "AxisGridAttributes[";
	out << "colour = " << *colour_;
	out << ", thickness = " << thickness_;
	out << ", style = " << style_;
	out << ", reference_level = " << reference_level_;
	out << ", reference_thickness = " << reference_thickness_;
	out << ", reference_style = " << reference_style_;
	out << ", reference_colour = " << *reference_colour_;
	out << "]" << "\n";
}


void AxisGridAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
     out <<  "\"grid\"";
	 out << ", \"axis_grid_colour\":";
	 niceprint(out, *colour_);
	 out << ", \"axis_grid_thickness\":";
	 niceprint(out,thickness_);
	 out << ", \"axis_grid_line_style\":";
	 niceprint(out,style_);
	 out << ", \"axis_grid_reference_level\":";
	 niceprint(out,reference_level_);
	 out << ", \"axis_grid_reference_thickness\":";
	 niceprint(out,reference_thickness_);
	 out << ", \"axis_grid_reference_line_style\":";
	 niceprint(out,reference_style_);
	 out << ", \"axis_grid_reference_colour\":";
	 niceprint(out, *reference_colour_);
}
static MagicsParameter<string> axis_grid_colour("axis_grid_colour", "yellow", "2.13.5 - Default changed fronm YELLOW to BLACK");
static MagicsParameter<int> axis_grid_thickness("axis_grid_thickness", 1, "");
static MagicsParameter<string> axis_grid_line_style("axis_grid_line_style", "solid", "");
static MagicsParameter<double> axis_grid_reference_level("axis_grid_reference_level", INT_MAX, "");
static MagicsParameter<int> axis_grid_reference_thickness("axis_grid_reference_thickness", 2, "");
static MagicsParameter<string> axis_grid_reference_line_style("axis_grid_reference_line_style", "solid", "");
static MagicsParameter<string> axis_grid_reference_colour("axis_grid_reference_colour", "automatic", "");
