/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file MagnifierVisitorAttributes.h
    \brief Definition of MagnifierVisitor Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:45 2012
*/
   

#ifndef MagnifierVisitorAttributes_H
#define MagnifierVisitorAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class MagnifierVisitorAttributes 
{
public:
//  --  constructor
    MagnifierVisitorAttributes();
    
//  --  destructor
    virtual ~MagnifierVisitorAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const MagnifierVisitorAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Mv4: Symbol used in the magnifier 
    \param symbol_name Setting magnifier_symbol_name - default=magics_3
*/
	void setSymbol_name(const string& symbol_name) 
		{ symbol_name_ =  symbol_name; } 
	const string& getSymbol_name() const 
		{ return symbol_name_; } 
        
/*!
    Magics Information:
    \brief  Mv4: Symbol used in the magnifier 
    \param hidden_symbol_name Setting magnifier_hidden_symbol_name - default=magics_3
*/
	void setHidden_symbol_name(const string& hidden_symbol_name) 
		{ hidden_symbol_name_ =  hidden_symbol_name; } 
	const string& getHidden_symbol_name() const 
		{ return hidden_symbol_name_; } 
        
/*!
    Magics Information:
    \brief  Mv4: Colour of the symbol in the magnifier 
    \param symbol_colour Setting magnifier_symbol_colour - default=red
*/
	void setSymbol_colour(Colour* symbol_colour) 
		{ auto_ptr<Colour> tmp(symbol_colour); symbol_colour_ = tmp; } 
	const Colour&  getSymbol_colour() const 
		{ return *symbol_colour_; }
/*!
    Magics Information:
    \brief  Mv4: Colour of the symbol in the magnifier 
    \param hidden_symbol_colour Setting magnifier_hidden_symbol_colour - default=navy
*/
	void setHidden_symbol_colour(Colour* hidden_symbol_colour) 
		{ auto_ptr<Colour> tmp(hidden_symbol_colour); hidden_symbol_colour_ = tmp; } 
	const Colour&  getHidden_symbol_colour() const 
		{ return *hidden_symbol_colour_; }
/*!
    Magics Information:
    \brief  Mv4: Colour of the symbol in the magnifier 
    \param symbol_height Setting magnifier_symbol_height - default=0.2
*/
	void setSymbol_height(double symbol_height) 
		{ symbol_height_ =  symbol_height; } 
	double getSymbol_height() const 
		{ return symbol_height_; } 
        
/*!
    Magics Information:
    \brief  Mv4: Colour of the symbol in the magnifier 
    \param hidden_symbol_height Setting magnifier_hidden_symbol_height - default=0.1
*/
	void setHidden_symbol_height(double hidden_symbol_height) 
		{ hidden_symbol_height_ =  hidden_symbol_height; } 
	double getHidden_symbol_height() const 
		{ return hidden_symbol_height_; } 
        
/*!
    Magics Information:
    \brief  Mv4: Colour of the symbol in the magnifier 
    \param text_font_name Setting magnifier_text_font_name - default=sanserif
*/
	void setText_font_name(const string& text_font_name) 
		{ text_font_name_ =  text_font_name; } 
	const string& getText_font_name() const 
		{ return text_font_name_; } 
        
/*!
    Magics Information:
    \brief  Mv4: Colour of the symbol in the magnifier 
    \param text_font_size Setting magnifier_text_font_size - default=0.2
*/
	void setText_font_size(double text_font_size) 
		{ text_font_size_ =  text_font_size; } 
	double getText_font_size() const 
		{ return text_font_size_; } 
        
/*!
    Magics Information:
    \brief  Mv4: Colour of the symbol in the magnifier 
    \param text_font_colour Setting magnifier_text_font_colour - default=navy
*/
	void setText_font_colour(Colour* text_font_colour) 
		{ auto_ptr<Colour> tmp(text_font_colour); text_font_colour_ = tmp; } 
	const Colour&  getText_font_colour() const 
		{ return *text_font_colour_; }
/*!
    Magics Information:
    \brief  Mv4: Colour of the symbol in the magnifier 
    \param text_format Setting magnifier_text_format - default=(automatic)
*/
	void setText_format(const string& text_format) 
		{ text_format_ =  text_format; } 
	const string& getText_format() const 
		{ return text_format_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string symbol_name_;
	string hidden_symbol_name_;
	auto_ptr<Colour> symbol_colour_;
	auto_ptr<Colour> hidden_symbol_colour_;
	double symbol_height_;
	double hidden_symbol_height_;
	string text_font_name_;
	double text_font_size_;
	auto_ptr<Colour> text_font_colour_;
	string text_format_;

private:
  
	friend ostream& operator<<(ostream& s,const MagnifierVisitorAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
