/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension.resolvers;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.optional.extension.Extension;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionResolver;

public class AntResolver
implements ExtensionResolver {
    private File m_antfile;
    private File m_destfile;
    private String m_target;

    public void setAntfile(File antfile) {
        this.m_antfile = antfile;
    }

    public void setDestfile(File destfile) {
        this.m_destfile = destfile;
    }

    public void setTarget(String target) {
        this.m_target = target;
    }

    public File resolve(Extension extension, Project project) throws BuildException {
        this.validate();
        Ant ant = (Ant)project.createTask("ant");
        ant.setInheritAll(false);
        ant.setAntfile(this.m_antfile.getName());
        try {
            File dir = this.m_antfile.getParentFile().getCanonicalFile();
            ant.setDir(dir);
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage(), (Throwable)ioe);
        }
        if (null != this.m_target) {
            ant.setTarget(this.m_target);
        }
        ant.execute();
        return this.m_destfile;
    }

    private void validate() {
        if (null == this.m_antfile) {
            throw new BuildException("Must specify Buildfile");
        }
        if (null == this.m_destfile) {
            throw new BuildException("Must specify destination file");
        }
    }

    public String toString() {
        return "Ant[" + this.m_antfile + "==>" + this.m_destfile + "]";
    }
}

