/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax2;

import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax2.HTMLOutputHandler;
import com.jclark.xsl.sax2.NXMLOutputHandler;
import com.jclark.xsl.sax2.OutputContentHandler;
import com.jclark.xsl.sax2.OutputMethodHandler;
import com.jclark.xsl.sax2.TextOutputHandler;
import com.jclark.xsl.sax2.XMLOutputHandler;
import java.io.IOException;
import java.util.Properties;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OutputMethodHandlerImpl
implements OutputMethodHandler {
    private Destination dest;
    private static final String JAVA_OUTPUT_METHOD = "http://www.jclark.com/xt/java";

    public OutputMethodHandler createOutputMethodHandler(String uri) {
        Destination d = this.dest.resolve(uri);
        if (d == null) {
            return null;
        }
        OutputMethodHandlerImpl om = new OutputMethodHandlerImpl();
        om.setDestination(d);
        return om;
    }

    public void setDestination(Destination dest) {
        this.dest = dest;
    }

    public ContentHandler createContentHandler(String name, Properties atts) throws SAXException, IOException {
        ContentHandler handler = null;
        if (name != null) {
            if (name.startsWith(JAVA_OUTPUT_METHOD) && name.lastIndexOf(94) == JAVA_OUTPUT_METHOD.length()) {
                try {
                    Class<?> cls = Class.forName(name.substring(JAVA_OUTPUT_METHOD.length() + 1));
                    handler = (ContentHandler)cls.newInstance();
                }
                catch (ClassNotFoundException e) {
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (ClassCastException e) {}
            } else if (name.equals("http://www.jclark.com/xt^nxml")) {
                handler = new NXMLOutputHandler();
            } else if (name.equals("html")) {
                handler = new HTMLOutputHandler();
            } else if (name.equals("text")) {
                handler = new TextOutputHandler();
            }
        }
        if (handler == null) {
            handler = new XMLOutputHandler();
        }
        if (handler instanceof OutputContentHandler) {
            handler = ((OutputContentHandler)handler).init(this.dest, atts);
        }
        return handler;
    }
}

