/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.BooleanVariant;
import com.jclark.xsl.expr.Converter;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.NodeSetVariant;
import com.jclark.xsl.expr.NumberVariant;
import com.jclark.xsl.expr.ObjectVariant;
import com.jclark.xsl.expr.SingleNodeIterator;
import com.jclark.xsl.expr.StringVariant;
import com.jclark.xsl.expr.Variant;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.XSLException;

public abstract class VariantBase
implements Variant {
    public Variant makePermanent() throws XSLException {
        return this;
    }

    public NodeIterator convertToNodeSet() throws XSLException {
        throw new XSLException("cannot convert to node-set");
    }

    public double convertToNumber() throws XSLException {
        return Converter.toNumber(this.convertToString());
    }

    public boolean convertToPredicate(ExprContext context) throws XSLException {
        return this.convertToBoolean();
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isNodeSet() {
        return false;
    }

    public static Variant create(Object obj) {
        if (obj instanceof String) {
            return new StringVariant((String)obj);
        }
        if (obj instanceof Number) {
            return new NumberVariant(((Number)obj).doubleValue());
        }
        if (obj instanceof Boolean) {
            return new BooleanVariant((Boolean)obj);
        }
        if (obj instanceof NodeIterator) {
            return new NodeSetVariant((NodeIterator)obj);
        }
        if (obj instanceof Node) {
            return new NodeSetVariant(new SingleNodeIterator((Node)obj));
        }
        if (obj instanceof Variant) {
            return (Variant)obj;
        }
        return new ObjectVariant(obj);
    }

    public Node getBaseNode() {
        return null;
    }
}

