/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.ConvertibleExpr;
import com.jclark.xsl.expr.ConvertibleNumberExpr;
import com.jclark.xsl.expr.ConvertibleStringExpr;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.Function;
import com.jclark.xsl.expr.NumberConstantExpr;
import com.jclark.xsl.expr.ParseException;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;

class SubstringFunction
implements Function {
    SubstringFunction() {
    }

    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] args, Node exprNode) throws ParseException {
        if (args.length < 2 || args.length > 3) {
            throw new ParseException("expected 2 or 3 arguments");
        }
        final ConvertibleStringExpr se = args[0].makeStringExpr();
        final ConvertibleNumberExpr ne1 = args[1].makeNumberExpr();
        final ConvertibleNumberExpr ne2 = args.length == 2 ? new NumberConstantExpr(Double.POSITIVE_INFINITY) : args[2].makeNumberExpr();
        return new ConvertibleStringExpr(){

            public String eval(Node node, ExprContext context) throws XSLException {
                return SubstringFunction.substring(se.eval(node, context), ne1.eval(node, context), ne2.eval(node, context));
            }
        };
    }

    private static final String substring(String str, double start, double len) {
        start = Math.floor(start + 0.5);
        double end = start + Math.floor(len + 0.5);
        int strLen = str.length();
        int pos = 1;
        int firstIndex = -1;
        int lastIndex = -1;
        int i = 0;
        while (i < strLen) {
            if ((double)pos >= start && (double)pos < end) {
                if (firstIndex < 0) {
                    firstIndex = i;
                }
                if (SubstringFunction.isLowSurrogate(str.charAt(i))) {
                    // empty if block
                }
                lastIndex = ++i;
            } else if (SubstringFunction.isLowSurrogate(str.charAt(i))) {
                ++i;
            }
            ++i;
            ++pos;
        }
        if (firstIndex >= 0) {
            return str.substring(firstIndex, lastIndex + 1);
        }
        return "";
    }

    private static final boolean isLowSurrogate(char c) {
        return (c & 0xFC00) == 55296;
    }
}

