/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.Converter;
import com.jclark.xsl.expr.ConvertibleExpr;
import com.jclark.xsl.expr.ConvertibleNodeSetExpr;
import com.jclark.xsl.expr.ConvertibleStringExpr;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.Function;
import com.jclark.xsl.expr.MergeNodeIterator;
import com.jclark.xsl.expr.NodeSetExpr;
import com.jclark.xsl.expr.ParseException;
import com.jclark.xsl.expr.SingleNodeIterator;
import com.jclark.xsl.expr.Variant;
import com.jclark.xsl.expr.VariantExpr;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.XSLException;

class DocumentFunction
implements Function {
    DocumentFunction() {
    }

    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] args, final Node exprNode) throws ParseException {
        ConvertibleNodeSetExpr base;
        if (args.length != 1 && args.length != 2) {
            throw new ParseException("expected one or two arguments");
        }
        ConvertibleExpr e = args[0];
        ConvertibleNodeSetExpr convertibleNodeSetExpr = base = args.length == 1 ? null : args[1].makeNodeSetExpr();
        if (e instanceof NodeSetExpr) {
            final NodeSetExpr nse = (NodeSetExpr)((Object)e);
            return new ConvertibleNodeSetExpr(){

                public NodeIterator eval(Node node, ExprContext context) throws XSLException {
                    return DocumentFunction.document(context, nse.eval(node, context), base == null ? null : base.eval(node, context).next());
                }
            };
        }
        if (e instanceof VariantExpr) {
            final VariantExpr ve = (VariantExpr)((Object)e);
            return new ConvertibleNodeSetExpr(){

                public NodeIterator eval(Node node, ExprContext context) throws XSLException {
                    Variant v = ve.eval(node, context);
                    if (v.isNodeSet()) {
                        return DocumentFunction.document(context, v.convertToNodeSet(), base == null ? null : base.eval(node, context).next());
                    }
                    Node baseNode = v.getBaseNode();
                    if (baseNode == null) {
                        baseNode = exprNode;
                    }
                    return DocumentFunction.document(context, v.convertToString(), base == null ? baseNode : base.eval(node, context).next());
                }
            };
        }
        final ConvertibleStringExpr se = e.makeStringExpr();
        return new ConvertibleNodeSetExpr(){

            public NodeIterator eval(Node node, ExprContext context) throws XSLException {
                return DocumentFunction.document(context, se.eval(node, context), base == null ? exprNode : base.eval(node, context).next());
            }
        };
    }

    private static final NodeIterator document(ExprContext context, NodeIterator iter, Node baseNode) throws XSLException {
        Node node;
        NodeIterator[] iters = new NodeIterator[1];
        int len = 0;
        while ((node = iter.next()) != null) {
            if (len == iters.length) {
                NodeIterator[] oldIters = iters;
                iters = new NodeIterator[iters.length * 2];
                System.arraycopy(oldIters, 0, iters, 0, oldIters.length);
            }
            iters[len++] = DocumentFunction.document(context, Converter.toString(node), baseNode == null ? node : baseNode);
        }
        if (len > 1) {
            return new MergeNodeIterator(iters, len);
        }
        if (len == 1) {
            return iters[0];
        }
        return new SingleNodeIterator(null);
    }

    private static final NodeIterator document(ExprContext context, String urlRef, Node baseNode) throws XSLException {
        return context.getDocument(baseNode == null ? null : baseNode.getURL(), urlRef);
    }
}

